/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalAttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class AttributeOverride
extends AbstractExternalForm
implements ExternalAttributeOverride {
    private int index;

    AttributeOverride(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    private EntityColumn buildColumn(int index) {
        return new EntityColumn(this, "column", index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public ExternalEntityColumn getColumn() {
        if (this.hasChild("column", this.index)) {
            return this.buildColumn(this.index);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "attribute-override";
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public void removeColumn(int index) {
        EntityColumn column = this.buildColumn(index);
        column.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setColumn(String name) {
        EntityColumn column = this.buildColumn(this.index);
        if (name == null) {
            column.removeSelf();
        } else {
            column.setName(name);
        }
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }
}

