/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalFormHelper;
import org.eclipse.persistence.tools.mapping.orm.ORMDocumentType;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceConfiguration;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultFormHelper
implements ExternalFormHelper {
    private final Document document;
    private final URL location;

    public DefaultFormHelper(Document document, URL location) {
        this.document = document;
        this.location = location;
    }

    @Override
    public void acquireReadLock() {
    }

    @Override
    public Element addChild(AbstractExternalForm externalForm, Element element, String elementName, List<String> elementNamesOrder) {
        Element childElement = this.document.createElement(elementName);
        Element elementOfInsertion = externalForm.elementOfInsertion(element, elementName, elementNamesOrder);
        element.insertBefore(childElement, elementOfInsertion);
        return childElement;
    }

    @Override
    public Element addChildTextNode(AbstractExternalForm externalForm, Element element, String elementName, String value, List<String> elementNamesOrder) {
        Element childElement = this.getDocument().createElement(elementName);
        Text text = this.getDocument().createTextNode(value);
        text.setNodeValue(value);
        childElement.appendChild(text);
        Element elementOfInsertion = externalForm.elementOfInsertion(element, elementName, elementNamesOrder);
        element.insertBefore(childElement, elementOfInsertion);
        return childElement;
    }

    @Override
    public Element buildORMConfiguration(ORMConfiguration orm) {
        Element element = this.document.createElementNS("http://www.eclipse.org/eclipselink/xsds/persistence/orm", orm.getElementName());
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.eclipse.org/eclipselink/xsds/persistence/orm");
        orm.addXmlns(element, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", orm.buildSchemaLocation(ORMDocumentType.ECLIPELINK_2_6));
        element.setAttribute("version", orm.getBuildVersion());
        this.document.appendChild(element);
        return element;
    }

    @Override
    public Element buildPersistenceConfiguration(PersistenceConfiguration persistence) {
        Element element = this.document.createElementNS("http://java.sun.com/xml/ns/persistence", persistence.getElementName());
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/persistence");
        persistence.addXmlns(element, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", persistence.buildSchemaLocation(PersistenceDocumentType.JPA_2_1));
        element.setAttribute("version", persistence.getBuildVersion());
        this.document.appendChild(element);
        return element;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public TextRange getElementNameTextRange(AbstractExternalForm externalForm, Element element) {
        throw new IllegalAccessError("Not supported");
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public URL getSourceRoot() {
        throw new IllegalAccessError("Not supported");
    }

    @Override
    public TextRange getTextNodeTextRange(AbstractExternalForm externalForm, Node node) {
        throw new IllegalAccessError("Not supported");
    }

    @Override
    public TextRange getTextRange(AbstractExternalForm externalForm, Node node) {
        throw new IllegalAccessError("Not supported");
    }

    @Override
    public void releaseReadLock() {
    }

    @Override
    public void remove(AbstractExternalForm externalForm, Element element, Element childElement) {
        element.removeChild(childElement);
    }

    @Override
    public void removeChildren(AbstractExternalForm externalForm, Node node, String elementName) {
        for (Element childElement : externalForm.getChildren(node, elementName)) {
            node.removeChild(childElement);
        }
    }

    @Override
    public void save() throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        FileOutputStream outputStream = new FileOutputStream(new File(this.location.toURI()));
        BufferedOutputStream output = new BufferedOutputStream(outputStream);
        try {
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        finally {
            output.close();
        }
    }

    @Override
    public void setAttribute(AbstractExternalForm externalForm, Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        if (value == null) {
            element.removeAttribute(attributeName);
        } else if (externalForm.hasAttribute(attributeName)) {
            element.setAttribute(attributeName, value);
        } else {
            Attr newAttribute = this.getDocument().createAttribute(attributeName);
            newAttribute.setValue(value);
            List<Attr> attributes = externalForm.getAttributes(element);
            Attr elementOfInsertion = (Attr)externalForm.nodeOfInsertion(element, attributes, attributeName, attributeNamesOrder);
            if (elementOfInsertion != null) {
                int indexOfInsertion = attributes.indexOf(elementOfInsertion);
                int index = attributes.size();
                while (--index >= 0) {
                    Node attributeNode = attributes.get(index);
                    element.removeAttribute(attributeNode.getNodeName());
                }
                attributes.add(indexOfInsertion, newAttribute);
                index = 0;
                while (index < attributes.size()) {
                    Attr attribute = attributes.get(index);
                    element.setAttributeNode(attribute);
                    ++index;
                }
            } else {
                element.setAttributeNode(newAttribute);
            }
        }
    }

    @Override
    public void setAttributeNS(AbstractExternalForm externalForm, Element element, String attributeName, String value, List<String> attributeNamesOrder) {
        if (value == null) {
            element.removeAttributeNS("http://www.w3.org/2001/XMLSchema-instance", attributeName);
        } else if (externalForm.hasAttribute(attributeName)) {
            attributeName = externalForm.buildQualifiedName(attributeName);
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", attributeName, value);
        } else {
            attributeName = externalForm.buildQualifiedName(attributeName);
            Attr newAttribute = this.getDocument().createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", attributeName);
            newAttribute.setValue(value);
            List<Attr> attributes = externalForm.getAttributes(element);
            Attr elementOfInsertion = (Attr)externalForm.nodeOfInsertion(element, attributes, attributeName, attributeNamesOrder);
            if (elementOfInsertion != null) {
                int indexOfInsertion = attributes.indexOf(elementOfInsertion);
                int index = attributes.size();
                while (--index >= 0) {
                    Node attributeNode = attributes.get(index);
                    element.removeAttribute(attributeNode.getNodeName());
                }
                attributes.add(indexOfInsertion, newAttribute);
                index = 0;
                int count = attributes.size();
                while (index < count) {
                    Attr attribute = attributes.get(index);
                    element.setAttributeNode(attribute);
                    ++index;
                }
            } else {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", attributeName, value);
            }
        }
    }

    @Override
    public void setElementName(AbstractExternalForm externalForm, Element element, String elementName, List<String> elementNamesOrder) {
        this.getDocument().removeChild(element);
        Element newElement = externalForm.addSelf(elementName, elementNamesOrder);
        for (Node childNode : externalForm.getAllChildren(element)) {
            newElement.appendChild(childNode);
        }
    }

    @Override
    public void setNamespace(AbstractExternalForm externalForm, String uri) {
        Element rootElement = externalForm.getRootElement();
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
    }

    @Override
    public void setSchemaLocation(AbstractExternalForm externalForm, String uri) {
        Element rootElement = externalForm.getRootElement();
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", uri);
    }

    @Override
    public void updateTextNode(AbstractExternalForm externalForm, String elementName, Element childElement, String value) {
        Text text = externalForm.findTextNode(childElement);
        if (text == null) {
            text = this.getDocument().createTextNode(value);
            childElement.appendChild(text);
        } else {
            text.setNodeValue(value);
        }
    }
}

