/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterable.ArrayListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.SingleElementListIterable;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.iterator.TransformationListIterator;

public class ReadOnlyCompositeListIterable<E>
implements ListIterable<E> {
    private final ListIterable<? extends ListIterable<? extends E>> iterables;

    public ReadOnlyCompositeListIterable(ListIterable<? extends ListIterable<? extends E>> iterables) {
        if (iterables == null) {
            throw new NullPointerException();
        }
        this.iterables = iterables;
    }

    public ReadOnlyCompositeListIterable(E object, ListIterable<? extends E> iterable) {
        this(new ListIterable[]{new SingleElementListIterable<E>(object), iterable});
    }

    public ReadOnlyCompositeListIterable(ListIterable<? extends E> iterable, E object) {
        this(new ListIterable[]{iterable, new SingleElementListIterable<E>(object)});
    }

    public ReadOnlyCompositeListIterable(ListIterable<? extends E> ... iterables) {
        this((ListIterable<ListIterable<? extends E>>)new ArrayListIterable<ListIterable<? extends E>>(iterables));
    }

    @Override
    public ListIterator<E> iterator() {
        return IteratorTools.readOnlyCompositeListIterator(this.iterators());
    }

    protected ListIterator<? extends ListIterator<? extends E>> iterators() {
        return new TransformationListIterator<ListIterable<? extends E>, ListIterator<? extends E>>(this.iterables()){

            @Override
            protected ListIterator<? extends E> transform(ListIterable<? extends E> next) {
                return next.iterator();
            }
        };
    }

    protected ListIterator<? extends ListIterable<? extends E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

