/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UrlUtil {
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAR_PROTOCOL = "jar";

    public static boolean isFileUrl(URL url) {
        return url != null && FILE_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isJarUrl(URL url) {
        return url != null && JAR_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isHttpUrl(URL url) {
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        return HTTP_PROTOCOL.equals(protocol) || HTTPS_PROTOCOL.equals(protocol);
    }

    public static File getUrlFile(URL url) {
        if (UrlUtil.isFileUrl(url) && !UrlUtil.isJarUrl(url)) {
            File ret = new File(url.getFile());
            return ret;
        }
        return null;
    }

    public static URL getJarFileUrl(URL url) {
        if (!UrlUtil.isJarUrl(url)) {
            return null;
        }
        String file = url.getFile();
        int index = file.indexOf(33);
        if (index < 0) {
            return null;
        }
        String jarFileUrlStr = file.substring(0, index);
        try {
            return new URL(jarFileUrlStr);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean isRemote(String url) {
        return url.startsWith("http:") || url.startsWith("https:") || url.startsWith("www.");
    }
}

