/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.persistence.tools.gen.internal.ORMGenCustomizer;
import org.eclipse.persistence.tools.gen.internal.ORMGenTable;

public class MappingFileGenerator {
    private final ORMGenCustomizer customizer;

    public static String generate(ORMGenCustomizer customizer) {
        MappingFileGenerator generator = new MappingFileGenerator(customizer);
        try {
            return generator.generateMappingFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating entities", e);
        }
    }

    private MappingFileGenerator(ORMGenCustomizer customizer) {
        this.customizer = customizer;
    }

    private Object getCustomizer() {
        return this.customizer;
    }

    protected String generateMappingFile() throws Exception {
        List<String> tableNames = this.customizer.getGenTableNames();
        try {
            Properties vep = new Properties();
            vep.setProperty("resource.loader", "class");
            vep.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            VelocityEngine ve = new VelocityEngine();
            ve.init(vep);
            StringBuilder xmlFileContents = new StringBuilder();
            xmlFileContents.append(this.generateXmlHeaderFooter(ve, "header.vm"));
            Iterator<String> names = tableNames.iterator();
            while (names.hasNext()) {
                ORMGenTable table = this.customizer.getTable(names.next());
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "namedQuery.vm"));
            }
            ArrayList<ORMGenTable> compositeKeyTables = new ArrayList<ORMGenTable>();
            Iterator<String> names2 = tableNames.iterator();
            while (names2.hasNext()) {
                ORMGenTable table = this.customizer.getTable(names2.next());
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "main.xml.vm"));
                if (!table.isCompositeKey()) continue;
                compositeKeyTables.add(table);
            }
            for (ORMGenTable table : compositeKeyTables) {
                if (!table.isCompositeKey()) continue;
                xmlFileContents.append(this.generateXmlTypeMetadata(table, ve, "embeddable.vm"));
            }
            xmlFileContents.append(this.generateXmlHeaderFooter(ve, "footer.vm"));
            return xmlFileContents.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException("Entity generation failed", e);
        }
    }

    private String generateXmlHeaderFooter(VelocityEngine ve, String templateName) throws Exception {
        StringWriter stringWriter = new StringWriter();
        VelocityContext context = new VelocityContext();
        ve.mergeTemplate(templateName, (Context)context, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private String generateXmlTypeMetadata(ORMGenTable table, VelocityEngine ve, String templateName) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("customizer", this.getCustomizer());
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, (Context)context, (Writer)w);
        return w.toString();
    }
}

