/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db;

import java.util.Iterator;
import org.eclipse.persistence.tools.db.EclipseLinkColumn;
import org.eclipse.persistence.tools.db.EclipseLinkDatabase;
import org.eclipse.persistence.tools.db.EclipseLinkForeignKey;
import org.eclipse.persistence.tools.db.EclipseLinkSchema;
import org.eclipse.persistence.tools.db.model.ELColumn;
import org.eclipse.persistence.tools.db.model.ELReference;
import org.eclipse.persistence.tools.db.model.ELTable;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ConnectionProfile;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.utility.iterable.TransformationIterable;

public class EclipseLinkTable
implements Table {
    private EclipseLinkSchema parent;
    private ELTable table;

    public EclipseLinkTable(EclipseLinkSchema parent, ELTable table) {
        this.table = table;
        this.parent = parent;
    }

    private String buildDefaultJoinTableName() {
        return String.valueOf(this.getJoinTableOwningTable().getName()) + '_' + this.getJoinTableNonOwningTable().getName();
    }

    public Column getColumnForIdentifier(String identifier) {
        return this.getColumnNamed(identifier);
    }

    public Column getColumnNamed(String name) {
        ELColumn column = this.table.columnNamed(name);
        if (column != null) {
            return new EclipseLinkColumn(this, column);
        }
        return null;
    }

    public Iterable<Column> getColumns() {
        return new TransformationIterable<ELColumn, Column>(this.table.columns()){

            protected Column transform(ELColumn column) {
                return new EclipseLinkColumn(EclipseLinkTable.this, column);
            }
        };
    }

    public int getColumnsSize() {
        return this.table.columnsSize();
    }

    public ConnectionProfile getConnectionProfile() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public EclipseLinkDatabase getDatabase() {
        return this.parent.getDatabase();
    }

    public Iterable<ForeignKey> getForeignKeys() {
        return new TransformationIterable<ELReference, ForeignKey>(this.table.references()){

            protected ForeignKey transform(ELReference reference) {
                return new EclipseLinkForeignKey(EclipseLinkTable.this, reference);
            }
        };
    }

    public int getForeignKeysSize() {
        return this.table.referencesSize();
    }

    public String getIdentifier() {
        return this.getDatabase().convertNameToIdentifier(this.getName());
    }

    public String getIdentifier(String defaultName) {
        return this.getDatabase().getIdentifier(this.getName(), defaultName);
    }

    public ForeignKey getJoinTableNonOwningForeignKey() {
        if (this.isPossibleJoinTable()) {
            Iterator<ELReference> references = this.table.references().iterator();
            ELReference fk0 = references.next();
            String name0 = fk0.getTargetTable().getName();
            ELReference fk1 = references.next();
            String name1 = fk1.getTargetTable().getName();
            return !this.getName().equals(String.valueOf(name1) + '_' + name0) ? new EclipseLinkForeignKey(this, fk1) : new EclipseLinkForeignKey(this, fk0);
        }
        return null;
    }

    private Table getJoinTableNonOwningTable() {
        return this.getJoinTableNonOwningForeignKey().getReferencedTable();
    }

    public ForeignKey getJoinTableOwningForeignKey() {
        if (this.isPossibleJoinTable()) {
            Iterator<ELReference> references = this.table.references().iterator();
            ELReference fk0 = references.next();
            String name0 = fk0.getTargetTable().getName();
            ELReference fk1 = references.next();
            String name1 = fk1.getTargetTable().getName();
            return this.getName().equals(String.valueOf(name1) + '_' + name0) ? new EclipseLinkForeignKey(this, fk1) : new EclipseLinkForeignKey(this, fk0);
        }
        return null;
    }

    private Table getJoinTableOwningTable() {
        return this.getJoinTableOwningForeignKey().getReferencedTable();
    }

    public String getName() {
        return this.table.getShortName();
    }

    public Column getPrimaryKeyColumn() {
        if (this.getPrimaryKeyColumnsSize() > 0) {
            return this.getPrimaryKeyColumns().iterator().next();
        }
        throw new IllegalStateException();
    }

    public Iterable<Column> getPrimaryKeyColumns() {
        return new TransformationIterable<ELColumn, Column>((Iterable)new Iterable<ELColumn>(){

            @Override
            public Iterator<ELColumn> iterator() {
                return EclipseLinkTable.this.table.primaryKeyColumns();
            }
        }){

            protected Column transform(ELColumn column) {
                return new EclipseLinkColumn(EclipseLinkTable.this, column);
            }
        };
    }

    public int getPrimaryKeyColumnsSize() {
        return this.table.primaryKeyColumnsSize();
    }

    public EclipseLinkSchema getSchema() {
        return this.parent;
    }

    public Iterable<String> getSortedColumnIdentifiers() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return EclipseLinkTable.this.table.columnNames();
            }
        };
    }

    public boolean isPossibleJoinTable() {
        return this.getForeignKeysSize() == 2;
    }

    public boolean joinTableNameIsDefault() {
        return this.getName().equals(this.buildDefaultJoinTableName());
    }
}

