/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformingTestConfiguration;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamTest;

public class CursoredStreamConformingTest
extends CursoredStreamTest {
    protected ConformingTestConfiguration configuration = new ConformingTestConfiguration();
    protected boolean useNestedUnitOfWork;

    public CursoredStreamConformingTest() {
        super(Employee.class, new ExpressionBuilder().get("salary").greaterThan(50000));
    }

    public CursoredStreamConformingTest(boolean useNestedUnitOfWork) {
        this();
        if (useNestedUnitOfWork) {
            this.setName(this.getName() + ":NestedUnitOfWork");
            this.useNestedUnitOfWork = true;
        }
    }

    @Override
    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.configuration.setup(this.getSession());
        UnitOfWork unitOfWork = this.configuration.getUnitOfWork();
        ReadAllQuery query = new ReadAllQuery(this.getReferenceClass(), this.joinExpression);
        query.conformResultsInUnitOfWork();
        Vector result = (Vector)unitOfWork.executeQuery((DatabaseQuery)query);
        Vector<BigDecimal> expectedPKs = new Vector<BigDecimal>(result.size());
        Enumeration enumtr = result.elements();
        while (enumtr.hasMoreElements()) {
            Employee emp = (Employee)enumtr.nextElement();
            expectedPKs.add(emp.getId());
        }
        this.setNormalQueryObjects(expectedPKs);
        this.configuration.reset();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.configuration.setup(this.getSession());
        if (this.useNestedUnitOfWork) {
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork().acquireUnitOfWork());
        } else {
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        try (CursoredStream stream = null;){
            this.cursoredQueryObjects = new Vector();
            query.setReferenceClass(this.getReferenceClass());
            query.setSelectionCriteria(this.joinExpression);
            query.conformResultsInUnitOfWork();
            query.useCursoredStream();
            stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
            CursoredStream stream2 = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                stream2.read(5);
            }
            catch (QueryException ex) {
                // empty catch block
            }
            stream2.close();
            while (!stream.atEnd()) {
                Object databaseObject = stream.read();
                this.getCursoredQueryObjects().addElement(((Employee)databaseObject).getId());
                stream.releasePrevious();
            }
        }
    }

    @Override
    protected void verify() {
        if (this.getNormalQueryObjects().size() != this.getCursoredQueryObjects().size()) {
            throw new TestErrorException("The number of streamed objects does not match the number of objects stored on the database ");
        }
        if (this.getNormalQueryObjects().size() == 0) {
            throw new TestWarningException("no object with the specified selection criteria was found ");
        }
        Enumeration enumtr = this.getNormalQueryObjects().elements();
        while (enumtr.hasMoreElements()) {
            Object nextObject = enumtr.nextElement();
            if (this.getCursoredQueryObjects().remove(nextObject)) continue;
            throw new TestErrorException("The following element was not found in the conformed result: " + nextObject);
        }
    }

    public void reset() {
        if (this.useNestedUnitOfWork) {
            this.getExecutor().getSession().release();
        }
        this.getExecutor().setSession((Session)this.configuration.getUnitOfWork().getParent());
        this.configuration.reset();
    }
}

