/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.history;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class RollbackObjectsTest
extends AutoVerifyTestCase {
    Class domainClass;
    AsOfClause pastTime;
    Vector pastObjects;

    public RollbackObjectsTest(Class domainClass, AsOfClause pastTime) {
        this.domainClass = domainClass;
        this.pastTime = pastTime;
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        Employee emp;
        Session hs = this.getSession().acquireHistoricalSession(this.pastTime);
        this.pastObjects = hs.readAllObjects(this.domainClass);
        Vector currentProjects = this.getSession().readAllObjects(Project.class);
        Enumeration enumtr = currentProjects.elements();
        while (enumtr.hasMoreElements()) {
            ((Project)enumtr.nextElement()).getTeamLeader();
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Enumeration enumtr2 = this.pastObjects.elements();
        while (enumtr2.hasMoreElements()) {
            emp = (Employee)enumtr2.nextElement();
            emp.getProjects();
            Enumeration proj = emp.getProjects().elements();
            while (proj.hasMoreElements()) {
                ((Project)proj.nextElement()).getTeamLeader();
            }
            emp.getAddress();
        }
        enumtr2 = this.pastObjects.elements();
        while (enumtr2.hasMoreElements()) {
            emp = (Employee)enumtr2.nextElement();
            uow.registerObject((Object)emp);
        }
        Vector pastProjects = hs.readAllObjects(Project.class);
        Enumeration enumtr3 = pastProjects.elements();
        while (enumtr3.hasMoreElements()) {
            Project project = (Project)enumtr3.nextElement();
            uow.registerObject((Object)project);
            uow.deepMergeClone((Object)project);
        }
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() {
        try {
            Vector restoredObjects = this.getSession().readAllObjects(this.domainClass);
            if (restoredObjects.size() != this.pastObjects.size()) {
                throw new TestErrorException("Not all objects were restored.  Restored: " + restoredObjects.size() + " Total: " + this.pastObjects.size());
            }
        }
        finally {
            this.pastObjects = null;
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

