/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.multipletable;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.multipletable.Cow;
import org.eclipse.persistence.testing.models.multipletable.Horse;
import org.eclipse.persistence.testing.models.multipletable.Human;
import org.eclipse.persistence.testing.models.multipletable.SuperCow;
import org.eclipse.persistence.testing.models.multipletable.SuperHorse;
import org.eclipse.persistence.testing.models.multipletable.SuperSwan;
import org.eclipse.persistence.testing.models.multipletable.Swan;

public class MultipleTableProject
extends Project {
    public MultipleTableProject() {
        this.setName("MultipleTableProject");
        this.addDescriptor(this.buildCowDescriptor());
        this.addDescriptor(this.buildHorseDescriptor());
        this.addDescriptor(this.buildHumanDescriptor());
        this.addDescriptor(this.buildSwanDescriptor());
        this.addDescriptor(this.buildSuperCowDescriptor());
        this.addDescriptor(this.buildSuperHorseDescriptor());
        this.addDescriptor(this.buildSuperSwanDescriptor());
    }

    public ClassDescriptor buildCowDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Cow.class);
        descriptor.addTableName("MULTI_COW");
        descriptor.addTableName("MULTI_CALFS");
        descriptor.addTableName("MULTI_COW_AGE");
        descriptor.addTableName("MULTI_COW_WEIGHT");
        descriptor.addPrimaryKeyFieldName("MULTI_COW.ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("MULTI_COW.TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(Cow.class, (Object)"C");
        descriptor.getInheritancePolicy().addClassIndicator(SuperCow.class, (Object)"SC");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_COW.CALFS_ID", "MULTI_CALFS.C_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_COW.AGE_ID", "MULTI_COW_AGE.A_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_COW.WEIGHT_ID", "MULTI_COW_WEIGHT.W_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("MULTI_COW.ID");
        descriptor.setSequenceNumberName("CALF_COUNT_SEQ");
        descriptor.setAlias("Cow");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cowIdMapping = new DirectToFieldMapping();
        cowIdMapping.setAttributeName("cowId");
        cowIdMapping.setFieldName("MULTI_COW.ID");
        descriptor.addMapping((DatabaseMapping)cowIdMapping);
        DirectToFieldMapping calfCountIdMapping = new DirectToFieldMapping();
        calfCountIdMapping.setAttributeName("calfCountId");
        calfCountIdMapping.setFieldName("MULTI_CALFS.C_ID");
        descriptor.addMapping((DatabaseMapping)calfCountIdMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("MULTI_COW.NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping calfCountMapping = new DirectToFieldMapping();
        calfCountMapping.setAttributeName("calfCount");
        calfCountMapping.setFieldName("MULTI_CALFS.CALFS");
        descriptor.addMapping((DatabaseMapping)calfCountMapping);
        DirectToFieldMapping weightIdMapping = new DirectToFieldMapping();
        weightIdMapping.setAttributeName("weightId");
        weightIdMapping.setFieldName("MULTI_COW.WEIGHT_ID");
        descriptor.addMapping((DatabaseMapping)weightIdMapping);
        DirectToFieldMapping weightMapping = new DirectToFieldMapping();
        weightMapping.setAttributeName("weight");
        weightMapping.setFieldName("MULTI_COW_WEIGHT.WEIGHT");
        descriptor.addMapping((DatabaseMapping)weightMapping);
        DirectToFieldMapping ageIdMapping = new DirectToFieldMapping();
        ageIdMapping.setAttributeName("ageId");
        ageIdMapping.setFieldName("MULTI_COW.AGE_ID");
        descriptor.addMapping((DatabaseMapping)ageIdMapping);
        DirectToFieldMapping ageMapping = new DirectToFieldMapping();
        ageMapping.setAttributeName("age");
        ageMapping.setFieldName("MULTI_COW_AGE.AGE");
        descriptor.addMapping((DatabaseMapping)ageMapping);
        return descriptor;
    }

    public ClassDescriptor buildHorseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Horse.class);
        descriptor.addTableName("MULTI_HORSE");
        descriptor.addTableName("MULTI_FOALS");
        descriptor.addTableName("MULTI_HORSE_AGE");
        descriptor.addTableName("MULTI_HORSE_WEIGHT");
        descriptor.addPrimaryKeyFieldName("MULTI_HORSE.ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("MULTI_HORSE.TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(Horse.class, (Object)"H");
        descriptor.getInheritancePolicy().addClassIndicator(SuperHorse.class, (Object)"SH");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_FOALS.F_HORSE_ID", "MULTI_HORSE.ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_HORSE_AGE.A_HORSE_ID", "MULTI_HORSE.ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_HORSE_WEIGHT.W_HORSE_ID", "MULTI_HORSE.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("MULTI_HORSE.ID");
        descriptor.setSequenceNumberName("MULTI_HORSE_SEQ");
        descriptor.setAlias("Horse");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("MULTI_HORSE.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("MULTI_HORSE.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping foalCountMapping = new DirectToFieldMapping();
        foalCountMapping.setAttributeName("foalCount");
        foalCountMapping.setFieldName("MULTI_FOALS.FOALS");
        descriptor.addMapping((DatabaseMapping)foalCountMapping);
        DirectToFieldMapping weightMapping = new DirectToFieldMapping();
        weightMapping.setAttributeName("weight");
        weightMapping.setFieldName("MULTI_HORSE_WEIGHT.WEIGHT");
        descriptor.addMapping((DatabaseMapping)weightMapping);
        DirectToFieldMapping ageMapping = new DirectToFieldMapping();
        ageMapping.setAttributeName("age");
        ageMapping.setFieldName("MULTI_HORSE_AGE.AGE");
        descriptor.addMapping((DatabaseMapping)ageMapping);
        return descriptor;
    }

    public ClassDescriptor buildHumanDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Human.class);
        descriptor.addTableName("MULTI_HUMAN");
        descriptor.addTableName("MULTI_KIDS");
        descriptor.addPrimaryKeyFieldName("MULTI_HUMAN.ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_KIDS.ID", "MULTI_HUMAN.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("MULTI_HUMAN.ID");
        descriptor.setSequenceNumberName("MULTI_HUMAN_SEQ");
        descriptor.setAlias("Human");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("MULTI_HUMAN.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("MULTI_HUMAN.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping foalCountMapping = new DirectToFieldMapping();
        foalCountMapping.setAttributeName("kidCount");
        foalCountMapping.setFieldName("MULTI_KIDS.KIDS");
        descriptor.addMapping((DatabaseMapping)foalCountMapping);
        return descriptor;
    }

    public ClassDescriptor buildSwanDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Swan.class);
        descriptor.addTableName("MULTI_SWAN");
        descriptor.addTableName("MULTI_CYGNETS");
        descriptor.addTableName("MULTI_SWAN_AGE");
        descriptor.addTableName("MULTI_SWAN_WEIGHT");
        descriptor.addPrimaryKeyFieldName("MULTI_SWAN.ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("MULTI_SWAN.TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(Swan.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(SuperSwan.class, (Object)"SS");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SWAN.ID", "MULTI_CYGNETS.C_SWAN_ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SWAN_AGE.A_SWAN_ID", "MULTI_SWAN.ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SWAN_WEIGHT.W_SWAN_ID", "MULTI_SWAN.ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("MULTI_SWAN.ID");
        descriptor.setSequenceNumberName("MULTI_SWAN_SEQ");
        descriptor.setAlias("Swan");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("MULTI_SWAN.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("MULTI_SWAN.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        DirectToFieldMapping foalCountMapping = new DirectToFieldMapping();
        foalCountMapping.setAttributeName("cygnetCount");
        foalCountMapping.setFieldName("MULTI_CYGNETS.CYGNETS");
        descriptor.addMapping((DatabaseMapping)foalCountMapping);
        DirectToFieldMapping weightMapping = new DirectToFieldMapping();
        weightMapping.setAttributeName("weight");
        weightMapping.setFieldName("MULTI_SWAN_WEIGHT.WEIGHT");
        descriptor.addMapping((DatabaseMapping)weightMapping);
        DirectToFieldMapping ageMapping = new DirectToFieldMapping();
        ageMapping.setAttributeName("age");
        ageMapping.setFieldName("MULTI_SWAN_AGE.AGE");
        descriptor.addMapping((DatabaseMapping)ageMapping);
        return descriptor;
    }

    public ClassDescriptor buildSuperCowDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SuperCow.class);
        descriptor.addTableName("MULTI_SUPER_COW");
        descriptor.getInheritancePolicy().setParentClass(Cow.class);
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SUPER_COW.SC_ID", "MULTI_COW.ID");
        descriptor.setAlias("SuperCow");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping speedMapping = new DirectToFieldMapping();
        speedMapping.setAttributeName("speed");
        speedMapping.setFieldName("MULTI_SUPER_COW.SPEED");
        descriptor.addMapping((DatabaseMapping)speedMapping);
        return descriptor;
    }

    public ClassDescriptor buildSuperHorseDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SuperHorse.class);
        descriptor.addTableName("MULTI_SUPER_HORSE");
        descriptor.getInheritancePolicy().setParentClass(Horse.class);
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SUPER_HORSE.SH_ID", "MULTI_HORSE.ID");
        descriptor.setAlias("SuperHorse");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping speedMapping = new DirectToFieldMapping();
        speedMapping.setAttributeName("speed");
        speedMapping.setFieldName("MULTI_SUPER_HORSE.SPEED");
        descriptor.addMapping((DatabaseMapping)speedMapping);
        return descriptor;
    }

    public ClassDescriptor buildSuperSwanDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SuperSwan.class);
        descriptor.addTableName("MULTI_SUPER_SWAN");
        descriptor.addTableName("MULTI_SWAN_WINGSPAN");
        descriptor.getInheritancePolicy().setParentClass(Swan.class);
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SUPER_SWAN.SS_ID", "MULTI_SWAN.ID");
        descriptor.addForeignKeyFieldNameForMultipleTable("MULTI_SWAN_WINGSPAN.A_SWAN_ID", "MULTI_SUPER_SWAN.SS_ID");
        descriptor.setAlias("SuperSwan");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping speedMapping = new DirectToFieldMapping();
        speedMapping.setAttributeName("speed");
        speedMapping.setFieldName("MULTI_SUPER_SWAN.SPEED");
        descriptor.addMapping((DatabaseMapping)speedMapping);
        DirectToFieldMapping wingSpanMapping = new DirectToFieldMapping();
        wingSpanMapping.setAttributeName("wingSpan");
        wingSpanMapping.setFieldName("MULTI_SWAN_WINGSPAN.WING_SPAN");
        descriptor.addMapping((DatabaseMapping)wingSpanMapping);
        return descriptor;
    }
}

