/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.inheritance;

import java.util.Vector;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.inheritance.A_1_King2;
import org.eclipse.persistence.testing.models.inheritance.A_2_1_King2;
import org.eclipse.persistence.testing.models.inheritance.A_2_King2;
import org.eclipse.persistence.testing.models.inheritance.A_King2;
import org.eclipse.persistence.testing.models.inheritance.Alligator;
import org.eclipse.persistence.testing.models.inheritance.Animal_Matt;
import org.eclipse.persistence.testing.models.inheritance.Cat;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.testing.models.inheritance.Computer;
import org.eclipse.persistence.testing.models.inheritance.Dog;
import org.eclipse.persistence.testing.models.inheritance.Entomologist;
import org.eclipse.persistence.testing.models.inheritance.GrassHopper;
import org.eclipse.persistence.testing.models.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.inheritance.JavaProgrammer;
import org.eclipse.persistence.testing.models.inheritance.Person;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class InheritanceSystem
extends TestSystem {
    public InheritanceSystem() {
        this.project = XMLProjectReader.read((String)"org/eclipse/persistence/testing/models/inheritance/inheritance-project.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public void addDescriptors(DatabaseSession session) {
        this.project.getDescriptor(Entomologist.class).setIdValidation(IdValidation.NONE);
        session.addDescriptors(this.project);
        DatabasePlatform platform = session.getLogin().getPlatform();
        if (platform.isOracle() || platform.isSybase()) {
            ClassDescriptor computerDescriptor = session.getDescriptor(Computer.class);
            ClassDescriptor vehicleDescriptor = session.getDescriptor(Vehicle.class);
            computerDescriptor.getInheritancePolicy().setReadAllSubclassesViewName("AllComputers");
            vehicleDescriptor.getInheritancePolicy().setReadAllSubclassesViewName("AllVehicles");
        }
        session.getDescriptor(Animal_Matt.class).getInheritancePolicy().setShouldOuterJoinSubclasses(true);
    }

    public void createTables(DatabaseSession session) {
        this.dropTableConstraints((Session)session);
        new InheritanceTableCreator().replaceTables(session);
        SchemaManager schemaManager = new SchemaManager(session);
        if (session.getLogin().getPlatform().isOracle()) {
            schemaManager.replaceObject((DatabaseObjectDefinition)Computer.oracleView());
            schemaManager.replaceObject((DatabaseObjectDefinition)Vehicle.oracleView());
        } else if (session.getLogin().getPlatform().isSybase()) {
            schemaManager.replaceObject((DatabaseObjectDefinition)Computer.sybaseView());
            schemaManager.replaceObject((DatabaseObjectDefinition)Vehicle.sybaseView());
        }
    }

    public void dropTableConstraints(Session session) {
        if (!SchemaManager.FAST_TABLE_CREATOR) {
            if (session.getLogin().getPlatform().isOracle()) {
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table BUS CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table CAR CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table COMPANY CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table FUEL_VEH CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table NH_COMP CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table INH_MF CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table KING_DEVELOPER CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table KING_PERSONG CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table PARTNUMS CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    session.executeNonSelectingCall((Call)new SQLCall("drop table VEHICLE CASCADE CONSTRAINTS"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (session.getPlatform().supportsUniqueKeyConstraints() && !session.getPlatform().requiresUniqueConstraintCreationOnTableCreate()) {
                    if (session.getPlatform().isMySQL()) {
                        session.executeNonSelectingSQL("Alter TABLE PROJECT_WORKER_BATCH DROP FOREIGN KEY PROJECT_WORKER_BATCH_HD");
                        session.executeNonSelectingSQL("Alter TABLE PROJECT_BATCH DROP FOREIGN KEY PROJECT_WORKER_BATCH_FK");
                        session.executeNonSelectingSQL("Alter TABLE ALLIGATOR DROP FOREIGN KEY FK_ALLIGATOR_VICTIM_ID");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP FOREIGN KEY PERSON2_PERSON2_FRND");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP FOREIGN KEY PERSON2_PERSON2_REP");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP FOREIGN KEY PERSON2_PERSON2_BS");
                    } else {
                        session.executeNonSelectingSQL("Alter TABLE PROJECT_WORKER_BATCH DROP CONSTRAINT PROJECT_WORKER_BATCH_HD");
                        session.executeNonSelectingSQL("Alter TABLE PROJECT_BATCH DROP CONSTRAINT PROJECT_WORKER_BATCH_FK");
                        session.executeNonSelectingSQL("Alter TABLE ALLIGATOR DROP CONSTRAINT FK_ALLIGATOR_VICTIM_ID");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP CONSTRAINT PERSON2_PERSON2_FRND");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP CONSTRAINT PERSON2_PERSON2_REP");
                        session.executeNonSelectingSQL("Alter TABLE PERSON2 DROP CONSTRAINT PERSON2_PERSON2_BS");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        Cat cat = Cat.example1();
        session.writeObject((Object)cat);
        manager.registerObject((Object)cat, "catExample1");
        Dog dog = Dog.example1();
        session.writeObject((Object)dog);
        manager.registerObject((Object)dog, "dogExample1");
        cat = Cat.example2();
        session.writeObject((Object)cat);
        manager.registerObject((Object)cat, "catExample2");
        dog = Dog.example2();
        session.writeObject((Object)dog);
        manager.registerObject((Object)dog, "dogExample2");
        cat = Cat.example3();
        session.writeObject((Object)cat);
        manager.registerObject((Object)cat, "catExample3");
        dog = Dog.example3();
        session.writeObject((Object)dog);
        manager.registerObject((Object)dog, "dogExample3");
        Company company = Company.example1();
        session.writeObject((Object)company);
        manager.registerObject((Object)company, "example1");
        manager.registerObject(((Vector)company.getVehicles().getValue()).firstElement(), "example1");
        company = Company.example2();
        session.writeObject((Object)company);
        manager.registerObject((Object)company, "example2");
        company = Company.example3();
        session.writeObject((Object)company);
        manager.registerObject((Object)company, "example3");
        Person person = Person.example1();
        session.writeObject((Object)person);
        manager.registerObject((Object)person, "example1");
        session.writeObject((Object)A_King2.exp1());
        session.writeObject((Object)A_King2.exp2());
        session.writeObject((Object)A_1_King2.exp3());
        session.writeObject((Object)A_2_King2.exp4());
        session.writeObject((Object)A_2_1_King2.exp5());
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        person = Person.example2();
        unitOfWork.registerObject((Object)person);
        unitOfWork.commit();
        manager.registerObject((Object)person, "example2");
        manager.registerObject((Object)person.bestFriend, "example5");
        manager.registerObject((Object)person.representitive, "example4");
        person = Person.example3();
        session.writeObject((Object)person);
        manager.registerObject((Object)person, "example3");
        Computer computer = Computer.example1();
        session.writeObject((Object)computer);
        manager.registerObject((Object)computer, "example1");
        computer = Computer.example2();
        session.writeObject((Object)computer);
        manager.registerObject((Object)computer, "example2");
        computer = Computer.example3();
        session.writeObject((Object)computer);
        manager.registerObject((Object)computer, "example3");
        computer = Computer.example4();
        session.writeObject((Object)computer);
        manager.registerObject((Object)computer, "example4");
        computer = Computer.example5();
        session.writeObject((Object)computer);
        manager.registerObject((Object)computer, "example5");
        JavaProgrammer JP = JavaProgrammer.example1();
        session.writeObject((Object)JP);
        manager.registerObject((Object)JP, "example1");
        JP = JavaProgrammer.example2();
        session.writeObject((Object)JP);
        manager.registerObject((Object)JP, "example2");
        unitOfWork = session.acquireUnitOfWork();
        Alligator alligator = new Alligator();
        alligator.setFavoriteSwamp("Florida");
        alligator.setLatestVictim(JavaProgrammer.steve());
        unitOfWork.registerObject((Object)alligator);
        manager.registerObject((Object)alligator, "example1");
        unitOfWork.commit();
        unitOfWork = session.acquireUnitOfWork();
        Entomologist bugguy = new Entomologist();
        bugguy.setId((int)System.currentTimeMillis());
        bugguy.setName("Gary");
        bugguy = (Entomologist)unitOfWork.registerObject((Object)bugguy);
        GrassHopper insect = new GrassHopper();
        insect.setIn_numberOfLegs(4);
        insect.setGh_maximumJump(5);
        insect.setEntomologist(bugguy);
        bugguy.getInsectCollection().add(insect);
        unitOfWork.commit();
    }
}

