/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.database.AttunityPlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.H2Platform;
import org.eclipse.persistence.platform.database.HSQLPlatform;
import org.eclipse.persistence.platform.database.InformixPlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.platform.database.TimesTenPlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.OracleDBPlatformHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TestSystem {
    protected DatabaseLogin login;
    public Project project;
    public Map<String, String> properties;

    public void addDescriptors(DatabaseSession session) {
        session.addDescriptors((Collection)this.buildDescriptors());
    }

    public Vector buildDescriptors() {
        return new Vector();
    }

    public Vector buildTables() {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() throws Exception {
        DatabaseSession session = this.login();
        try {
            this.createTables(session);
        }
        finally {
            session.logout();
        }
    }

    public void createTables(DatabaseSession session) throws Exception {
        TableDefinition table;
        Vector tables = this.buildTables();
        SchemaManager schemaManager = new SchemaManager(session);
        Enumeration dropForeignKeyEnum = tables.elements();
        while (dropForeignKeyEnum.hasMoreElements()) {
            table = (TableDefinition)dropForeignKeyEnum.nextElement();
            try {
                schemaManager.dropConstraints(table);
            }
            catch (DatabaseException exception) {}
        }
        Enumeration replaceEnum = tables.elements();
        while (replaceEnum.hasMoreElements()) {
            table = (TableDefinition)replaceEnum.nextElement();
            schemaManager.replaceObject((DatabaseObjectDefinition)table);
        }
        Enumeration createForeignKeyEnum = tables.elements();
        while (createForeignKeyEnum.hasMoreElements()) {
            table = (TableDefinition)createForeignKeyEnum.nextElement();
            schemaManager.createConstraints(table);
        }
    }

    public DatabaseLogin getLogin() {
        if (this.login == null) {
            this.loadLoginFromProperties();
        }
        return this.login;
    }

    public void loadLoginFromProperties() {
        this.properties = JUnitTestCaseHelper.getDatabaseProperties();
        this.login = new DatabaseLogin();
        this.login.setDriverClassName(this.properties.get("javax.persistence.jdbc.driver"));
        this.login.setConnectionString(this.properties.get("javax.persistence.jdbc.url"));
        this.login.setUserName(this.properties.get("javax.persistence.jdbc.user"));
        this.login.setEncryptedPassword(this.properties.get("javax.persistence.jdbc.password"));
        String platform = this.properties.get("eclipselink.target-database");
        if (platform != null) {
            this.login.setPlatformClassName(platform);
        }
    }

    public DatabaseSession login() {
        DatabaseSession session = new Project(this.getLogin()).createDatabaseSession();
        this.addDescriptors(session);
        session.setLogLevel(AbstractSessionLog.translateStringToLoggingLevel((String)this.properties.get("eclipselink.logging.level")));
        try {
            session.login();
        }
        catch (DatabaseException x) {
            if (session.getPlatform().isMySQL()) {
                AbstractSessionLog.getLog().warning("Cannot login to the database");
                x.printStackTrace(System.err);
            }
            throw x;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate() throws Exception {
        DatabaseSession session = this.login();
        try {
            this.populate(session);
        }
        finally {
            session.logout();
        }
    }

    public void populate(DatabaseSession session) throws Exception {
    }

    public void run(Session session) throws Exception {
        session.getIdentityMapAccessor().initializeIdentityMaps();
        this.addDescriptors((DatabaseSession)session);
        if (session.getDatasourceLogin().getDatasourcePlatform().isTimesTen()) {
            ((TimesTenPlatform)session.getDatasourceLogin().getDatasourcePlatform()).setSupportsForeignKeyConstraints(false);
        }
        this.createTables((DatabaseSession)session);
        this.populate((DatabaseSession)session);
        session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setLogin(DatabaseLogin login) {
        this.login = login;
    }

    public void useAccessJDBCODBC() {
        DatabaseLogin login = new DatabaseLogin();
        login.useAccess();
        login.setODBCDataSourceName("MSACCESS");
        this.setLogin(login);
    }

    public void useAttunityConnect() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new AttunityPlatform());
        login.setDatabaseURL("mercury2;deftdpname=oracle");
        login.setDriverClassName("com.attunity.jdbc.NvDriver");
        login.setDriverURLHeader("jdbc:attconnect://");
        this.setLogin(login);
    }

    public void useDerby() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new DerbyPlatform());
        login.setDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
        login.setDriverURLHeader("jdbc:derby:");
        login.setDatabaseURL("test;create=true");
        this.setLogin(login);
    }

    public void useH2() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new H2Platform());
        login.setDriverClassName("org.h2.Driver");
        login.setDriverURLHeader("jdbc:h2:");
        login.setDatabaseURL("test");
        login.setUserName("sa");
        login.setPassword("");
        this.setLogin(login);
    }

    public void usePostgres() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new PostgreSQLPlatform());
        login.setDriverClassName("org.postgresql.Driver");
        login.setDriverURLHeader("jdbc:postgresql:");
        login.setDatabaseURL("//ottvm048.ca.oracle.com/toplink");
        this.setLogin(login);
    }

    public void useDB2UniversalDriver() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2();
        login.setDriverClassName("com.ibm.db2.jcc.DB2Driver");
        login.setDriverURLHeader("jdbc:db2://");
        login.setDatabaseURL("ottvm046.ca.oracle.com:50000/TOPLINK2");
        login.setUserName("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useDB2DataDirect() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2();
        login.setDriverClassName("com.oracle.ias.jdbc.db2.DB2Driver");
        login.setDriverURLHeader("jdbc:oracle:db2://");
        login.setDatabaseURL("tlsvrdb7.ca.oracle.com:50001;DatabaseName=TOPLINK");
        login.setUserName("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useDB2App() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2();
        login.setDriverClassName("COM.ibm.db2.jdbc.app.DB2Driver");
        login.setDriverURLHeader("jdbc:db2:");
        login.useStreamsForBinding();
        login.setUserName("");
        login.setEncryptedPassword("password");
        login.setDatabaseURL("TOPLINK");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useDB2Net() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2();
        login.setDriverClassName("COM.ibm.db2.jdbc.net.DB2Driver");
        login.setDriverURLHeader("jdbc:db2:");
        login.useStreamsForBinding();
        login.setUserName("");
        login.setEncryptedPassword("password");
        login.setDatabaseURL("tlsvrdb7.ca.oracle.com:TOPLINK");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useMySQL(String userName) {
        DatabaseLogin login = new DatabaseLogin();
        login.useMySQL();
        login.setDriverClassName("com.mysql.jdbc.Driver");
        login.setDriverURLHeader("jdbc:mysql:");
        login.useStreamsForBinding();
        login.setUserName(userName);
        login.setEncryptedPassword("password");
        login.setDatabaseURL("//ottvm044.ca.oracle.com:3306/" + userName);
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useHSQL() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new HSQLPlatform());
        login.useHSQLDriver();
        login.setDatabaseURL("file:test");
        login.setUserName("sa");
        this.setLogin(login);
    }

    public void useInformixJDBC20() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new InformixPlatform());
        login.useInformix();
        login.useByteArrayBinding();
        login.setDriverClassName("com.informix.jdbc.IfxDriver");
        login.setDriverURLHeader("jdbc:informix-sqli://");
        login.setDatabaseURL("mercury2:1526/toplinkj:INFORMIXSERVER=toplinkj");
        login.setUserName("informix");
        login.setEncryptedPassword("informix");
        this.setLogin(login);
    }

    public void useInformix11() {
        DatabaseLogin dbLogin = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)new InformixPlatform());
        dbLogin.useInformix();
        dbLogin.setDriverClassName("com.informix.jdbc.IfxDriver");
        dbLogin.setDriverURLHeader("jdbc:informix-sqli://");
        dbLogin.setDatabaseURL("tlsvrdb6.ca.oracle.com:9088/toplink:INFORMIXSERVER=informix");
        dbLogin.setUserName("informix");
        dbLogin.setEncryptedPassword("password");
        this.setLogin(dbLogin);
    }

    public void useJDBCODBC() {
        DatabaseLogin login = new DatabaseLogin();
        login.setODBCDataSourceName("JDBC");
        this.setLogin(login);
    }

    public void useOracleOCI() {
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        login.useOracleJDBCDriver();
        login.setDatabaseURL("toplink");
        login.setUserName("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useSQLServerMSJDBC() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSQLServer();
        login.setDriverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        login.setDriverURLHeader("jdbc:sqlserver://");
        login.setDatabaseURL("ottvm041");
        login.setUserName("dev1");
        login.setEncryptedPassword("password");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useSQLServerWeblogicDBLib() {
        DatabaseLogin login = new DatabaseLogin();
        login.useWebLogicSQLServerDBLibDriver();
        login.setDatabaseURL("ottvm041");
        login.setUserName("dev1");
        login.setEncryptedPassword("password");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useSQLServerDataDirect() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSQLServer();
        login.setDriverClassName("com.oracle.ias.jdbc.sqlserver.SQLServerDriver");
        login.setDriverURLHeader("jdbc:oracle:sqlserver://");
        login.setDatabaseURL("localhost\\\\ottvm041");
        login.setUserName("dev1");
        login.setEncryptedPassword("password");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useSybaseJConnect() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSybase();
        login.setDriverClassName("com.sybase.jdbc3.jdbc.SybDriver");
        login.setDriverURLHeader("jdbc:sybase:Tds:");
        login.setDatabaseURL("ottvm031.ca.oracle.com:5000/qa2");
        login.setUserName("qa2");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useSybaseDataDirect() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSybase();
        login.setDriverClassName("com.oracle.ias.jdbc.sybase.SybaseDriver");
        login.setDriverURLHeader("jdbc:oracle:sybase://");
        login.setDatabaseURL("ottvm031.ca.oracle.com:5000/qa2");
        login.setUserName("qa2");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useOracleThin(String databaseURL, String userName, String password) {
        OraclePlatform platform = null;
        try {
            Class<?> platformClass = Class.forName("org.eclipse.persistence.platform.database.oracle.Oracle9Platform");
            platform = (org.eclipse.persistence.platform.database.DatabasePlatform)platformClass.newInstance();
        }
        catch (Exception e) {
            platform = new OraclePlatform();
        }
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)platform);
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL(databaseURL);
        login.setUserName(userName);
        login.setEncryptedPassword(password);
        this.setLogin(login);
    }

    public void useOracle8Thin(String databaseURL, String userName, String password) {
        OraclePlatform platform = null;
        try {
            Class<?> platformClass = Class.forName("org.eclipse.persistence.platform.database.oracle.Oracle8Platform");
            platform = (org.eclipse.persistence.platform.database.DatabasePlatform)platformClass.newInstance();
        }
        catch (Exception e) {
            platform = new OraclePlatform();
        }
        DatabaseLogin login = new DatabaseLogin((org.eclipse.persistence.platform.database.DatabasePlatform)platform);
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL(databaseURL);
        login.setUserName(userName);
        login.setEncryptedPassword(password);
        this.setLogin(login);
    }

    public void useDB2JDBCODBC() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2();
        login.setODBCDataSourceName("DB2");
        login.setUserName("");
        login.setTableQualifier("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useDB2JDBC() {
        DatabaseLogin login = new DatabaseLogin();
        login.useDB2JDBCDriver();
        login.useByteArrayBinding();
        login.useStreamsForBinding();
        login.setUserName("");
        login.setEncryptedPassword("password");
        login.setDatabaseURL("TOPLINK");
        this.setLogin(login);
    }

    public void useSQLServerWeblogicThin() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSQLServer();
        login.useWebLogicSQLServerDriver();
        login.setODBCDataSourceName("localhost");
        login.setUserName("");
        login.setEncryptedPassword("password");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useSybaseJConnect50() {
        DatabaseLogin login = new DatabaseLogin();
        login.setDriverClassName("");
        login.setDatabaseURL("tlsvrdb1.ca.oracle.com:5000/COREDEV1");
        login.setUserName("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useSybaseWeblogicDBLib() {
        DatabaseLogin login = new DatabaseLogin();
        login.useWebLogicSybaseDBLibDriver();
        login.setDatabaseURL("");
        login.setUserName("");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }

    public void useSQLServerThin() {
        DatabaseLogin login = new DatabaseLogin();
        login.useSQLServer();
        login.useINetSQLServerDriver();
        login.setODBCDataSourceName("localhost");
        login.setUserName("");
        login.setEncryptedPassword("password");
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useTimesTen(String userName) {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((Platform)((DatabasePlatform)Class.forName("org.eclipse.persistence.platform.database.TimesTenPlatform").newInstance()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.setDriverClassName("com.timesten.jdbc.TimesTenDriver");
        login.setDriverURLHeader("jdbc:timesten:client:");
        login.useStreamsForBinding();
        login.setUserName(userName);
        login.setEncryptedPassword("password");
        login.setDatabaseURL(userName);
        login.useByteArrayBinding();
        this.setLogin(login);
    }

    public void useSymfowareRDB2_TCP() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((Platform)((DatabasePlatform)Class.forName("org.eclipse.persistence.platform.database.SymfowarePlatform").newInstance()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        login.setDriverClassName("com.fujitsu.symfoware.jdbc.SYMDriver");
        login.setDriverURLHeader("jdbc:symford:");
        login.setDatabaseURL("TESTDB");
        login.setEncryptedPassword("password");
        this.setLogin(login);
    }
}

