/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation.
 ******************************************************************************/  
package org.eclipse.persistence.internal.security;

import java.security.PrivilegedAction;

public class PrivilegedGetSystemProperty implements PrivilegedAction {

    private String propertyName;
    
    public PrivilegedGetSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public Object run() {
        return System.getProperty(propertyName);
    }

}

