/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.tools;

import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;

public final class ConnectionPoolCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final ResourceRepository repository;

    public ConnectionPoolCellRendererAdapter(ResourceRepository repository) {
        this.repository = repository;
    }

    private static String buildKey(ConnectionPoolAdapter pool) {
        StringBuffer sb = new StringBuffer("CONNECTION_POOL");
        if (pool.isReadConnectionPool()) {
            sb.append("_READ");
        } else if (pool.isSequenceConnectionPool()) {
            sb.append("_SEQUENCE");
        } else if (pool.isWriteConnectionPool()) {
            sb.append("_WRITE");
        }
        return sb.toString();
    }

    public static String iconKey(ConnectionPoolAdapter pool) {
        return ConnectionPoolCellRendererAdapter.buildKey(pool);
    }

    @Override
    public String buildAccessibleName(Object value) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)value;
        String bundleKey = ConnectionPoolCellRendererAdapter.buildKey(pool);
        return this.repository.getString(bundleKey, pool.displayString());
    }

    @Override
    public Icon buildIcon(Object value) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)value;
        return this.repository.getIcon(ConnectionPoolCellRendererAdapter.iconKey(pool));
    }

    @Override
    public String buildText(Object value) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)value;
        String bundleKey = ConnectionPoolCellRendererAdapter.buildKey(pool);
        return this.repository.getString(bundleKey, pool.displayString());
    }
}

