/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWClassBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMethodBasedTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWTransformationMapping
extends MWMapping
implements MWIndirectableMapping,
MWTransformer.Parent {
    private volatile boolean mutable;
    public static final String MUTABLE_PROPERTY = "mutable";
    private volatile MWTransformer attributeTransformer;
    public static final String ATTRIBUTE_TRANSFORMER_PROPERTY = "attributeTransformer";
    private List fieldTransformerAssociations;
    public static final String FIELD_TRANSFORMER_ASSOCIATIONS_LIST = "fieldTransformerAssociations";
    private volatile String indirectionType;

    protected MWTransformationMapping() {
    }

    protected MWTransformationMapping(MWMappingDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.attributeTransformer = new MWNullTransformer(this);
        this.fieldTransformerAssociations = new Vector();
        this.indirectionType = "no-indirection";
        this.mutable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.attributeTransformer);
        List list = this.fieldTransformerAssociations;
        synchronized (list) {
            children.addAll(this.fieldTransformerAssociations);
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean newValue) {
        boolean oldValue = this.mutable;
        this.mutable = newValue;
        this.firePropertyChanged(MUTABLE_PROPERTY, oldValue, newValue);
    }

    public MWTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    private void setAttributeTransformer(MWTransformer newAttributeTransformer) {
        MWTransformer oldAttributeTransformer = this.attributeTransformer;
        this.attributeTransformer = newAttributeTransformer;
        this.firePropertyChanged(ATTRIBUTE_TRANSFORMER_PROPERTY, oldAttributeTransformer, newAttributeTransformer);
    }

    public void clearAttributeTransformer() {
        this.setAttributeTransformer(new MWNullTransformer(this));
    }

    public void setAttributeTransformer(MWMethod newAttributeTransformerMethod) {
        this.setAttributeTransformer(new MWMethodBasedTransformer((MWTransformer.Parent)this, newAttributeTransformerMethod));
    }

    public void setAttributeTransformer(MWClass newAttributeTransformerClass) {
        this.setAttributeTransformer(new MWClassBasedTransformer(this, newAttributeTransformerClass));
    }

    public Iterator candidateAttributeTransformationMethods() {
        return this.getParentDescriptor().getMWClass().allInstanceMethods();
    }

    public ListIterator fieldTransformerAssociations() {
        return new CloneListIterator(this.fieldTransformerAssociations);
    }

    public int fieldTransformerAssociationsSize() {
        return this.fieldTransformerAssociations.size();
    }

    public void addFieldTransformerAssociation(MWFieldTransformerAssociation fieldTransformerAssociation) {
        this.addItemToList(fieldTransformerAssociation, this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public void removeFieldTransformerAssociation(MWFieldTransformerAssociation fieldTransformerAssociation) {
        int index = this.fieldTransformerAssociations.indexOf(fieldTransformerAssociation);
        if (index != -1) {
            this.removeNodeFromList(index, this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
            this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        }
    }

    public void clearFieldTransformerAssociations() {
        if (this.clearList(this.fieldTransformerAssociations, FIELD_TRANSFORMER_ASSOCIATIONS_LIST)) {
            this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        }
    }

    public Iterator candidateFieldTransformationMethods() {
        return this.getParentDescriptor().getMWClass().allInstanceMethods();
    }

    @Override
    public boolean usesValueHolderIndirection() {
        return this.indirectionType == "value-holder-indirection";
    }

    @Override
    public boolean usesNoIndirection() {
        return this.indirectionType == "no-indirection";
    }

    @Override
    public void setUseNoIndirection() {
        this.setIndirectionType("no-indirection");
    }

    @Override
    public void setUseValueHolderIndirection() {
        this.setIndirectionType("value-holder-indirection");
    }

    private void setIndirectionType(String indirectionType) {
        String oldValue = this.indirectionType;
        this.indirectionType = indirectionType;
        this.firePropertyChanged("indirection", oldValue, indirectionType);
    }

    @Override
    public MWTransformationMapping transformationMapping() {
        return this;
    }

    @Override
    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWTransformationMapping(this);
    }

    @Override
    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping oldMapping) {
        super.initializeFromMWIndirectableMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (oldMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.attributeTransformer.addAttributeTransformerProblemsForMapping(newProblems, this);
        this.addFieldTransformerProblemsTo(newProblems);
        this.addIndirectionProblemsTo(newProblems);
    }

    private void addFieldTransformerProblemsTo(List newProblems) {
        if (this.fieldTransformerAssociations.size() == 0 && !this.isReadOnly()) {
            newProblems.add(this.buildProblem("0526"));
        }
    }

    private void addIndirectionProblemsTo(List newProblems) {
        if (this.getInstanceVariable().isValueHolder()) {
            if (!this.usesValueHolderIndirection()) {
                newProblems.add(this.buildProblem("0550"));
            }
        } else if (!this.getProject().usesWeaving() && this.usesValueHolderIndirection()) {
            newProblems.add(this.buildProblem("0551"));
        }
    }

    @Override
    public DatabaseMapping runtimeMapping() {
        AbstractTransformationMapping mapping = (AbstractTransformationMapping)super.runtimeMapping();
        this.attributeTransformer.setRuntimeAttributeTransformer(mapping);
        ListIterator stream = this.fieldTransformerAssociations();
        while (stream.hasNext()) {
            ((MWFieldTransformerAssociation)stream.next()).addRuntimeFieldTransformer(mapping);
        }
        if (this.usesValueHolderIndirection()) {
            mapping.setUsesIndirection(true);
        }
        mapping.setIsMutable(this.mutable);
        return mapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTransformationMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWMapping.class);
        XMLCompositeObjectMapping attributeTransformerMapping = new XMLCompositeObjectMapping();
        attributeTransformerMapping.setAttributeName(ATTRIBUTE_TRANSFORMER_PROPERTY);
        attributeTransformerMapping.setGetMethodName("getAttributeTransformerForTopLink");
        attributeTransformerMapping.setSetMethodName("setAttributeTransformerForTopLink");
        attributeTransformerMapping.setReferenceClass(MWTransformer.class);
        attributeTransformerMapping.setXPath("attribute-transformer");
        descriptor.addMapping((DatabaseMapping)attributeTransformerMapping);
        XMLCompositeCollectionMapping fieldTransformerAssociationsMapping = new XMLCompositeCollectionMapping();
        fieldTransformerAssociationsMapping.setAttributeName(FIELD_TRANSFORMER_ASSOCIATIONS_LIST);
        fieldTransformerAssociationsMapping.setReferenceClass(MWFieldTransformerAssociation.class);
        fieldTransformerAssociationsMapping.setXPath("field-transformer-associations");
        descriptor.addMapping((DatabaseMapping)fieldTransformerAssociationsMapping);
        ObjectTypeConverter indirectionTypeConverter = new ObjectTypeConverter();
        indirectionTypeConverter.addConversionValue((Object)"no-indirection", (Object)"no-indirection");
        indirectionTypeConverter.addConversionValue((Object)"value-holder-indirection", (Object)"value-holder-indirection");
        XMLDirectMapping indirectionTypeMapping = new XMLDirectMapping();
        indirectionTypeMapping.setAttributeName("indirectionType");
        indirectionTypeMapping.setXPath("indirection-type/text()");
        indirectionTypeMapping.setNullValue((Object)"no-indirection");
        indirectionTypeMapping.setConverter((Converter)indirectionTypeConverter);
        descriptor.addMapping((DatabaseMapping)indirectionTypeMapping);
        descriptor.addDirectMapping(MUTABLE_PROPERTY, "mutable/text()");
        return descriptor;
    }

    private MWTransformer getAttributeTransformerForTopLink() {
        return this.attributeTransformer.valueForTopLink();
    }

    private void setAttributeTransformerForTopLink(MWTransformer transformer) {
        this.attributeTransformer = MWTransformer.buildTransformerForTopLink(transformer);
    }
}

