/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

/**
 * Extend {@link ItemAspectListValueModelAdapter} to listen to the
 * "state" of each item in the wrapped list model.
 */
@SuppressWarnings("nls")
public class ItemStateListValueModelAdapter<E>
	extends ItemAspectListValueModelAdapter<E>
{
	/** Listener that listens to all the items in the list. */
	protected final StateChangeListener itemStateListener;


	// ********** constructors **********

	/**
	 * Construct an adapter for the item state.
	 */
	public ItemStateListValueModelAdapter(ListValueModel<E> listHolder) {
		super(listHolder);
		this.itemStateListener = this.buildItemStateListener();
	}

	/**
	 * Construct an adapter for the item state.
	 */
	public ItemStateListValueModelAdapter(CollectionValueModel<E> collectionHolder) {
		this(new CollectionListValueModelAdapter<E>(collectionHolder));
	}


	// ********** initialization **********

	protected StateChangeListener buildItemStateListener() {
		return new StateChangeListener() {
			@Override
			public void stateChanged(StateChangeEvent event) {
				ItemStateListValueModelAdapter.this.itemAspectChanged(event);
			}
			@Override
			public String toString() {
				return "item state listener";
			}
		};
	}


	// ********** behavior **********

	@Override
	protected void engageItem_(Model item) {
		item.addStateChangeListener(this.itemStateListener);
	}

	@Override
	protected void disengageItem_(Model item) {
		item.removeStateChangeListener(this.itemStateListener);
	}
}