/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.persistence;

import org.eclipse.persistence.tools.mapping.orm.ExternalForm;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * The external representation of a Persistence Configuration file (persistence.xml).
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalPersistenceConfiguration extends ExternalForm {

	/**
	 * Adds a persistence unit at the given index.
	 *
	 * @param index The position of the new persistence unit
	 * @param name The name of the persistence unit to add
	 */
	void addPersistenceUnit(int index, String name);

	/**
	 * Returns the current build version of the product.
	 *
	 * @return The product's current version
	 */
	String getBuildVersion();

	/**
	 * Retrieves the persistence unit with at the given position.
	 *
	 * @param index The position of the persistence unit to retrieve
	 * @return The external form of the persistence unit
	 */
	ExternalPersistenceUnit getPersistenceUnit(int index);

	/**
	 * Returns the document type of this Persistence Configuration.
	 *
	 * @return the document type.
	 */
	PersistenceDocumentType getDocumentType();

	/**
	 * Returns the persistence units owned by the Persistence Configuration
	 *
	 * @return The children of this external form
	 */
	ListIterable<ExternalPersistenceUnit> persistenceUnits();

	/**
	 * Returns the count of all the persistence units.
	 */
	int persistenceUnitsSize();

	/**
	 * Remove the persistence unit at the specified position.
	 *
	 * @param index The position of the persistence unit to remove
	 */
	void removePersistenceUnit(int index);

	/**
	 * Sets the document type of the external Persistence Configuration.
	 *
	 * @param type the type of the document.
	 */
	void setDocumentType(PersistenceDocumentType type);
}