/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface and inherited behavior describe the configurable properties defined for a clone
 * copy policy in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.CloneCopyPolicy
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalCloneCopyPolicy extends ExternalForm {

	/**
	 * Returns the name of the cloning method for this policy.
	 */
	String getMethod();

	/**
	 * Returns the name of the working copy method for this policy.
	 */
	String getWorkingCopyMethod();

	/**
	 * Sets the method name for this policy.
	 */
	void setMethod(String methodName);

	/**
	 * Sets the working copy method name for this policy.
	 */
	void setWorkingCopyMethod(String workingCopyMethodName);
}