/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value.swing;

import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimplePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.swing.ListSpinnerModelAdapter;
import org.eclipse.persistence.tools.utility.tests.TestTools;

public class ListSpinnerModelAdapterTests
extends TestCase {
    private ModifiablePropertyValueModel<Object> valueHolder;
    private SpinnerModel spinnerModelAdapter;
    boolean eventFired;
    private static final String[] VALUE_LIST = new String[]{"red", "green", "blue"};
    private static final String DEFAULT_VALUE = VALUE_LIST[0];

    public ListSpinnerModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.valueHolder = new SimplePropertyValueModel((Object)DEFAULT_VALUE);
        this.spinnerModelAdapter = new ListSpinnerModelAdapter(this.valueHolder, VALUE_LIST){

            protected PropertyChangeListener buildValueChangeListener() {
                return this.buildValueChangeListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetValueSpinnerModel() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ListSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        ListSpinnerModelAdapterTests.assertEquals((Object)DEFAULT_VALUE, (Object)this.valueHolder.getValue());
        this.spinnerModelAdapter.setValue(VALUE_LIST[2]);
        ListSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        ListSpinnerModelAdapterTests.assertEquals((Object)VALUE_LIST[2], (Object)this.valueHolder.getValue());
    }

    public void testSetValueValueHolder() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ListSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        ListSpinnerModelAdapterTests.assertEquals((Object)DEFAULT_VALUE, (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue((Object)VALUE_LIST[2]);
        ListSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        ListSpinnerModelAdapterTests.assertEquals((Object)VALUE_LIST[2], (Object)this.spinnerModelAdapter.getValue());
    }

    public void testDefaultValue() throws Exception {
        this.eventFired = false;
        this.spinnerModelAdapter.addChangeListener(new TestChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ListSpinnerModelAdapterTests.this.eventFired = true;
            }
        });
        ListSpinnerModelAdapterTests.assertEquals((Object)DEFAULT_VALUE, (Object)this.spinnerModelAdapter.getValue());
        this.valueHolder.setValue((Object)VALUE_LIST[2]);
        ListSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        ListSpinnerModelAdapterTests.assertEquals((Object)VALUE_LIST[2], (Object)this.spinnerModelAdapter.getValue());
        this.eventFired = false;
        this.valueHolder.setValue(null);
        ListSpinnerModelAdapterTests.assertTrue((boolean)this.eventFired);
        ListSpinnerModelAdapterTests.assertEquals((Object)VALUE_LIST[0], (Object)this.spinnerModelAdapter.getValue());
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localValueHolder = (SimplePropertyValueModel)this.valueHolder;
        ListSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.spinnerModelAdapter.addChangeListener(listener);
        ListSpinnerModelAdapterTests.assertTrue((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.spinnerModelAdapter);
        this.spinnerModelAdapter.removeChangeListener(listener);
        ListSpinnerModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.spinnerModelAdapter);
    }

    private void verifyHasNoListeners(SpinnerModel adapter) throws Exception {
        ListSpinnerModelAdapterTests.assertEquals((int)0, (int)((ListSpinnerModelAdapter)adapter).getChangeListeners().length);
    }

    private void verifyHasListeners(Object adapter) throws Exception {
        ListSpinnerModelAdapterTests.assertFalse((((ListSpinnerModelAdapter)adapter).getChangeListeners().length == 0 ? 1 : 0) != 0);
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ListSpinnerModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

