/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model;

import java.util.List;
import org.eclipse.persistence.tools.db.model.ELColumn;
import org.eclipse.persistence.tools.db.model.ELModel;
import org.eclipse.persistence.tools.db.model.ELReference;
import org.eclipse.persistence.tools.db.model.ELTable;
import org.eclipse.persistence.tools.db.model.handles.MWColumnHandle;
import org.eclipse.persistence.tools.db.model.handles.MWHandle;
import org.eclipse.persistence.tools.db.model.spi.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELColumnPair
extends ELModel {
    private MWColumnHandle sourceColumnHandle;
    public static final String SOURCE_COLUMN_PROPERTY = "sourceColumn";
    private MWColumnHandle targetColumnHandle;
    public static final String TARGET_COLUMN_PROPERTY = "targetColumn";

    ELColumnPair(ELReference parent, ELColumn sourceColumn, ELColumn targetColumn) {
        super(parent);
        this.sourceColumnHandle.setColumn(sourceColumn);
        this.targetColumnHandle.setColumn(targetColumn);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.sourceColumnHandle = new MWColumnHandle(this, this.buildSourceColumnScrubber());
        this.targetColumnHandle = new MWColumnHandle(this, this.buildTargetColumnScrubber());
    }

    public ELReference getReference() {
        return (ELReference)this.getParent();
    }

    public ELColumn getSourceColumn() {
        return this.sourceColumnHandle.getColumn();
    }

    public void setSourceColumn(ELColumn sourceColumn) {
        if (sourceColumn != null && sourceColumn.getTable() != this.getReference().getSourceTable()) {
            throw new IllegalArgumentException();
        }
        ELColumn old = this.sourceColumnHandle.getColumn();
        this.sourceColumnHandle.setColumn(sourceColumn);
        this.firePropertyChanged(SOURCE_COLUMN_PROPERTY, old, sourceColumn);
    }

    public ELColumn getTargetColumn() {
        return this.targetColumnHandle.getColumn();
    }

    public void setTargetColumn(ELColumn targetColumn) {
        if (targetColumn != null && targetColumn.getTable() != this.getReference().getTargetTable()) {
            throw new IllegalArgumentException();
        }
        ELColumn old = this.targetColumnHandle.getColumn();
        this.targetColumnHandle.setColumn(targetColumn);
        this.firePropertyChanged(TARGET_COLUMN_PROPERTY, old, targetColumn);
    }

    public String getName() {
        StringBuffer sb = new StringBuffer(200);
        this.appendColumn(sb, this.getSourceColumn());
        sb.append('=');
        this.appendColumn(sb, this.getTargetColumn());
        return sb.toString();
    }

    private void appendColumn(StringBuffer sb, ELColumn column) {
        if (column != null) {
            sb.append(column.qualifiedName());
        }
    }

    boolean pairs(ELColumn sourceColumn, ELColumn targetColumn) {
        return this.getSourceColumn() == sourceColumn && this.getTargetColumn() == targetColumn;
    }

    public ELTable sourceTable() {
        return this.tableFrom(this.getSourceColumn());
    }

    public ELTable targetTable() {
        return this.tableFrom(this.getTargetColumn());
    }

    private ELTable tableFrom(ELColumn column) {
        return column == null ? null : column.getTable();
    }

    public void setSourceAndTargetColumns(ELColumn sourceColumn, ELColumn targetColumn) {
        this.setSourceColumn(sourceColumn);
        this.setTargetColumn(targetColumn);
    }

    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        children.add(this.sourceColumnHandle);
        children.add(this.targetColumnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildSourceColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                ELColumnPair.this.setSourceColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildSourceColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTargetColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                ELColumnPair.this.setTargetColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildTargetColumnScrubber()";
            }
        };
    }

    boolean matches(ExternalForeignKeyColumnPair externalPair) {
        return this.getSourceColumn() == this.sourceColumn(externalPair) && this.getTargetColumn() == this.targetColumn(externalPair);
    }

    private ELColumn sourceColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getReference().sourceColumn(externalPair);
    }

    private ELColumn targetColumn(ExternalForeignKeyColumnPair externalPair) {
        return this.getReference().targetColumn(externalPair);
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer sb) {
        this.printColumnNameOn(this.getSourceColumn(), sb);
        sb.append("=>");
        this.printColumnNameOn(this.getTargetColumn(), sb);
    }

    private void printColumnNameOn(ELColumn column, StringBuffer sb) {
        sb.append(column == null ? "null" : column.getName());
    }
}

