/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.transformer;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.persistence.tools.utility.transformer.AbstractTransformer;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class XMLStringDecoder
extends AbstractTransformer<String, String>
implements Serializable {
    public static final Transformer<String, String> INSTANCE = new XMLStringDecoder();
    private static final long serialVersionUID = 1L;

    public static Transformer<String, String> instance() {
        return INSTANCE;
    }

    private XMLStringDecoder() {
    }

    @Override
    protected String transform_(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        StringBuilder temp = new StringBuilder();
        this.decode(sb, new StringReader(s), temp);
        return sb.toString();
    }

    private void decode(StringBuilder sb, Reader reader, StringBuilder temp) {
        try {
            this.decode_(sb, reader, temp);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void decode_(StringBuilder sb, Reader reader, StringBuilder temp) throws IOException {
        int c = reader.read();
        while (c != -1) {
            if (c == 38) {
                this.decodeCharacterReference(sb, reader, temp);
            } else {
                sb.append((char)c);
            }
            c = reader.read();
        }
        reader.close();
    }

    private void decodeCharacterReference(StringBuilder sb, Reader reader, StringBuilder temp) throws IOException {
        int c = reader.read();
        this.checkChar(c, 35);
        c = reader.read();
        this.checkChar(c, 120);
        temp.setLength(0);
        c = reader.read();
        while (c != 59) {
            this.checkEndOfStream(c);
            temp.append((char)c);
            c = reader.read();
        }
        String charValue = temp.toString();
        if (charValue.length() == 0) {
            throw new IllegalStateException("missing numeric string");
        }
        sb.append((char)Integer.parseInt(charValue, 16));
    }

    private void checkChar(int c, int expected) {
        this.checkEndOfStream(c);
        if (c != expected) {
            throw new IllegalStateException("expected '" + (char)expected + "', but encountered '" + (char)c + "'");
        }
    }

    private void checkEndOfStream(int c) {
        if (c == -1) {
            throw new IllegalStateException("unexpected end of string");
        }
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

