/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitJPQLParameterTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLParameterTestSuite() {
    }

    public JUnitJPQLParameterTestSuite(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLParameterTestSuite");
        suite.addTest((Test)new JUnitJPQLParameterTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLParameterTestSuite("multipleParameterTest"));
        suite.addTest((Test)new JUnitJPQLParameterTestSuite("updateEnumParameter"));
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new JUnitJPQLParameterTestSuite("emptyParametersForNonParameterizedNamedQueryTest"));
        }
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    public void multipleParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)JUnitJPQLParameterTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(employee);
        Query query = em.createQuery("SELECT OBJECT(emp) FROM Employee emp WHERE emp.firstName = ?1 AND emp.id = ?3");
        query.setParameter(1, (Object)employee.getFirstName());
        query.setParameter(3, (Object)employee.getId());
        List result = query.getResultList();
        Assert.assertTrue((String)"Multiple Parameter Test Case Failed", (boolean)comparer.compareObjects(result, expectedResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnumParameter() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitJPQLParameterTestSuite.getServerSession().logMessage("Test updateEnumParameter skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        int nrOfEmps = this.executeJPQLReturningInt(em, "SELECT COUNT(e) FROM Employee e WHERE e.period.endDate IS NULL");
        String update = "UPDATE Employee e SET e.status = :status, e.payScale = :payScale WHERE e.period.endDate IS NULL";
        this.beginTransaction(em);
        try {
            Query q = em.createQuery(update);
            q.setParameter("status", (Object)Employee.EmployeeStatus.FULL_TIME);
            q.setParameter("payScale", (Object)Employee.SalaryRate.SENIOR);
            int updated = q.executeUpdate();
            JUnitJPQLParameterTestSuite.assertEquals((String)"wrong number of updated instances", (int)nrOfEmps, (int)updated);
            Query q2 = em.createQuery("SELECT COUNT(e) FROM Employee e WHERE e.period.endDate IS NULL AND e.status = :status AND e.payScale = :payScale");
            q2.setParameter("status", (Object)Employee.EmployeeStatus.FULL_TIME);
            q2.setParameter("payScale", (Object)Employee.SalaryRate.SENIOR);
            int nr = ((Number)q2.getSingleResult()).intValue();
            JUnitJPQLParameterTestSuite.assertEquals((String)"unexpected number of changed values in the database", (int)nrOfEmps, (int)nr);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    private int executeJPQLReturningInt(EntityManager em, String jpql) {
        Query q = em.createQuery(jpql);
        Object result = q.getSingleResult();
        return ((Number)result).intValue();
    }

    public void emptyParametersForNonParameterizedNamedQueryTest() {
        EntityManager em = this.createEntityManager();
        JUnitJPQLParameterTestSuite.assertNotNull((Object)em);
        Query query = em.createNamedQuery("findAllEmployeesOrderById");
        JUnitJPQLParameterTestSuite.assertNotNull((Object)query);
        Set parameters = query.getParameters();
        JUnitJPQLParameterTestSuite.assertNotNull((Object)parameters);
        JUnitJPQLParameterTestSuite.assertEquals((String)"Parameters size should be 0", (int)0, (int)parameters.size());
    }
}

