/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria.metamodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.PluralAttribute;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Address_;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee_;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber_;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class JUnitCriteriaSimpleTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitCriteriaSimpleTestSuite() {
    }

    public JUnitCriteriaSimpleTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLSimpleTestSuite");
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("testSetup"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleModTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleJoinFetchTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleJoinFetchTest2"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("baseTestCase"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleABSTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleBetweenTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleConcatTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleConcatTestWithParameters"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleConcatTestWithConstants1"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleCountTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleThreeArgConcatTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleDistinctTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleDistinctNullTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleDistinctMultipleResultTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleDoubleOrTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleEqualsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleEqualsTestWithJoin"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("collectionMemberIdentifierEqualsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("abstractSchemaIdentifierEqualsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("abstractSchemaIdentifierNotEqualsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleInOneDotTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleInTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleInListTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleLengthTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleLikeTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleLikeTestWithParameter"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleLikeEscapeTestWithParameter"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNotBetweenTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNotEqualsVariablesInteger"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNotInTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNotLikeTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleOrFollowedByAndTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleOrFollowedByAndTestWithStaticNames"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleOrTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleParameterTestChangingParameters"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseAbsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseConcatTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseEqualsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseLengthTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseSqrtTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleReverseSubstringTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleSqrtTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleSubstringTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNullTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleNotNullTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("distinctTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleIsEmptyTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleIsNotEmptyTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleEscapeUnderscoreTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleEnumTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("smallProjectMemberOfProjectsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("smallProjectNOTMemberOfProjectsTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectCountOneToOneTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectOneToOneTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectPhonenumberDeclaredInINClauseTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectPhoneUsingALLTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectSimpleMemberOfWithParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectSimpleNotMemberOfWithParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectSimpleBetweenWithParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectSimpleInWithParameterTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("selectAverageQueryForByteColumnTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("multipleExecutionOfCriteriaQueryTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleTypeTest"));
        suite.addTest((Test)new JUnitCriteriaSimpleTestSuite("simpleAsOrderByTest"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    public void simpleJoinFetchTest() throws Exception {
        if (JUnitCriteriaSimpleTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest2() throws Exception {
        if (JUnitCriteriaSimpleTestSuite.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        String ejbqlString = "SELECT e FROM Employee e";
        em.createQuery(ejbqlString).getResultList();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest(JpaEntityManager em) throws Exception {
        em.createQuery("select e from Employee e left join fetch e.phoneNumbers").getResultList();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        root.fetch((PluralAttribute)Employee_.phoneNumbers, JoinType.LEFT);
        List result = em.createQuery(cq).getResultList();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        byte[] arr = byteStream.toByteArray();
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
        ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
        List deserialResult = (List)inObjStream.readObject();
        for (Employee emp : deserialResult) {
            emp.getPhoneNumbers().size();
        }
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        ArrayList<Expression> joins = new ArrayList<Expression>(1);
        joins.add(builder.anyOfAllowingNone("phoneNumbers"));
        reportQuery.addItem("emp", (Expression)builder, joins);
        Vector expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            Assert.fail((String)("simpleJoinFetchTest Failed when using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
        this.clearCache();
        em.clear();
        result = em.createQuery(cq).getResultList();
        byteStream = new ByteArrayOutputStream();
        stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        arr = byteStream.toByteArray();
        inByteStream = new ByteArrayInputStream(arr);
        inObjStream = new ObjectInputStream(inByteStream);
        deserialResult = (List)inObjStream.readObject();
        for (Employee emp : deserialResult) {
            emp.getPhoneNumbers().size();
        }
        this.clearCache();
        expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            Assert.fail((String)("simpleJoinFetchTest Failed when not using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baseTestCase() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        this.beginTransaction(em);
        try {
            List result = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class)).getResultList();
            Assert.assertTrue((String)"Base Test Case Failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleABSTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        this.getEntityManagerFactory().getMetamodel().getEntities();
        this.getEntityManagerFactory().getMetamodel().managedType(Employee.class).getDeclaredSingularAttribute("manager", Employee.class).getType();
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.abs((javax.persistence.criteria.Expression)root.get(Employee_.salary)), (Object)expectedResult.getSalary()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"ABS test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleBetweenTest() {
        BigDecimal empId = new BigDecimal(0);
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).lastElement();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").between((Object)empId, (Object)employee.getId());
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.between(root.get(Employee_.id).as(Comparable.class), qb.literal((Object)empId), qb.literal((Object)employee.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Between test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), qb.concat(qb.literal((Object)partOne), qb.literal((Object)partTwo))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTestWithParameters() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
            cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), qb.concat((javax.persistence.criteria.Expression)qb.parameter(String.class, "partOne"), (javax.persistence.criteria.Expression)qb.parameter(String.class, "partTwo"))));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("partOne", (Object)partOne).setParameter("partTwo", (Object)partTwo);
            List result = query.getResultList();
            Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTestWithConstants1() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        String partOne = emp.getFirstName();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").concat((Object)"Smith").like(partOne + "Smith");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.like(qb.concat((javax.persistence.criteria.Expression)root.get(Employee_.firstName), qb.literal((Object)"Smith")), partOne + "Smith"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Concat test with constraints failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCountTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(PhoneNumber.class);
        query.addCount("COUNT", new ExpressionBuilder().get("owner").get("id"), Long.class);
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.setName("selectPhoneNumbersAssociatedToEmployees");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        Root root = cq.from(PhoneNumber.class);
        cq.select((Selection)qb.count((javax.persistence.criteria.Expression)root.get(this.getEntityManagerFactory().getMetamodel().entity(PhoneNumber.class).getSingularAttribute("owner", Employee.class)).get(this.getEntityManagerFactory().getMetamodel().entity(Employee.class).getSingularAttribute("id", Integer.class))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            System.out.println(" results are :" + result);
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Long.class);
            root = cq.from(PhoneNumber.class);
            cq.select((Selection)qb.count((javax.persistence.criteria.Expression)root.get(PhoneNumber_.owner).get(Employee_.id)));
            result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Count test failed", (boolean)expectedResult.elementAt(0).equals(result.get(0)));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleThreeArgConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 1);
        String partTwo = expectedResult.getFirstName().substring(1, 2);
        String partThree = expectedResult.getFirstName().substring(2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), qb.concat(qb.literal((Object)partOne), qb.concat(qb.literal((Object)partTwo), qb.literal((Object)partThree)))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.distinct(true);
        cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).join(Employee_.phoneNumbers);
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            HashSet<Employee> testSet = new HashSet<Employee>();
            for (Employee emp : result) {
                JUnitCriteriaSimpleTestSuite.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(emp));
                testSet.add(emp);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctNullTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("SELECT e from Employee e").getResultList().get(0);
        String oldFirstName = emp.getFirstName();
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setFirstName(null);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            cq.distinct(true);
            Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
            cq.select((Selection)root.get(Employee_.firstName));
            cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.lastName), qb.literal((Object)emp.getLastName())));
            this.beginTransaction(em);
            try {
                List result = em.createQuery(cq).getResultList();
                JUnitCriteriaSimpleTestSuite.assertTrue((String)"Failed to return null value", (boolean)result.contains(null));
            }
            finally {
                this.rollbackTransaction(em);
            }
        }
        finally {
            try {
                this.beginTransaction(em);
                emp = (Employee)em.find(Employee.class, (Object)emp.getId());
                emp.setFirstName(oldFirstName);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctMultipleResultTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createTupleQuery();
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        root.join(Employee_.phoneNumbers);
        cq.distinct(true);
        cq.multiselect(new Selection[]{root, root.get(Employee_.firstName)});
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            HashSet<String> testSet = new HashSet<String>();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                String ids = "";
                Tuple row = (Tuple)iterator.next();
                Employee emp = (Employee)row.get(0, Employee.class);
                String string = (String)row.get(1, String.class);
                ids = "_" + emp.getId() + "_" + string;
                JUnitCriteriaSimpleTestSuite.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(ids));
                testSet.add(ids);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDoubleOrTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        this.clearCache();
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        expectedResult.add(emp3);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        Predicate firstOr = qb.or((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp1.getId()), (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp2.getId()));
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)firstOr, (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp3.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Double OR test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), (Object)expectedResult.getFirstName()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Equals test failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEqualsTestWithJoin() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.anyOf("managedEmployees").get("address").get("city").equal((Object)"Ottawa");
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class, whereClause);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        CollectionJoin managedEmp = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).join(Employee_.managedEmployees);
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)managedEmp.get(Employee_.address).get(Address_.city), (Object)"Ottawa"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Equals test with Join failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionMemberIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal((Object)"Bob");
        exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class, exp).firstElement();
        this.clearCache();
        PhoneNumber phoneNumber = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        CollectionJoin phones = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).join(Employee_.phoneNumbers);
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)phones, (javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1")));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)phoneNumber).getResultList();
            Assert.assertTrue((String)"CollectionMemberIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abstractSchemaIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root, (javax.persistence.criteria.Expression)qb.parameter(Employee.class, "1")));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)expectedResult).getResultList();
            Assert.assertTrue((String)"abstractSchemaIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abstractSchemaIdentifierNotEqualsTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.firstElement();
        expectedResult.removeElementAt(0);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.notEqual((javax.persistence.criteria.Expression)root, (javax.persistence.criteria.Expression)qb.parameter(Employee.class, "1")));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)emp).getResultList();
            Assert.assertTrue((String)"abstractSchemaIdentifierNotEqualsTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInOneDotTest() {
        EntityManager em = this.createEntityManager();
        ReadObjectQuery roq = new ReadObjectQuery(Employee.class);
        ExpressionBuilder empBldr = new ExpressionBuilder();
        Expression exp1 = empBldr.get("firstName").equal((Object)"Bob");
        Expression exp2 = empBldr.get("lastName").equal((Object)"Smith");
        roq.setSelectionCriteria(exp1.and(exp2));
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)roq);
        this.clearCache();
        PhoneNumber empPhoneNumbers = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        CollectionJoin phone = root.join(Employee_.phoneNumbers);
        Predicate firstAnd = qb.and((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)phone.get(PhoneNumber_.areaCode), (Object)empPhoneNumbers.getAreaCode()), (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), (Object)expectedResult.getFirstName()));
        cq.where((javax.persistence.criteria.Expression)qb.and((javax.persistence.criteria.Expression)firstAnd, (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.lastName), (Object)expectedResult.getLastName())));
        this.beginTransaction(em);
        try {
            Employee result = (Employee)em.createQuery(cq).getSingleResult();
            Assert.assertTrue((String)"Simple In Dot Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAverageQueryForByteColumnTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Double.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.select((Selection)qb.avg((javax.persistence.criteria.Expression)root.get(Employee_.salary)));
        this.beginTransaction(em);
        try {
            Object result = em.createQuery(cq).getSingleResult();
            Assert.assertTrue((String)("AVG result type [" + result.getClass() + "] not of type Double"), (result.getClass() == Double.class ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.in((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.id)).value((Object)expectedResult.getId()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInListTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        ArrayList<Integer> expectedResultList = new ArrayList<Integer>();
        expectedResultList.add(expectedResult.getId());
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        ParameterExpression exp = qb.parameter(List.class, "result");
        cq.where((javax.persistence.criteria.Expression)qb.in((javax.persistence.criteria.Expression)root.get(Employee_.id)).value((javax.persistence.criteria.Expression)exp));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("result", expectedResultList).getResultList();
            Assert.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLengthTest() {
        EntityManager em = this.createEntityManager();
        Assert.assertFalse((String)"Warning SQL doesnot support LENGTH function", (boolean)JUnitTestCase.getServerSession().getPlatform().isSQLServer());
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.length((javax.persistence.criteria.Expression)root.get(Employee_.firstName)), (Object)expectedResult.getFirstName().length()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Length Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String partialFirstName = expectedResult.getFirstName().substring(0, 3) + "%";
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.like((javax.persistence.criteria.Expression)root.get(Employee_.firstName), partialFirstName));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Like Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeTestWithParameter() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String partialFirstName = "%" + emp.getFirstName().substring(0, 3) + "%";
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        Vector<String> parameters = new Vector<String>();
        parameters.add(partialFirstName);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("firstName").like(partialFirstName);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.like((javax.persistence.criteria.Expression)root.get(Employee_.firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, "1")));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)partialFirstName).getResultList();
            Assert.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeEscapeTestWithParameter() {
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("TAIYUAN");
        expectedResult.setCountry("CHINA");
        expectedResult.setProvince("SHANXI");
        expectedResult.setPostalCode("030024");
        expectedResult.setStreet("234 RUBY _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Address.class));
        cq.where((javax.persistence.criteria.Expression)qb.like((javax.persistence.criteria.Expression)root.get(Address_.street), (javax.persistence.criteria.Expression)qb.parameter(String.class, "pattern"), (javax.persistence.criteria.Expression)qb.parameter(Character.class, "esc")));
        String patternString = null;
        Character escChar = null;
        if (JUnitCriteriaSimpleTestSuite.getServerSession().getPlatform().isMySQL()) {
            patternString = "234 RUBY $_Way";
            escChar = new Character('$');
        } else {
            patternString = "234 RUBY \\_Way";
            escChar = new Character('\\');
        }
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("pattern", (Object)patternString).setParameter("esc", (Object)escChar).getResultList();
            Assert.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotBetweenTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).firstElement();
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").between((Object)emp1.getId(), (Object)emp2.getId()).not();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.not((javax.persistence.criteria.Expression)qb.between((javax.persistence.criteria.Expression)root.get(Employee_.id), (Comparable)emp1.getId(), (Comparable)emp2.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Not Between Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotEqualsVariablesInteger() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.elementAt(0);
        expectedResult.removeElementAt(0);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.notEqual((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.id), (Object)emp.getId()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotInTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        ExpressionBuilder builder = new ExpressionBuilder();
        Vector<Integer> idVector = new Vector<Integer>();
        idVector.add(emp.getId());
        Expression whereClause = builder.get("id").notIn(idVector);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.not((javax.persistence.criteria.Expression)qb.in((javax.persistence.criteria.Expression)root.get(Employee_.id)).value((Object)emp.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Not In Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotLikeTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String partialFirstName = emp.getFirstName().substring(0, 3) + "%";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").notLike(partialFirstName);
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.notLike((javax.persistence.criteria.Expression)root.get(Employee_.firstName), partialFirstName));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Not Like Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrFollowedByAndTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(2);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        Predicate andOpp = qb.and((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp2.getId()), (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp3.getId()));
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.id), (Object)emp1.getId()), (javax.persistence.criteria.Expression)andOpp));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Or followed by And Test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrFollowedByAndTestWithStaticNames() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal((Object)"John").or(builder.get("firstName").equal((Object)"Bob").and(builder.get("lastName").equal((Object)"Smith")));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        Path empFName = root.get(Employee_.firstName);
        Predicate andOpp = qb.and((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)empFName, (Object)"Bob"), (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.lastName), (Object)"Smith"));
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)empFName, (Object)"John"), (javax.persistence.criteria.Expression)andOpp));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Or followed by And With Static Names Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        Path empId = root.get(Employee_.id);
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)empId, (Object)emp1.getId()), (javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)empId, (Object)emp2.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            this.clearCache();
            Assert.assertTrue((String)"Simple Or Test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(expectedResult.getFirstName());
        JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, parameterName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter(parameterName, (Object)expectedResult.getFirstName()).getResultList();
            Assert.assertTrue((String)"Simple Parameter Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleParameterTestChangingParameters() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(1);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> firstParameters = new Vector<String>();
        firstParameters.add(emp1.getFirstName());
        Vector<String> secondParameters = new Vector<String>();
        secondParameters.add(emp2.getFirstName());
        Vector firstEmployees = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, firstParameters);
        this.clearCache();
        Vector secondEmployees = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, secondParameters);
        this.clearCache();
        Vector expectedResult = new Vector();
        expectedResult.addAll(firstEmployees);
        expectedResult.addAll(secondEmployees);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, "1")));
        this.beginTransaction(em);
        try {
            List firstResultSet = em.createQuery(cq).setParameter("1", firstParameters.get(0)).getResultList();
            this.clearCache();
            List secondResultSet = em.createQuery(cq).setParameter("1", secondParameters.get(0)).getResultList();
            this.clearCache();
            Vector result = new Vector();
            result.addAll(firstResultSet);
            result.addAll(secondResultSet);
            Assert.assertTrue((String)"Simple Parameter Test Changing Parameters failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseAbsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getSalary()), qb.abs((javax.persistence.criteria.Expression)root.get(Employee_.salary))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse Abs test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.concat(partOne, qb.literal((Object)partTwo)), (javax.persistence.criteria.Expression)root.get(Employee_.firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getFirstName()), (javax.persistence.criteria.Expression)root.get(Employee_.firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse Equals test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseLengthTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        javax.persistence.criteria.Expression length = qb.length((javax.persistence.criteria.Expression)root.get(Employee_.firstName));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getFirstName().length()), length));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse Length test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(emp.getFirstName());
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)qb.parameter(String.class, "1"), (javax.persistence.criteria.Expression)root.get(Employee_.firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", parameters.get(0)).getResultList();
            Assert.assertTrue((String)"Simple Reverse Parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseSqrtTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(new Double(((Employee)expectedResult.firstElement()).getSalary()));
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        javax.persistence.criteria.Expression sqrt = qb.sqrt((javax.persistence.criteria.Expression)root.get(Employee_.salary));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)salarySquareRoot), sqrt));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        javax.persistence.criteria.Expression substring = qb.substring((javax.persistence.criteria.Expression)root.get(Employee_.firstName), 1, 2);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)firstNamePart), substring));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Reverse SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleSqrtTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(new Double(((Employee)expectedResult.firstElement()).getSalary()));
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.sqrt((javax.persistence.criteria.Expression)root.get(Employee_.salary)), (Object)salarySquareRoot));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        javax.persistence.criteria.Expression substring = qb.substring((javax.persistence.criteria.Expression)root.get(Employee_.firstName), 1, 2);
        cq.where((javax.persistence.criteria.Expression)qb.equal(substring, (Object)firstNamePart));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNull((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            uow = clientSession.acquireUnitOfWork();
            uow.deleteObject((Object)nullEmployee);
            uow.commit();
            Assert.assertTrue((String)"Simple Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull().not();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotNull((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            uow = clientSession.acquireUnitOfWork();
            uow.deleteObject((Object)nullEmployee);
            uow.commit();
            Assert.assertTrue((String)"Simple Not Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distinctTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("lastName").equal((Object)"Smith");
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.distinct(true);
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.lastName), (Object)"Smith"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Distinct test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multipleExecutionOfCriteriaQueryTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
            cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get(Employee_.address).get(Address_.postalCode), (javax.persistence.criteria.Expression)qb.parameter(String.class, "postalCode")));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("postalCode", (Object)"K1T3B9");
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on first execution, not expected");
            }
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on second execution");
            }
            query = em.createNamedQuery("findEmployeeByPostalCode");
            query.setParameter("postalCode", (Object)"K1T3B9");
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuite.fail((String)"Failed to execute query, exception resulted on first execution, of second use of named query");
            }
            query.setMaxResults(100000);
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuite.fail((String)"Failed to execute query, exception resulted after setting max results (forcing reprepare)");
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleModTest() {
        EntityManager em = this.createEntityManager();
        Assert.assertFalse((String)"Warning SQL/Sybase doesnot support MOD function", (JUnitTestCase.getServerSession().getPlatform().isSQLServer() || JUnitTestCase.getServerSession().getPlatform().isSybase() ? 1 : 0) != 0);
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.mod((Expression)employee.get("salary"), (int)2).greaterThan(0);
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.gt(qb.mod((javax.persistence.criteria.Expression)cq.from(Employee.class).get("salary"), Integer.valueOf(2)), (Number)0));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Mod test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
            expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
            this.clearCache();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Employee.class);
            Path salaryExp = cq.from(Employee.class).get("salary");
            cq.where((javax.persistence.criteria.Expression)qb.equal(qb.mod((javax.persistence.criteria.Expression)salaryExp, (javax.persistence.criteria.Expression)salaryExp), (Object)0));
            result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Mod test(2) failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleIsEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.isEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.isEmpty(root.get((PluralAttribute)Employee_.phoneNumbers)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Is empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleIsNotEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.notEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotEmpty(cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get((PluralAttribute)Employee_.phoneNumbers)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple is not empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEscapeUnderscoreTest() {
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("Perth");
        expectedResult.setCountry("Canada");
        expectedResult.setProvince("ONT");
        expectedResult.setPostalCode("Y3Q2N9");
        expectedResult.setStreet("234 Wandering _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        Character escapeChar = null;
        escapeChar = JUnitCriteriaSimpleTestSuite.getServerSession().getPlatform().isMySQL() || JUnitCriteriaSimpleTestSuite.getServerSession().getPlatform().isPostgreSQL() ? Character.valueOf('$') : Character.valueOf('\\');
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Address.class));
        cq.where((javax.persistence.criteria.Expression)qb.like((javax.persistence.criteria.Expression)root.get(Address_.street), "234 Wandering " + escapeChar + "_Way", escapeChar.charValue()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void smallProjectMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        Expression selectionCriteria = new ExpressionBuilder().anyOf("projects").equal((Expression)new ExpressionBuilder(SmallProject.class));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        query.dontUseDistinct();
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root projRoot = cq.from(this.getEntityManagerFactory().getMetamodel().entity(SmallProject.class));
        Root empRoot = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.isMember(projRoot.as(Project.class), empRoot.get((PluralAttribute)Employee_.projects)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple small Project Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void smallProjectNOTMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadObjectQuery smallProjectQuery = new ReadObjectQuery();
        smallProjectQuery.setReferenceClass(SmallProject.class);
        smallProjectQuery.setSelectionCriteria(new ExpressionBuilder().get("name").equal((Object)"Enterprise"));
        SmallProject smallProject = (SmallProject)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)smallProjectQuery);
        ReadAllQuery query = new ReadAllQuery();
        query.addArgument("smallProject");
        Expression selectionCriteria = new ExpressionBuilder().noneOf("projects", new ExpressionBuilder().equal(new ExpressionBuilder().getParameter("smallProject")));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        Vector<SmallProject> arguments = new Vector<SmallProject>();
        arguments.add(smallProject);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query, arguments);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotMember((javax.persistence.criteria.Expression)qb.parameter(Project.class, "1"), cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get((PluralAttribute)Employee_.projects)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)smallProject).getResultList();
            Assert.assertTrue((String)"Simple small Project NOT Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCountOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(PhoneNumber.class);
        query.addCount("COUNT", new ExpressionBuilder().get("owner").distinct(), Long.class);
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.setName("selectEmployeesThatHavePhoneNumbers");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        cq.select((Selection)qb.countDistinct((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(PhoneNumber.class)).get(PhoneNumber_.owner)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Select Count One To One test failed", (boolean)expectedResult.elementAt(0).equals(result.get(0)));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Address.class);
        query.useDistinct();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression selectionCriteria = new ExpressionBuilder(Address.class).equal(employeeBuilder.get("address")).and(employeeBuilder.get("lastName").like("%Way%"));
        query.setSelectionCriteria(selectionCriteria);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.distinct(true);
        cq.select((Selection)root.get(Employee_.address));
        cq.where((javax.persistence.criteria.Expression)qb.like((javax.persistence.criteria.Expression)root.get(Employee_.lastName), "%Way%"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple Select One To One test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPhonenumberDeclaredInINClauseTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression phoneAnyOf = employeeBuilder.anyOf("phoneNumbers");
        ExpressionBuilder phoneBuilder = new ExpressionBuilder(PhoneNumber.class);
        Expression selectionCriteria = phoneBuilder.equal(employeeBuilder.anyOf("phoneNumbers")).and(phoneAnyOf.get("number").notNull());
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(PhoneNumber.class);
        query.addAscendingOrdering("number");
        query.addAscendingOrdering("areaCode");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(PhoneNumber.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        CollectionJoin phone = root.join(Employee_.phoneNumbers);
        cq.select((Selection)phone);
        cq.where((javax.persistence.criteria.Expression)qb.isNotNull((javax.persistence.criteria.Expression)phone.get(PhoneNumber_.number)));
        cq.orderBy(new Order[]{qb.asc((javax.persistence.criteria.Expression)phone.get(PhoneNumber_.number)), qb.asc((javax.persistence.criteria.Expression)phone.get(PhoneNumber_.areaCode))});
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPhoneUsingALLTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(PhoneNumber.class);
        subQuery.addMinimum("number");
        Expression selectionCriteria = employeeBuilder.anyOf("phoneNumbers").get("number").equal(employeeBuilder.all(subQuery));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.distinct(true);
            Subquery sq = cq.subquery(Number.class);
            Root subroot = sq.from(PhoneNumber.class);
            sq.select(qb.min((javax.persistence.criteria.Expression)subroot.get("number")));
            Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
            CollectionJoin phone = root.join(Employee_.phoneNumbers);
            cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)phone.get(PhoneNumber_.number), qb.all(sq)));
            TypedQuery jpqlQuery = em.createQuery(cq);
            jpqlQuery.setMaxResults(10);
            List result = jpqlQuery.getResultList();
            Assert.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleMemberOfWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuite.getServerSession().readObject(Employee.class);
        PhoneNumber phone = new PhoneNumber();
        phone.setAreaCode("613");
        phone.setNumber("1234567");
        phone.setType("cell");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
        Employee empClone = (Employee)uow.registerObject((Object)expectedResult);
        phoneClone.setOwner(empClone);
        empClone.addPhoneNumber(phoneClone);
        uow.registerObject((Object)phone);
        uow.commit();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.isMember((javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1"), root.get((PluralAttribute)Employee_.phoneNumbers)));
        Vector<PhoneNumber> parameters = new Vector<PhoneNumber>();
        parameters.add(phone);
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)phone).getResultList();
            Assert.assertTrue((String)"Select simple member of with parameter test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)phone);
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleNotMemberOfWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.get(0);
        expectedResult.remove(0);
        PhoneNumber phone = new PhoneNumber();
        phone.setAreaCode("613");
        phone.setNumber("1234567");
        phone.setType("cell");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        emp = (Employee)uow.readObject((Object)emp);
        PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
        phoneClone.setOwner(emp);
        emp.addPhoneNumber(phoneClone);
        uow.commit();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.isNotMember((javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1"), root.get((PluralAttribute)Employee_.phoneNumbers)));
        Vector<PhoneNumber> parameters = new Vector<PhoneNumber>();
        parameters.add(phone);
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)phone).getResultList();
            Assert.assertTrue((String)"Select simple Not member of with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)phone);
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleBetweenWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").between((Object)empId1, (Object)emp2.getId());
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.where((javax.persistence.criteria.Expression)qb.between(root.get(Employee_.id).as(Comparable.class), (javax.persistence.criteria.Expression)qb.parameter(BigDecimal.class, "1"), (javax.persistence.criteria.Expression)qb.parameter(Integer.class, "2")));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)empId1).setParameter("2", (Object)emp2.getId()).getResultList();
            Assert.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleInWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Vector<Number> vec = new Vector<Number>();
        vec.add(empId1);
        vec.add(emp2.getId());
        Expression whereClause = eb.get("id").in(vec);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        CriteriaBuilder.In inExp = qb.in((javax.persistence.criteria.Expression)root.get(Employee_.id));
        inExp.value((javax.persistence.criteria.Expression)qb.parameter(BigDecimal.class, "1"));
        inExp.value((javax.persistence.criteria.Expression)qb.parameter(Integer.class, "2"));
        cq.where((javax.persistence.criteria.Expression)inExp);
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)empId1).setParameter("2", (Object)emp2.getId()).getResultList();
            Assert.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEnumTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class)).get(Employee_.status), (Object)Employee.EmployeeStatus.FULL_TIME));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleTypeTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuite.getServerSession().readAllObjects(LargeProject.class);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Project.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(cq.from(this.getEntityManagerFactory().getMetamodel().entity(Project.class)).type(), LargeProject.class));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleAsOrderByTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(Employee.class);
        query.addItem("firstName", query.getExpressionBuilder().get("firstName"));
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.addOrdering(query.getExpressionBuilder().get("firstName").ascending());
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuite.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(String.class);
        Root root = cq.from(this.getEntityManagerFactory().getMetamodel().entity(Employee.class));
        cq.select((Selection)root.get(Employee_.firstName));
        cq.orderBy(new Order[]{qb.asc((javax.persistence.criteria.Expression)root.get(Employee_.firstName))});
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            Assert.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }
}

