/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class RelationalQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    RelationalQueryOptionsPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.initialize(queryHolder);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel queryHolder) {
        this.queryHolder = this.buildRelationalQueryHolder(queryHolder);
    }

    private PropertyValueModel buildRelationalQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWAbstractRelationalReadQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        JCheckBox refreshIdentityMapCheckBox = this.buildRefreshIdentityMapCheckBox();
        this.addHelpTopicId(refreshIdentityMapCheckBox, this.helpTopicId() + ".refresh");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        checkBoxPanel.add((Component)refreshIdentityMapCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)checkBoxPanel, constraints);
        this.addHelpTopicId(checkBoxPanel, this.helpTopicId() + ".refresh");
        JLabel cacheStatementLabel = this.buildLabel("CACHE_STATMENT_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)cacheStatementLabel, constraints);
        JComboBox cacheStatementTriStateComboBox = this.buildCacheStatementComboBox();
        this.addHelpTopicId(cacheStatementTriStateComboBox, this.helpTopicId() + ".cacheState");
        cacheStatementLabel.setLabelFor(cacheStatementTriStateComboBox);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)cacheStatementTriStateComboBox, constraints);
        JLabel bindParametersLabel = this.buildLabel("BIND_PARAMETERS_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)bindParametersLabel, constraints);
        JComboBox bindParametersTriStateComboBox = this.buildBindParametersComboBox();
        this.addHelpTopicId(bindParametersTriStateComboBox, this.helpTopicId() + ".bind");
        bindParametersLabel.setLabelFor(bindParametersTriStateComboBox);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)bindParametersTriStateComboBox, constraints);
        JLabel cachingOptionsLabel = this.buildLabel("CACHE_USAGE_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)cachingOptionsLabel, constraints);
        JComboBox cachingOptionsComboBox = this.buildCachingOptionsComboBox();
        this.addHelpTopicId(cachingOptionsComboBox, this.helpTopicId() + ".cacheUse");
        cachingOptionsLabel.setLabelFor(cachingOptionsComboBox);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)cachingOptionsComboBox, constraints);
        JLabel inMemoryQueryIndirectionLabel = this.buildLabel("IN_MEMORY_QUERY_INDIRECTION_LABEL");
        inMemoryQueryIndirectionLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("IN_MEMORY_QUERY_INDIRECTION_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)inMemoryQueryIndirectionLabel, constraints);
        JComboBox inMemoryQueryIndirectionComboBox = this.buildInMemoryQueryIndirectionComboBox();
        this.addHelpTopicId(inMemoryQueryIndirectionComboBox, this.helpTopicId() + ".memory");
        inMemoryQueryIndirectionLabel.setLabelFor(inMemoryQueryIndirectionComboBox);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)inMemoryQueryIndirectionComboBox, constraints);
        JButton advancedOptionsButton = this.buildAdvancedOptionsButton();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)advancedOptionsButton, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JCheckBox buildRefreshIdentityMapCheckBox() {
        return QueryComponentFactory.buildRefreshIdentityMapCheckBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildCacheStatementComboBox() {
        return RelationalQueryComponentFactory.buildCacheStatementComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildBindParametersComboBox() {
        return RelationalQueryComponentFactory.buildBindParametersComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildCachingOptionsComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildCacheUsageValueModel(), this.buildCacheUsagePropertyAdapter()));
        comboBox.setRenderer(this.buildCacheUsageRenderer());
        return comboBox;
    }

    private ListCellRenderer buildCacheUsageRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                if (value == null) {
                    return "";
                }
                MWAbstractRelationalReadQuery.CacheUsageModel model = (MWAbstractRelationalReadQuery.CacheUsageModel)value;
                return RelationalQueryOptionsPanel.this.resourceRepository().getString(model.resourceKey());
            }
        };
    }

    private ListValueModel buildCacheUsageValueModel() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWAbstractRelationalReadQuery.cacheUsageOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildCacheUsagePropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "cacheUsage"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).getCacheUsage();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWAbstractRelationalReadQuery)this.subject).setCacheUsage((MWAbstractRelationalReadQuery.CacheUsageModel)value);
            }
        };
    }

    private JComboBox buildInMemoryQueryIndirectionComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildInMemoryQueryIndirectionValueModel(), this.buildInMemoryQueryIndirectionPolicyPropertyAdapter()));
        comboBox.setRenderer(this.buildInMemoryQueryIndirectionPolicyRenderer());
        return comboBox;
    }

    private ListValueModel buildInMemoryQueryIndirectionValueModel() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildInMemoryQueryIndirectionPolicyPropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "inMemoryQueryIndirectionPolicy"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWAbstractRelationalReadQuery)this.subject).getInMemoryQueryIndirectionPolicy();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWAbstractRelationalReadQuery)this.subject).setInMemoryQueryIndirectionPolicy((MWAbstractRelationalReadQuery.InMemoryQueryIndirectionPolicyModel)value);
            }
        };
    }

    private ListCellRenderer buildInMemoryQueryIndirectionPolicyRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? "" : RelationalQueryOptionsPanel.this.resourceRepository().getString(((MWAbstractRelationalReadQuery.InMemoryQueryIndirectionPolicyModel)value).resourceKey());
            }
        };
    }

    private JButton buildAdvancedOptionsButton() {
        JButton button = this.buildButton("ADVANCED_BUTTON_TEXT");
        button.addActionListener(this.buildAdvancedOptionsAction());
        return button;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RelationalQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        RelationalQueryAdvancedOptionsDialog dialog = new RelationalQueryAdvancedOptionsDialog((MWAbstractReadQuery)this.getQuery(), this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            MWAbstractRelationalReadQuery query = this.getQuery();
            query.setMaintainCache(dialog.getMaintainCache());
            query.setLocking(dialog.getLocking());
            query.setPrepare(dialog.getPrepare());
            query.setUseWrapperPolicy(dialog.getUseWrapperPolicy());
            query.setCacheQueryResults(dialog.getCacheQueryResults());
            query.setOuterJoinAllSubclasses(dialog.getOuterJoinAllSubclasses());
            query.setRefreshIdentityMapResult(dialog.getRefreshIdentityMapResult());
            query.setRefreshRemoteIdentityMapResult(dialog.getRefreshRemoteIdentityMapResult());
            query.setDistinctState(dialog.getDistinctState());
            query.setQueryTimeout(dialog.getQueryTimeout());
            query.setMaximumRows(dialog.getMaximumRows());
            query.setFirstResult(dialog.getFirstResult());
            query.setExclusiveConnection(dialog.getExclusiveConnection());
        }
    }

    private MWAbstractRelationalReadQuery getQuery() {
        return (MWAbstractRelationalReadQuery)this.queryHolder.getValue();
    }
}

