/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.io.File;
import javax.swing.ButtonModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public abstract class ProjectOptionsPropertiesPage
extends ScrollablePropertiesPage {
    public static final String MODEL_SOURCE_DIRECTORY_PREFERENCE = "project options-model source directory";
    public static final String PROJECT_DEPLOYMENT_XML_DIRECTORY_PREFERENCE = "project options-project deployment xml directory";

    protected ProjectOptionsPropertiesPage(PropertyValueModel projectNodeHolder, WorkbenchContextHolder contextHolder) {
        super(projectNodeHolder, contextHolder);
    }

    protected ValueModel projectHolder() {
        return this.getSelectionHolder();
    }

    protected MWProject project() {
        return (MWProject)this.projectHolder().getValue();
    }

    protected final FileChooserPanel.FileHolder buildFileChooserRootFileHolder() {
        return new FileChooserPanel.FileHolder(){

            @Override
            public File getFile() {
                return ProjectOptionsPropertiesPage.this.project().getSaveDirectory();
            }

            @Override
            public void setFile(File file) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final FileChooserPanel.FileHolder buildFileChooserDefaultDirectoryHolder(final String prefKey) {
        return new FileChooserPanel.FileHolder(){

            @Override
            public File getFile() {
                File projectSaveDir = ProjectOptionsPropertiesPage.this.project().getSaveDirectory();
                if (projectSaveDir != null) {
                    return projectSaveDir;
                }
                String prefDirName = ProjectOptionsPropertiesPage.this.preferences().get(prefKey, null);
                if (prefDirName != null) {
                    return new File(prefDirName);
                }
                return FileTools.userHomeDirectory();
            }

            @Override
            public void setFile(File file) {
                if (file.equals(FileTools.userHomeDirectory())) {
                    file = null;
                } else if (file.equals(ProjectOptionsPropertiesPage.this.project().getSaveDirectory())) {
                    file = null;
                }
                if (file == null) {
                    ProjectOptionsPropertiesPage.this.preferences().remove(prefKey);
                } else {
                    ProjectOptionsPropertiesPage.this.preferences().put(prefKey, file.getPath());
                }
            }
        };
    }

    protected PropertyValueModel buildDeploymentXMLFileNameHolder(ValueModel projectHolder) {
        return new PropertyAspectAdapter(projectHolder, "deploymentXMLFileName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProject)this.subject).getDeploymentXMLFileName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProject)this.subject).setDeploymentXMLFileName((String)value);
            }
        };
    }

    protected PropertyValueModel buildModelSourceDirectoryNameHolder(ValueModel projectHolder) {
        return new PropertyAspectAdapter(projectHolder, "modelSourceDirectoryName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProject)this.subject).getModelSourceDirectoryName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProject)this.subject).setModelSourceDirectoryName((String)value);
            }
        };
    }

    protected ButtonModel buildWeavingButtonModel() {
        return new CheckBoxModelAdapter(this.buildWeavingAdapter(), false);
    }

    protected PropertyValueModel buildWeavingAdapter() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "usesWeaving"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProject)this.subject).usesWeaving();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProject)this.subject).setUsesWeaving(((Boolean)value).booleanValue());
            }
        };
    }
}

