/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.docshare;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.IContainerManagerListener;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.start.IECFStart;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.docshare.DocShare;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.osgi.util.NLS;

public class ECFStart
implements IECFStart {
    IContainerListener containerListener = new IContainerListener(){

        public void handleEvent(IContainerEvent event) {
            IContainerManager containerManager = Activator.getDefault().getContainerManager();
            if (containerManager == null) {
                return;
            }
            IContainer container = containerManager.getContainer(event.getLocalContainerID());
            if (container == null) {
                return;
            }
            if (event instanceof IContainerConnectedEvent || event instanceof IContainerDisconnectedEvent) {
                DocShare docShare;
                IChannelContainerAdapter cca;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cca = (IChannelContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                    return;
                }
                ID containerID = container.getID();
                if (event instanceof IContainerConnectedEvent) {
                    try {
                        Activator.getDefault().addDocShare(containerID, cca);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.internal.provisional.docshare", 2, NLS.bind((String)Messages.ECFStart_ERROR_DOCUMENT_SHARE_NOT_CREATED, (Object)container.getID()), null));
                    }
                } else if ((event instanceof IContainerDisconnectedEvent || event instanceof IContainerEjectedEvent) && (docShare = Activator.getDefault().removeDocShare(containerID)) != null) {
                    docShare.dispose();
                }
            } else if (event instanceof IContainerDisposeEvent) {
                containerManager.removeListener(ECFStart.this.containerManagerListener);
                container.removeListener(ECFStart.this.containerListener);
            }
        }
    };
    IContainerManagerListener containerManagerListener = new IContainerManagerListener(){

        public void containerAdded(IContainer container) {
            IChannelContainerAdapter cca;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.datashare.IChannelContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cca = (IChannelContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                return;
            }
            container.addListener(ECFStart.this.containerListener);
        }

        public void containerRemoved(IContainer container) {
            container.removeListener(ECFStart.this.containerListener);
        }
    };
    static /* synthetic */ Class class$0;

    public IStatus run(IProgressMonitor monitor) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager == null) {
            return new Status(2, "org.eclipse.ecf.internal.provisional.docshare", 2, Messages.ECFStart_ERROR_CONTAINER_MANAGER_NOT_AVAILABLE, null);
        }
        containerManager.addListener(this.containerManagerListener);
        return Status.OK_STATUS;
    }
}

