/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.dnssec;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.dnssec.ValUtils;

class AlgorithmRequirements {
    private static final int MAX_ALGORITHMS = 255;
    private final ValUtils valUtils;
    private final short[] needs = new short[255];
    private int num;

    public AlgorithmRequirements(ValUtils valUtils) {
        this.valUtils = valUtils;
    }

    void initList(List<Integer> sigalg) {
        this.num = 0;
        for (Integer algo : sigalg) {
            this.needs[algo.intValue()] = 1;
            ++this.num;
        }
    }

    List<Integer> initDs(RRset dsRRset, int favoriteDsAlgorithm) {
        ArrayList<Integer> sigalg = new ArrayList<Integer>();
        this.num = 0;
        for (Record r : dsRRset.rrs(false)) {
            int algo;
            DSRecord ds = (DSRecord)r;
            if (ds.getDigestID() != favoriteDsAlgorithm || !this.valUtils.isAlgorithmSupported(algo = ds.getAlgorithm()) || this.needs[algo] != 0) continue;
            this.needs[algo] = 1;
            sigalg.add(algo);
            ++this.num;
        }
        return sigalg;
    }

    boolean setSecure(int algo) {
        if (this.needs[algo] != 0) {
            this.needs[algo] = 0;
            --this.num;
            return this.num == 0;
        }
        return false;
    }

    void setBogus(int algo) {
        if (this.needs[algo] != 0) {
            this.needs[algo] = 2;
        }
    }

    int missing() {
        int miss = -1;
        for (int i = 0; i < this.needs.length; ++i) {
            if (this.needs[i] == 2) {
                return 0;
            }
            if (this.needs[i] != 1 || miss != -1) continue;
            miss = i;
        }
        if (miss != -1) {
            return miss;
        }
        return 0;
    }

    @Generated
    public int getNum() {
        return this.num;
    }
}

