/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.entitycaps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.entitycaps.packet.CapsExtension;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCapsManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final String ENTITY_NODE = "http://www.igniterealtime.org/projects/smack";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    protected static EntityCapsPersistentCache persistentCache;
    private static Map<Connection, EntityCapsManager> instances;
    protected static Map<String, DiscoverInfo> caps;
    protected static Map<String, NodeVerHash> jidCaps;
    private WeakReference<Connection> weakRefConnection;
    private ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private String currentCapsVersion;
    private boolean presenceSend = false;
    private Queue<String> lastLocalCapsVersions = new ConcurrentLinkedQueue<String>();

    static {
        instances = Collections.synchronizedMap(new WeakHashMap());
        caps = new Cache<String, DiscoverInfo>(1000, -1L);
        jidCaps = new Cache<String, NodeVerHash>(10000, -1L);
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                if (connection instanceof XMPPConnection) {
                    new EntityCapsManager(connection, null);
                }
            }
        });
        try {
            MessageDigest sha1MessageDigest = MessageDigest.getInstance("SHA-1");
            SUPPORTED_HASHES.put("sha-1", sha1MessageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static void addDiscoverInfoByNode(String nodeVer, DiscoverInfo info) {
        caps.put(nodeVer, info);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(nodeVer, info);
        }
    }

    public static String getNodeVersionByJid(String jid) {
        NodeVerHash nvh = jidCaps.get(jid);
        if (nvh != null) {
            return nvh.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(String jid) {
        return jidCaps.get(jid);
    }

    public static DiscoverInfo getDiscoverInfoByUser(String user) {
        NodeVerHash nvh = jidCaps.get(user);
        if (nvh == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nvh.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String nodeVer) {
        DiscoverInfo info = caps.get(nodeVer);
        if (info != null) {
            info = new DiscoverInfo(info);
        }
        return info;
    }

    public static void setPersistentCache(EntityCapsPersistentCache cache) throws IOException {
        if (persistentCache != null) {
            throw new IllegalStateException("Entity Caps Persistent Cache was already set");
        }
        persistentCache = cache;
        persistentCache.replay();
    }

    public static void setJidCapsMaxCacheSize(int maxCacheSize) {
        ((Cache)jidCaps).setMaxCacheSize(maxCacheSize);
    }

    public static void setCapsMaxCacheSize(int maxCacheSize) {
        ((Cache)caps).setMaxCacheSize(maxCacheSize);
    }

    private EntityCapsManager(Connection connection) {
        this.weakRefConnection = new WeakReference<Connection>(connection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        this.init();
    }

    private void init() {
        Connection connection = (Connection)this.weakRefConnection.get();
        instances.put(connection, this);
        connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                EntityCapsManager.this.presenceSend = false;
                instances.remove(EntityCapsManager.this.weakRefConnection.get());
            }

            public void connectionClosedOnError(Exception e) {
                EntityCapsManager.this.presenceSend = false;
            }

            public void reconnectionFailed(Exception e) {
            }

            public void reconnectingIn(int seconds) {
            }

            public void reconnectionSuccessful() {
            }
        });
        this.updateLocalEntityCaps();
        if (SmackConfiguration.autoEnableEntityCaps()) {
            this.enableEntityCaps();
        }
        PacketFilter packetFilter = new AndFilter(new PacketTypeFilter(Presence.class), new PacketExtensionFilter(ELEMENT, NAMESPACE));
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension ext = (CapsExtension)packet.getExtension(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                String hash = ext.getHash().toLowerCase();
                if (!SUPPORTED_HASHES.containsKey(hash)) {
                    return;
                }
                String from = packet.getFrom();
                String node = ext.getNode();
                String ver = ext.getVer();
                jidCaps.put(from, new NodeVerHash(node, ver, hash));
            }
        }, packetFilter);
        packetFilter = new AndFilter(new PacketTypeFilter(Presence.class), new NotFilter(new PacketExtensionFilter(ELEMENT, NAMESPACE)));
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                String from = packet.getFrom();
                jidCaps.remove(from);
            }
        }, packetFilter);
        packetFilter = new PacketTypeFilter(Presence.class);
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Packet packet) {
                EntityCapsManager.this.presenceSend = true;
            }
        }, packetFilter);
        PacketTypeFilter capsPacketFilter = new PacketTypeFilter(Presence.class);
        PacketInterceptor packetInterceptor = new PacketInterceptor(){

            public void interceptPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled) {
                    return;
                }
                CapsExtension caps = new CapsExtension(EntityCapsManager.ENTITY_NODE, EntityCapsManager.this.getCapsVersion(), "sha-1");
                packet.addExtension(caps);
            }
        };
        connection.addPacketInterceptor(packetInterceptor, capsPacketFilter);
        this.sdm.setEntityCapsManager(this);
    }

    public static synchronized EntityCapsManager getInstanceFor(Connection connection) {
        if (!(connection instanceof XMPPConnection)) {
            return null;
        }
        if (SUPPORTED_HASHES.size() <= 0) {
            return null;
        }
        EntityCapsManager entityCapsManager = instances.get(connection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(connection);
        }
        return entityCapsManager;
    }

    public void enableEntityCaps() {
        this.sdm.addFeature(NAMESPACE);
        this.updateLocalEntityCaps();
        this.entityCapsEnabled = true;
    }

    public void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public void removeUserCapsNode(String user) {
        jidCaps.remove(user);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        return "http://www.igniterealtime.org/projects/smack#" + this.getCapsVersion();
    }

    public boolean areEntityCapsSupported(String jid) {
        if (jid == null) {
            return false;
        }
        try {
            DiscoverInfo result = this.sdm.discoverInfo(jid);
            return result.containsFeature(NAMESPACE);
        }
        catch (XMPPException e) {
            return false;
        }
    }

    public boolean areEntityCapsSupportedByServer() {
        return this.areEntityCapsSupported(((Connection)this.weakRefConnection.get()).getServiceName());
    }

    public void updateLocalEntityCaps() {
        Connection connection = (Connection)this.weakRefConnection.get();
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.RESULT);
        discoverInfo.setNode(this.getLocalNodeVer());
        if (connection != null) {
            discoverInfo.setFrom(connection.getUser());
        }
        this.sdm.addDiscoverInfoTo(discoverInfo);
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfo, "sha-1");
        EntityCapsManager.addDiscoverInfoByNode("http://www.igniterealtime.org/projects/smack#" + this.currentCapsVersion, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            String oldCapsVersion = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider("http://www.igniterealtime.org/projects/smack#" + oldCapsVersion);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        caps.put(this.currentCapsVersion, discoverInfo);
        if (connection != null) {
            jidCaps.put(connection.getUser(), new NodeVerHash(ENTITY_NODE, this.currentCapsVersion, "sha-1"));
        }
        this.sdm.setNodeInformationProvider("http://www.igniterealtime.org/projects/smack#" + this.currentCapsVersion, new NodeInformationProvider(){
            List<String> features;
            List<DiscoverInfo.Identity> identities;
            List<PacketExtension> packetExtensions;
            {
                this.features = EntityCapsManager.this.sdm.getFeaturesList();
                this.identities = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getIdentities());
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfoAsList();
            }

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return this.identities;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
        if (connection != null && connection.isAuthenticated() && this.presenceSend) {
            Presence presence = new Presence(Presence.Type.available);
            connection.sendPacket(presence);
        }
    }

    public static boolean verifyDiscoverInfoVersion(String ver, String hash, DiscoverInfo info) {
        if (info.containsDuplicateIdentities()) {
            return false;
        }
        if (info.containsDuplicateFeatures()) {
            return false;
        }
        if (EntityCapsManager.verifyPacketExtensions(info)) {
            return false;
        }
        String calculatedVer = EntityCapsManager.generateVerificationString(info, hash);
        return ver.equals(calculatedVer);
    }

    protected static boolean verifyPacketExtensions(DiscoverInfo info) {
        LinkedList<FormField> foundFormTypes = new LinkedList<FormField>();
        for (PacketExtension pe : info.getExtensions()) {
            if (!pe.getNamespace().equals("jabber:x:data")) continue;
            DataForm df = (DataForm)pe;
            Iterator<FormField> it = df.getFields();
            while (it.hasNext()) {
                FormField f = it.next();
                if (!f.getVariable().equals("FORM_TYPE")) continue;
                for (FormField fft : foundFormTypes) {
                    if (!f.equals(fft)) continue;
                    return true;
                }
                foundFormTypes.add(f);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateVerificationString(DiscoverInfo discoverInfo, String hash) {
        MessageDigest md = SUPPORTED_HASHES.get(hash.toLowerCase());
        if (md == null) {
            return null;
        }
        DataForm extendedInfo = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        StringBuilder sb = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> sortedIdentities = new TreeSet<DiscoverInfo.Identity>();
        Iterator<DiscoverInfo.Identity> it = discoverInfo.getIdentities();
        while (it.hasNext()) {
            sortedIdentities.add(it.next());
        }
        for (DiscoverInfo.Identity identity : sortedIdentities) {
            sb.append(identity.getCategory());
            sb.append("/");
            sb.append(identity.getType());
            sb.append("/");
            sb.append(identity.getLanguage() == null ? "" : identity.getLanguage());
            sb.append("/");
            sb.append(identity.getName() == null ? "" : identity.getName());
            sb.append("<");
        }
        TreeSet<String> features = new TreeSet<String>();
        Iterator<DiscoverInfo.Feature> iterator = discoverInfo.getFeatures();
        while (iterator.hasNext()) {
            features.add(iterator.next().getVar());
        }
        for (String string : features) {
            sb.append(string);
            sb.append("<");
        }
        if (extendedInfo != null && extendedInfo.hasHiddenFormTypeField()) {
            DataForm dataForm = extendedInfo;
            synchronized (dataForm) {
                TreeSet<FormField> fs = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField f1, FormField f2) {
                        return f1.getVariable().compareTo(f2.getVariable());
                    }
                });
                FormField ft = null;
                Iterator<FormField> i = extendedInfo.getFields();
                while (i.hasNext()) {
                    FormField f2 = i.next();
                    if (!f2.getVariable().equals("FORM_TYPE")) {
                        fs.add(f2);
                        continue;
                    }
                    ft = f2;
                }
                if (ft != null) {
                    EntityCapsManager.formFieldValuesToCaps(ft.getValues(), sb);
                }
                for (FormField f3 : fs) {
                    sb.append(f3.getVariable());
                    sb.append("<");
                    EntityCapsManager.formFieldValuesToCaps(f3.getValues(), sb);
                }
            }
        }
        byte[] byArray = md.digest(sb.toString().getBytes());
        return Base64.encodeBytes(byArray);
    }

    private static void formFieldValuesToCaps(Iterator<String> i, StringBuilder sb) {
        TreeSet<String> fvs = new TreeSet<String>();
        while (i.hasNext()) {
            fvs.add(i.next());
        }
        for (String fv : fvs) {
            sb.append(fv);
            sb.append("<");
        }
    }

    /* synthetic */ EntityCapsManager(Connection connection, EntityCapsManager entityCapsManager) {
        this(connection);
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String node, String ver, String hash) {
            this.node = node;
            this.ver = ver;
            this.hash = hash;
            this.nodeVer = String.valueOf(node) + "#" + ver;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

