/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteCallableRequestType;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.rest.IRestCall;
import org.eclipse.ecf.remoteservice.rest.RestException;
import org.eclipse.ecf.remoteservice.rest.client.AbstractEntityRequestType;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRestClientService;
import org.eclipse.ecf.remoteservice.rest.client.HttpDeleteRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPatchRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPostRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPutRequestType;
import org.eclipse.ecf.remoteservice.rest.client.RestClientContainer;

public class RestClientService
extends AbstractRestClientService {
    public static final int socketTimeout = Integer.parseInt(System.getProperty("org.eclipse.ecf.remoteservice.rest.RestClientService.socketTimeout", "-1"));
    public static final int connectRequestTimeout = Integer.parseInt(System.getProperty("org.eclipse.ecf.remoteservice.rest.RestClientService.connectRequestTimeout", "-1"));
    public static final int connectTimeout = Integer.parseInt(System.getProperty("org.eclipse.ecf.remoteservice.rest.RestClientService.connectTimeout", "-1"));
    protected static final int DEFAULT_RESPONSE_BUFFER_SIZE = 1024;
    protected static final String DEFAULT_HTTP_CONTENT_CHARSET = "UTF-8";
    protected HttpClient httpClient = this.createHttpClient();
    protected int responseBufferSize = 1024;

    public RestClientService(RestClientContainer container, RemoteServiceClientRegistration registration) {
        super(container, registration);
    }

    protected HttpClient createHttpClient() {
        return HttpClientBuilder.create().build();
    }

    private boolean isResponseOk(HttpResponse response) {
        int isOkCode = response.getStatusLine().getStatusCode() - 200;
        return isOkCode >= 0 && isOkCode < 100;
    }

    protected HttpGet createGetMethod(String uri) {
        return new HttpGet(uri);
    }

    protected HttpPost createPostMethod(String uri) {
        return new HttpPost(uri);
    }

    protected HttpPut createPutMethod(String uri) {
        return new HttpPut(uri);
    }

    protected HttpDelete createDeleteMethod(String uri) {
        return new HttpDelete(uri);
    }

    protected HttpPatch createPatchMethod(String uri) {
        return new HttpPatch(uri);
    }

    protected HttpRequestBase createAndPrepareHttpMethod(AbstractClientService.UriRequest request) {
        HttpGetRequestType requestType;
        HttpGet httpMethod = null;
        String uri = request.getUri();
        IRemoteCallable callable = request.getRemoteCallable();
        HttpGetRequestType httpGetRequestType = requestType = callable == null ? new HttpGetRequestType() : callable.getRequestType();
        if (requestType instanceof HttpGetRequestType) {
            httpMethod = this.createGetMethod(uri);
        } else if (requestType instanceof HttpPatchRequestType) {
            httpMethod = this.createPatchMethod(uri);
        } else if (requestType instanceof HttpPostRequestType) {
            httpMethod = this.createPostMethod(uri);
        } else if (requestType instanceof HttpPutRequestType) {
            httpMethod = this.createPutMethod(uri);
        } else if (requestType instanceof HttpDeleteRequestType) {
            httpMethod = this.createDeleteMethod(uri);
        }
        this.prepareHttpMethod((HttpRequestBase)httpMethod, request.getRemoteCall(), callable);
        return httpMethod;
    }

    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        this.trace("invokeRemoteCall", "call=" + call + ";callable=" + callable);
        String endpointUri = this.prepareEndpointAddress(call, callable);
        this.trace("invokeRemoteCall", "prepared endpoint=" + endpointUri);
        AbstractClientService.UriRequest urirequest = this.createUriRequest(endpointUri, call, callable);
        HttpRequestBase httpMethod = urirequest == null ? this.createAndPrepareHttpMethod(endpointUri, call, callable) : this.createAndPrepareHttpMethod(urirequest);
        this.trace("invokeRemoteCall", "executing httpMethod" + httpMethod);
        byte[] responseBody = null;
        int responseCode = 500;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpMethod);
            this.trace("invokeRemoteCall", "httpMethod executed. response=" + response);
            responseCode = response.getStatusLine().getStatusCode();
            if (this.isResponseOk(response)) {
                responseBody = this.getResponseAsBytes(response);
            } else {
                if (this.retrieveErrorResponseBody(response)) {
                    responseBody = this.getResponseAsBytes(response);
                }
                this.handleException("Http response not OK.  httpMethod=" + httpMethod + " responseCode=" + Integer.valueOf(responseCode), null, responseCode, responseBody);
            }
        }
        catch (IOException e) {
            this.handleException("RestClientService transport IOException", e, responseCode);
        }
        Object result = null;
        try {
            Map responseHeaders = this.convertResponseHeaders(response.getAllHeaders());
            this.trace("processResponse", "httpMethod=" + httpMethod + ";call=" + call + ";callable=" + callable + ";responseHeaders=" + responseHeaders + ";responseBody=" + responseBody);
            result = this.processResponse(endpointUri, call, callable, responseHeaders, responseBody);
        }
        catch (NotSerializableException e) {
            this.handleException("Exception deserializing response.  httpMethod=" + httpMethod + " responseCode=" + Integer.valueOf(responseCode), e, responseCode);
        }
        return result;
    }

    protected boolean retrieveErrorResponseBody(HttpResponse response) {
        return false;
    }

    protected byte[] getResponseAsBytes(HttpResponse response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)os);
        return os.toByteArray();
    }

    protected void setupTimeouts(HttpClient httpClient, IRemoteCall call, IRemoteCallable callable) {
    }

    private Map convertResponseHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        int i = 0;
        while (i < headers.length) {
            String name = headers[i].getName();
            String value = headers[i].getValue();
            result.put(name, value);
            ++i;
        }
        return result;
    }

    protected void addRequestHeaders(AbstractHttpMessage httpMethod, IRemoteCall call, IRemoteCallable callable) {
        Map callHeaders;
        Map requestHeaders;
        Map map = requestHeaders = callable.getRequestType() instanceof AbstractRequestType ? ((AbstractRequestType)callable.getRequestType()).getDefaultRequestHeaders() : new HashMap();
        if (requestHeaders == null) {
            requestHeaders = new HashMap();
        }
        if (call instanceof IRestCall && (callHeaders = ((IRestCall)call).getRequestHeaders()) != null) {
            requestHeaders.putAll(requestHeaders);
        }
        Set keySet = requestHeaders.keySet();
        Object[] headers = keySet.toArray();
        int i = 0;
        while (i < headers.length) {
            String key = (String)headers[i];
            String value = (String)requestHeaders.get(key);
            httpMethod.addHeader(key, value);
            ++i;
        }
    }

    protected HttpRequestBase createAndPrepareHttpMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        HttpRequestBase httpMethod;
        block9: {
            httpMethod = null;
            IRemoteCallableRequestType requestType = callable.getRequestType();
            if (requestType == null) {
                throw new RestException("Request type for call cannot be null");
            }
            try {
                if (requestType instanceof HttpGetRequestType) {
                    httpMethod = this.prepareGetMethod(uri, call, callable);
                    break block9;
                }
                if (requestType instanceof HttpPatchRequestType) {
                    httpMethod = this.preparePatchMethod(uri, call, callable);
                    break block9;
                }
                if (requestType instanceof HttpPostRequestType) {
                    httpMethod = this.preparePostMethod(uri, call, callable);
                    break block9;
                }
                if (requestType instanceof HttpPutRequestType) {
                    httpMethod = this.preparePutMethod(uri, call, callable);
                    break block9;
                }
                if (requestType instanceof HttpDeleteRequestType) {
                    httpMethod = this.prepareDeleteMethod(uri, call, callable);
                    break block9;
                }
                throw new RestException("HTTP method " + requestType + " not supported");
            }
            catch (NotSerializableException e) {
                String message = "Could not serialize parameters for uri=" + uri + " call=" + call + " callable=" + callable;
                this.logException(message, e);
                throw new RestException(message);
            }
            catch (UnsupportedEncodingException e) {
                String message = "Could not serialize parameters for uri=" + uri + " call=" + call + " callable=" + callable;
                this.logException(message, e);
                throw new RestException(message);
            }
        }
        this.prepareHttpMethod(httpMethod, call, callable);
        return httpMethod;
    }

    protected void prepareHttpMethod(HttpRequestBase httpMethod, IRemoteCall call, IRemoteCallable callable) {
        this.addRequestHeaders((AbstractHttpMessage)httpMethod, call, callable);
        this.setupAuthenticaton(this.httpClient, httpMethod);
        this.setupHttpMethod(httpMethod, call, callable);
    }

    protected void setupHttpMethod(HttpRequestBase httpMethod, IRemoteCall call, IRemoteCallable callable) {
        RequestConfig defaultRequestConfig = httpMethod.getConfig();
        RequestConfig.Builder updatedRequestConfigBuilder = defaultRequestConfig == null ? RequestConfig.custom() : RequestConfig.copy((RequestConfig)defaultRequestConfig);
        updatedRequestConfigBuilder.setCircularRedirectsAllowed(true);
        updatedRequestConfigBuilder.setRedirectsEnabled(true);
        int sTimeout = socketTimeout;
        int scTimeout = connectTimeout;
        int scrTimeout = connectRequestTimeout;
        long callTimeout = call.getTimeout();
        if (callTimeout == IRemoteCall.DEFAULT_TIMEOUT) {
            callTimeout = callable.getDefaultTimeout();
        }
        if (callTimeout != IRemoteCall.DEFAULT_TIMEOUT) {
            scTimeout = scrTimeout = new Long(callTimeout).intValue();
            sTimeout = scrTimeout;
        }
        updatedRequestConfigBuilder.setSocketTimeout(sTimeout);
        updatedRequestConfigBuilder.setConnectTimeout(scTimeout);
        updatedRequestConfigBuilder.setConnectionRequestTimeout(scrTimeout);
        httpMethod.setConfig(updatedRequestConfigBuilder.build());
    }

    protected HttpRequestBase prepareDeleteMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        return new HttpDelete(uri);
    }

    protected HttpRequestBase preparePutMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException, UnsupportedEncodingException {
        HttpPut result = new HttpPut(uri);
        HttpPutRequestType putRequestType = (HttpPutRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (putRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                HttpEntity requestEntity = putRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setEntity((HttpEntity)this.getUrlEncodedFormEntity(Arrays.asList(params), putRequestType));
            }
        }
        return result;
    }

    protected HttpRequestBase preparePatchMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException, UnsupportedEncodingException {
        HttpPatch result = new HttpPatch(uri);
        HttpPostRequestType postRequestType = (HttpPostRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (postRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                HttpEntity requestEntity = postRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setEntity((HttpEntity)this.getUrlEncodedFormEntity(Arrays.asList(params), postRequestType));
            }
        }
        return result;
    }

    protected HttpRequestBase preparePostMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException, UnsupportedEncodingException {
        HttpPost result = new HttpPost(uri);
        HttpPostRequestType postRequestType = (HttpPostRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (postRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                HttpEntity requestEntity = postRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setEntity((HttpEntity)this.getUrlEncodedFormEntity(Arrays.asList(params), postRequestType));
            }
        }
        return result;
    }

    protected HttpRequestBase prepareGetMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
        URI httpURI = null;
        try {
            URIBuilder builder = new URIBuilder(uri);
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    builder.addParameter(params[i].getName(), params[i].getValue());
                    ++i;
                }
            }
            httpURI = builder.build();
        }
        catch (URISyntaxException e1) {
            throw new NotSerializableException("uri=" + uri + " does not have proper URI syntax");
        }
        return new HttpGet(httpURI);
    }

    protected UrlEncodedFormEntity getUrlEncodedFormEntity(List list, AbstractEntityRequestType postRequestType) throws UnsupportedEncodingException {
        if (postRequestType.defaultCharset != null) {
            return new UrlEncodedFormEntity(list, postRequestType.defaultCharset);
        }
        return new UrlEncodedFormEntity(list);
    }

    protected NameValuePair[] toNameValuePairs(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        IRemoteCallParameter[] restParameters = this.prepareParameters(uri, call, callable);
        ArrayList<BasicNameValuePair> nameValueList = new ArrayList<BasicNameValuePair>();
        if (restParameters != null) {
            int i = 0;
            while (i < restParameters.length) {
                String parameterValue = null;
                Object o = restParameters[i].getValue();
                if (o instanceof String) {
                    parameterValue = (String)o;
                } else if (o != null) {
                    parameterValue = o.toString();
                }
                if (parameterValue != null) {
                    nameValueList.add(new BasicNameValuePair(restParameters[i].getName(), parameterValue));
                }
                ++i;
            }
        }
        return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
    }

    protected void setupAuthenticaton(HttpClient httpClient, HttpRequestBase method) {
        IConnectContext connectContext = this.container.getConnectContextForAuthentication();
        if (connectContext != null) {
            NameCallback nameCallback = new NameCallback("");
            ObjectCallback passwordCallback = new ObjectCallback();
            Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
            CallbackHandler callbackHandler = connectContext.getCallbackHandler();
            if (callbackHandler == null) {
                return;
            }
            try {
                callbackHandler.handle(callbacks);
                String username = nameCallback.getName();
                String password = (String)passwordCallback.getObject();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                method.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)method, (HttpContext)new BasicHttpContext()));
            }
            catch (IOException e) {
                this.logException("IOException setting credentials for rest httpclient", e);
            }
            catch (UnsupportedCallbackException e) {
                this.logException("UnsupportedCallbackException setting credentials for rest httpclient", e);
            }
            catch (AuthenticationException e) {
                this.logException("AuthenticationException setting credentials for rest httpclient", e);
            }
        }
    }
}

