/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.internal.importexport.files.IImportStructureProvider;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class FileSystemStructureProvider
implements IImportStructureProvider {
    public static final FileSystemStructureProvider INSTANCE = new FileSystemStructureProvider();

    public List getChildren(Object element) {
        ArrayList<UniFilePlus> result = new ArrayList<UniFilePlus>(0);
        try {
            String[] children = ((File)element).list();
            int childrenLength = children == null ? 0 : children.length;
            result = new ArrayList(childrenLength);
            IRemoteFile[] childIRemoteFiles = ((UniFilePlus)element).listIRemoteFiles();
            if (childIRemoteFiles != null) {
                int i = 0;
                while (i < childrenLength) {
                    result.add(new UniFilePlus(childIRemoteFiles[i]));
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public InputStream getContents(Object element) {
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((File)element).getPath();
    }

    public String getLabel(Object element) {
        File file = (File)element;
        String name = file.getName();
        if (name == null || name.length() == 0) {
            return file.getPath();
        }
        return name;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }
}

