/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.idioms;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.xtext.idioms.AssignmentLocator;
import org.eclipse.ocl.xtext.idioms.GrammarDeclaration;
import org.eclipse.ocl.xtext.idioms.Idiom;
import org.eclipse.ocl.xtext.idioms.IdiomsModel;
import org.eclipse.ocl.xtext.idioms.IdiomsPackage;
import org.eclipse.ocl.xtext.idioms.LocatorDeclaration;
import org.eclipse.ocl.xtext.idioms.ReferredLocator;
import org.eclipse.ocl.xtext.idioms.ReferredSegment;
import org.eclipse.ocl.xtext.idioms.ReturnsLocator;
import org.eclipse.ocl.xtext.idioms.RuleLocator;
import org.eclipse.ocl.xtext.idioms.SegmentDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class IdiomsLinkingService
extends DefaultLinkingService {
    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        String text = this.getCrossRefNodeAsString(node);
        if (ref == IdiomsPackage.Literals.EPACKAGE_DECLARATION__EPACKAGE) {
            Resource resource = context.eResource();
            ResourceSet resourceSet = resource.getResourceSet();
            URI baseURI = resource.getURI();
            URI userURI = URI.createURI((String)text, (boolean)true);
            URI resolvedURI = userURI.resolve(baseURI);
            if (!resolvedURI.hasFragment()) {
                resolvedURI = resolvedURI.appendFragment("/");
            }
            EObject eObject = resourceSet.getEObject(resolvedURI, true);
            return Collections.singletonList(eObject);
        }
        if (ref == IdiomsPackage.Literals.GRAMMAR_DECLARATION__GRAMMAR) {
            Resource idiomsResource = context.eResource();
            ResourceSet resourceSet = idiomsResource.getResourceSet();
            URI baseURI = idiomsResource.getURI();
            URI userURI = URI.createURI((String)text, (boolean)true);
            URI resolvedURI = userURI.resolve(baseURI);
            Resource grammarResource = resourceSet.getResource(resolvedURI, true);
            return Collections.singletonList((EObject)grammarResource.getContents().get(0));
        }
        if (ref == IdiomsPackage.Literals.IDIOMS_IMPORT__IDIOMS_MODEL) {
            Resource resource = context.eResource();
            ResourceSet resourceSet = resource.getResourceSet();
            URI baseURI = resource.getURI();
            URI userURI = URI.createURI((String)text, (boolean)true);
            URI resolvedURI = userURI.resolve(baseURI);
            Resource importedResource = resourceSet.getResource(resolvedURI, true);
            return Collections.singletonList((EObject)importedResource.getContents().get(0));
        }
        if (ref == IdiomsPackage.Literals.ASSIGNMENT_LOCATOR__ECLASS) {
            AssignmentLocator assignmentLocator = (AssignmentLocator)context;
            EPackage ePackage = assignmentLocator.getEPackage();
            if (ePackage != null) {
                EClassifier eClassifier = ePackage.getEClassifier(text);
                if (eClassifier != null) {
                    return Collections.singletonList(eClassifier);
                }
                return Collections.emptyList();
            }
        } else if (ref == IdiomsPackage.Literals.ASSIGNMENT_LOCATOR__ESTRUCTURAL_FEATURE) {
            AssignmentLocator assignmentLocator = (AssignmentLocator)context;
            EClass eClass = assignmentLocator.getEClass();
            if (eClass != null) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(text);
                if (eStructuralFeature != null) {
                    return Collections.singletonList(eStructuralFeature);
                }
                return Collections.emptyList();
            }
        } else if (ref == IdiomsPackage.Literals.IDIOM__FOR_ECLASS) {
            Idiom idiom = (Idiom)context;
            EPackage ePackage = idiom.getForEPackage();
            if (ePackage != null) {
                EClassifier eClassifier = ePackage.getEClassifier(text);
                if (eClassifier != null) {
                    return Collections.singletonList(eClassifier);
                }
                return Collections.emptyList();
            }
        } else {
            if (ref == IdiomsPackage.Literals.REFERRED_LOCATOR__LOCATOR_DECLARATION) {
                LocatorDeclaration locator;
                ReferredLocator locatorRef = (ReferredLocator)context;
                IdiomsModel idiomsModel = locatorRef.getIdiomsModel();
                if (idiomsModel == null) {
                    idiomsModel = (IdiomsModel)EcoreUtil.getRootContainer((EObject)locatorRef);
                }
                if ((locator = idiomsModel.getOwnedLocator(text)) != null) {
                    return Collections.singletonList(locator);
                }
                return Collections.emptyList();
            }
            if (ref == IdiomsPackage.Literals.RETURNS_LOCATOR__ECLASS) {
                ReturnsLocator returnsLocator = (ReturnsLocator)context;
                EPackage ePackage = returnsLocator.getEPackage();
                if (ePackage != null) {
                    EClassifier eClassifier = ePackage.getEClassifier(text);
                    if (eClassifier != null) {
                        return Collections.singletonList(eClassifier);
                    }
                    return Collections.emptyList();
                }
            } else {
                if (ref == IdiomsPackage.Literals.REFERRED_SEGMENT__SEGMENT_DECLARATION) {
                    SegmentDeclaration segment;
                    ReferredSegment segmentRef = (ReferredSegment)context;
                    IdiomsModel idiomsModel = segmentRef.getIdiomsModel();
                    if (idiomsModel == null) {
                        idiomsModel = (IdiomsModel)EcoreUtil.getRootContainer((EObject)segmentRef);
                    }
                    if ((segment = idiomsModel.getOwnedSegment(text)) != null) {
                        return Collections.singletonList(segment);
                    }
                    return Collections.emptyList();
                }
                if (ref == IdiomsPackage.Literals.RULE_LOCATOR__REFERRED_GRAMMAR) {
                    IdiomsModel idiomsModel = (IdiomsModel)EcoreUtil.getRootContainer((EObject)context);
                    for (GrammarDeclaration grammar : idiomsModel.getOwnedGrammarDeclarations()) {
                        if (!text.equals(grammar.getAs())) continue;
                        return Collections.singletonList(grammar);
                    }
                    return Collections.emptyList();
                }
                if (ref == IdiomsPackage.Literals.RULE_LOCATOR__REFERRED_RULE) {
                    RuleLocator ruleLocator = (RuleLocator)context;
                    GrammarDeclaration referredGrammar = ruleLocator.getReferredGrammar();
                    for (AbstractRule rule : referredGrammar.getGrammar().getRules()) {
                        if (!text.equals(rule.getName())) continue;
                        return Collections.singletonList(rule);
                    }
                    return Collections.emptyList();
                }
            }
        }
        return super.getLinkedObjects(context, ref, node);
    }

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }
}

