/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.AbstractEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.widgets.Shell;

public class AlphaEffect
extends AbstractEffect {
    int start;
    int end;
    int step;
    Shell shell = null;

    public static void setAlpha(AnimationRunner runner, Shell w, int alpha, int duration, IMovement movement, Runnable onStop, Runnable onCancel) {
        AlphaEffect effect = new AlphaEffect(w, w.getAlpha(), alpha, duration, movement, onStop, onCancel);
        runner.runEffect(effect);
    }

    public static void fadeOnClose(Shell shell, int duration, IMovement easing) {
        AlphaEffect.fadeOnClose(shell, duration, easing, null);
    }

    public static void fadeOnClose(Shell shell, int duration, IMovement easing, AnimationRunner runner) {
        AnimationRunner useRunner = runner != null ? runner : new AnimationRunner();
        Runnable closeListener = () -> shell.dispose();
        shell.addListener(21, e -> {
            e.doit = false;
            AlphaEffect.setAlpha(useRunner, shell, 0, duration, easing, closeListener, null);
        });
    }

    public AlphaEffect(Shell shell, int start, int end, long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        super(lengthMilli, movement, onStop, onCancel);
        this.start = start;
        this.end = end;
        this.step = end - start;
        this.shell = shell;
        this.easingFunction.init(0.0, 1.0, (int)lengthMilli);
    }

    @Override
    public void applyEffect(long currentTime) {
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.setAlpha((int)((double)this.start + (double)this.step * this.easingFunction.getValue((int)currentTime)));
    }
}

