/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.action.Action;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.modisco.infra.browser.actions.LoadFacetsAction;
import org.eclipse.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.modisco.infra.browser.custom.TypeView;
import org.eclipse.modisco.infra.browser.dialogs.LoadCustomizationsDialog;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.osgi.util.NLS;

public class LoadCustomizationsAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public LoadCustomizationsAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.BrowserActionBarContributor_loadCustomization, 1);
        this.setToolTipText(Messages.BrowserActionBarContributor_loadCustomization);
        this.setImageDescriptor(ImageProvider.getInstance().getAddUiCustomIconDescriptor());
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            List registeredCustomizations = browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine().getRegisteredCustomizations();
            LoadCustomizationsDialog loadCustomizationsDialog = new LoadCustomizationsDialog(browser.getSite().getShell(), registeredCustomizations, browser.getReferencedEPackages());
            if (loadCustomizationsDialog.open() == 0) {
                try {
                    List<MetamodelView> selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
                    if (loadCustomizationsDialog.isLoadRequiredFacetsSelected()) {
                        this.loadFacetsForCustomizations(selectedCustomizations, browser);
                    }
                    browser.loadCustomizations(selectedCustomizations);
                }
                catch (Exception e) {
                    MoDiscoBrowserPlugin.logException(Messages.BrowserActionBarContributor_loadingCustomizationFailed, e);
                }
            }
        }
    }

    private void loadFacetsForCustomizations(List<MetamodelView> customizations, EcoreBrowser browser) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.BrowserActionBarContributor_missingRequiredFacet, (Object[])new Object[]{metaclassName, customizedFacetSet.getName(), customization.getName()}));
            }
            LoadFacetsAction.loadFacets(referencedFacets, browser);
        }
    }

    private Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = ModelUtils.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }
}

