/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.etypes.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.AnnotationValidator;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.etypes.provider.ModelElementItemProvider;
import org.eclipse.emf.cdo.etypes.provider.annotation.AnnotationItemProviderAdapterFactory;
import org.eclipse.emf.cdo.etypes.util.BasicAnnotationValidator;
import org.eclipse.emf.cdo.etypes.util.EtypesValidator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class AnnotationItemProvider
extends ModelElementItemProvider {
    private static final boolean DISABLE_LABEL_DECORATION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.etypes.provider.AnnotationItemProvider.DISABLE_LABEL_DECORATION");

    public AnnotationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected ComposeableAdapterFactory getRootAdapterFactory() {
        return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
    }

    protected AnnotationItemProviderAdapterFactory getAnnotationItemProviderAdapterFactory() {
        return this.adapterFactory instanceof AnnotationItemProviderAdapterFactory ? (AnnotationItemProviderAdapterFactory)this.adapterFactory : null;
    }

    protected BasicAnnotationValidator.Assistant getAssistant() {
        AnnotationItemProviderAdapterFactory annotationItemProviderAdapterFactory = this.getAnnotationItemProviderAdapterFactory();
        return annotationItemProviderAdapterFactory == null ? null : annotationItemProviderAdapterFactory.getAssistant();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptorsGen(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcePropertyDescriptor(object);
            this.addReferencesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.getAnnotationItemProviderAdapterFactory() != null) {
            this.itemPropertyDescriptors = null;
        }
        List<IItemPropertyDescriptor> propertyDescriptors = this.getPropertyDescriptorsGen(object);
        return propertyDescriptors;
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new SourcePropertyDescriptor());
    }

    protected void addReferencesPropertyDescriptor(Object object) {
        Annotation annotation;
        BasicAnnotationValidator.Assistant assistant = this.getAssistant();
        if (assistant != null && !assistant.isReferencesSupported(annotation = (Annotation)object) && annotation.getReferences().isEmpty()) {
            return;
        }
        this.itemPropertyDescriptors.add(new ReferencesPropertyDescriptor());
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(EtypesPackage.Literals.ANNOTATION__DETAILS);
            this.childrenFeatures.add(EtypesPackage.Literals.ANNOTATION__CONTENTS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Annotation"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        Annotation annotation = (Annotation)object;
        StringBuffer result = new StringBuffer();
        String source = annotation.getSource();
        if (source != null) {
            int index;
            int n = index = this.getParent(annotation) instanceof Annotation ? -1 : source.lastIndexOf("/");
            if (index == -1) {
                result.append(source);
            } else {
                result.append(source.substring(index + 1));
            }
        }
        return result.toString();
    }

    @Override
    public Object getStyledText(Object object) {
        ComposeableAdapterFactory rootAdapterFactory;
        EList references;
        StyledString styledString = new StyledString(this.getText(object));
        if (!DISABLE_LABEL_DECORATION && !(references = ((Annotation)object).getReferences()).isEmpty() && (rootAdapterFactory = this.getRootAdapterFactory()) != null) {
            StringBuilder builder = new StringBuilder();
            for (EObject reference : references) {
                String label;
                IItemLabelProvider labelProvider = (IItemLabelProvider)rootAdapterFactory.adapt((Notifier)reference, IItemLabelProvider.class);
                String string = label = labelProvider == null ? null : labelProvider.getText((Object)reference);
                if (StringUtil.isEmpty((String)label)) continue;
                StringUtil.appendSeparator((StringBuilder)builder, (String)", ");
                builder.append(label);
            }
            if (builder.length() != 0) {
                builder.insert(0, "  ");
                styledString.append(builder.toString(), StyledString.Style.DECORATIONS_STYLER);
            }
        }
        return styledString;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Annotation.class)) {
            case 1: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(EtypesPackage.Literals.ANNOTATION__DETAILS, EtypesFactory.eINSTANCE.create(EtypesPackage.Literals.STRING_TO_STRING_MAP_ENTRY)));
    }

    private static final class GroupPropertyDescriptor
    implements IItemPropertyDescriptor {
        private String label;
        private String description;
        private Object itemPropertySource;

        public GroupPropertyDescriptor(String label, String description, IItemPropertySource itemPropertySource) {
            this.label = label;
            this.description = description;
            this.itemPropertySource = itemPropertySource;
        }

        public void setPropertyValue(Object object, Object value) {
        }

        public void resetPropertyValue(Object object) {
        }

        public boolean isSortChoices(Object object) {
            return false;
        }

        public boolean isPropertySet(Object object) {
            return false;
        }

        public boolean isMultiLine(Object object) {
            return false;
        }

        public boolean isMany(Object object) {
            return false;
        }

        public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
            return false;
        }

        public Object getPropertyValue(Object object) {
            return this.itemPropertySource;
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            return new IItemLabelProvider(){

                public String getText(Object object) {
                    return "";
                }

                public Object getImage(Object object) {
                    return ItemPropertyDescriptor.NO_VALUE_IMAGE;
                }
            };
        }

        public String getId(Object object) {
            return this.label;
        }

        public Object getHelpContextIds(Object object) {
            return null;
        }

        public String[] getFilterFlags(Object object) {
            return null;
        }

        public Object getFeature(Object object) {
            return this.label;
        }

        public String getDisplayName(Object object) {
            return this.label;
        }

        public String getDescription(Object object) {
            return this.description;
        }

        public Collection<?> getChoiceOfValues(Object object) {
            return null;
        }

        public String getCategory(Object object) {
            return null;
        }

        public boolean canSetProperty(Object object) {
            return false;
        }
    }

    protected class ReferencesPropertyDescriptor
    extends ItemPropertyDescriptor {
        public ReferencesPropertyDescriptor() {
            super((AdapterFactory)AnnotationItemProvider.this.getRootAdapterFactory(), AnnotationItemProvider.this.getResourceLocator(), AnnotationItemProvider.this.getString("_UI_Annotation_references_feature"), AnnotationItemProvider.this.getString("_UI_Annotation_references_description"), (EStructuralFeature)EtypesPackage.Literals.ANNOTATION__REFERENCES, true, false, true, null, null, null);
        }

        public Collection<?> getChoiceOfValues(Object object) {
            Collection result = super.getChoiceOfValues(object);
            BasicAnnotationValidator.Assistant assistant = AnnotationItemProvider.this.getAssistant();
            if (assistant != null) {
                result = assistant.getValidReferences((Annotation)object, result);
            }
            return result;
        }
    }

    protected class SourcePropertyDescriptor
    extends ItemPropertyDescriptor {
        public SourcePropertyDescriptor() {
            super((AdapterFactory)AnnotationItemProvider.this.getRootAdapterFactory(), AnnotationItemProvider.this.getResourceLocator(), AnnotationItemProvider.this.getString("_UI_Annotation_source_feature"), AnnotationItemProvider.this.getString("_UI_Annotation_source_description"), (EStructuralFeature)EtypesPackage.Literals.ANNOTATION__SOURCE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null);
        }

        protected Object createPropertyValueWrapper(Object object, Object propertyValue) {
            List propertyClasses;
            Annotation annotation;
            BasicAnnotationValidator.Assistant assistant = AnnotationItemProvider.this.getAssistant();
            if (assistant != null && assistant.isValidLocation(annotation = (Annotation)object) && !(propertyClasses = assistant.getPropertyClasses(annotation.getModelElement())).isEmpty()) {
                AnnotationItemProviderAdapterFactory.Group group = new AnnotationItemProviderAdapterFactory.Group(propertyValue);
                HashMap<String, AnnotationItemProviderAdapterFactory.Group> categories = new HashMap<String, AnnotationItemProviderAdapterFactory.Group>();
                AnnotationItemProviderAdapterFactory annotationItemProviderAdapterFactory = AnnotationItemProvider.this.getAnnotationItemProviderAdapterFactory();
                boolean showInstances = annotationItemProviderAdapterFactory.isShowInstances(annotation);
                boolean onlyMisc = true;
                for (EClass propertyClass : propertyClasses) {
                    EObject instance = assistant.createInstance(propertyClass, annotation);
                    AnnotationItemProviderAdapterFactory.Group targetGroup = group;
                    if (showInstances) {
                        AnnotationItemProviderAdapterFactory.Group classGroup = new AnnotationItemProviderAdapterFactory.Group(instance);
                        String groupName = annotationItemProviderAdapterFactory.getGroupName(instance);
                        GroupPropertyDescriptor groupPropertyDescriptor = new GroupPropertyDescriptor(groupName, groupName, classGroup);
                        group.add(groupPropertyDescriptor);
                        targetGroup = classGroup;
                        categories.clear();
                        onlyMisc = true;
                    }
                    List<IItemPropertyDescriptor> propertyDescriptors = annotationItemProviderAdapterFactory.getPropertyDescriptors(instance, annotation, annotationItemProviderAdapterFactory.getResourceLocator());
                    for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                        AnnotationItemProviderAdapterFactory.Group categoryGroup;
                        String category = null;
                        if (propertyDescriptor instanceof AnnotationItemProviderAdapterFactory.DecategorizingItemPropertyDescritorDecorator) {
                            category = ((AnnotationItemProviderAdapterFactory.DecategorizingItemPropertyDescritorDecorator)propertyDescriptor).getCategory();
                        }
                        if ((categoryGroup = (AnnotationItemProviderAdapterFactory.Group)categories.get(category)) == null) {
                            categoryGroup = new AnnotationItemProviderAdapterFactory.Group(category);
                            categories.put(category, categoryGroup);
                            if (category == null) {
                                category = EcoreEditPlugin.INSTANCE.getString("_UI_Misc_property_category");
                            } else {
                                onlyMisc = false;
                            }
                            targetGroup.add(new GroupPropertyDescriptor(category, category, categoryGroup));
                        }
                        categoryGroup.add(propertyDescriptor);
                    }
                    if (!showInstances || !onlyMisc) continue;
                    List<IItemPropertyDescriptor> groupPropertyDescriptors = targetGroup.getPropertyDescriptors();
                    groupPropertyDescriptors.clear();
                    if (categories.isEmpty()) continue;
                    groupPropertyDescriptors.addAll(((AnnotationItemProviderAdapterFactory.Group)categories.values().iterator().next()).getPropertyDescriptors());
                }
                if (!showInstances && onlyMisc) {
                    List<IItemPropertyDescriptor> groupPropertyDescriptors = group.getPropertyDescriptors();
                    groupPropertyDescriptors.clear();
                    if (!categories.isEmpty()) {
                        groupPropertyDescriptors.addAll(((AnnotationItemProviderAdapterFactory.Group)categories.values().iterator().next()).getPropertyDescriptors());
                    }
                }
                return group;
            }
            return super.createPropertyValueWrapper(object, propertyValue);
        }

        public void setPropertyValue(Object object, Object value) {
            Annotation annotation = (Annotation)object;
            String source = annotation.getSource();
            String strippedValue = AnnotationItemProvider.this.stripToNull((String)value);
            if (strippedValue == null ? source != null : !strippedValue.equals(source)) {
                super.setPropertyValue(object, (Object)strippedValue);
            }
        }

        public Collection<?> getChoiceOfValues(Object object) {
            Annotation annotation = (Annotation)object;
            UniqueEList result = new UniqueEList();
            for (String annotationSource : AnnotationValidator.Registry.INSTANCE.getAnnotationSources()) {
                AnnotationValidator annotationValidator = AnnotationValidator.Registry.INSTANCE.getAnnotationValidator(annotationSource);
                if (annotationValidator.isValidLocation(annotation)) {
                    result.add(annotationSource);
                    continue;
                }
                result.remove(annotationSource);
            }
            String source = annotation.getSource();
            if (source != null) {
                result.add(source);
            }
            return result;
        }

        public boolean isChoiceArbitrary(Object object) {
            return true;
        }

        public IItemPropertyDescriptor.ValueHandler getValueHandler(Object object) {
            return new ItemPropertyDescriptor.DataTypeValueHandler((EDataType)this.feature.getEType()){

                protected Diagnostic validate(EDataType eDataType, Object instance) {
                    Annotation annotation = EtypesFactory.eINSTANCE.createAnnotation();
                    annotation.setSource((String)instance);
                    BasicDiagnostic diagnostic = new BasicDiagnostic();
                    EtypesValidator.INSTANCE.validateAnnotation_WellFormedSourceURI(annotation, (DiagnosticChain)diagnostic, null);
                    return diagnostic;
                }
            };
        }
    }
}

