/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.SourceModuleReorgChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveSourceModuleChange
extends SourceModuleReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;

    public MoveSourceModuleChange(ISourceModule cu, IScriptFolder newPackage) {
        super(cu, newPackage);
        this.fStampToRestore = -1L;
    }

    private MoveSourceModuleChange(IScriptFolder oldPackage, String cuName, IScriptFolder newPackage, long stampToRestore) {
        super(oldPackage.getHandleIdentifier(), newPackage.getHandleIdentifier(), oldPackage.getSourceModule(cuName).getHandleIdentifier());
        this.fStampToRestore = stampToRestore;
    }

    public String getName() {
        return MessageFormat.format(RefactoringCoreMessages.MoveSourceModuleChange_name, this.getCu().getElementName(), MoveSourceModuleChange.getPackageName(this.getDestinationPackage()));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }

    @Override
    Change doPerformReorg(IProgressMonitor pm) throws CoreException {
        ISourceModule moved;
        IResource movedResource;
        String newName = this.getNewName();
        String name = newName == null ? this.getCu().getElementName() : newName;
        long currentStamp = -1L;
        IResource resource = this.getCu().getResource();
        if (resource != null) {
            currentStamp = resource.getModificationStamp();
        }
        this.fUndoable = !this.getDestinationPackage().getSourceModule(name).exists();
        this.getCu().move((IModelElement)this.getDestinationPackage(), null, newName, true, pm);
        if (this.fStampToRestore != -1L && (movedResource = (moved = this.getDestinationPackage().getSourceModule(name)).getResource()) != null) {
            movedResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fUndoable) {
            return new MoveSourceModuleChange(this.getDestinationPackage(), this.getCu().getElementName(), this.getOldPackage(), currentStamp);
        }
        return null;
    }
}

