/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.switchtolsp;

import java.util.ArrayList;
import org.eclipse.cdt.lsp.internal.switchtolsp.Messages;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LinkHelper {
    public static final String SPARKLES = "\u2728 ";
    public static final String LINK_SPACER = " \u00b7 ";

    public static String A(String linkText) {
        return "<a>" + linkText + "</a>";
    }

    public static String getLinks(boolean showPreferenceLink) {
        StringBuilder message = new StringBuilder();
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(LinkHelper.A(Messages.SwitchToLsp_LearnMoreLink));
        if (showPreferenceLink) {
            texts.add(LinkHelper.A(Messages.SwitchToLsp_OpenPreferencesLink));
        }
        texts.add(LinkHelper.A(Messages.SwitchToLsp_GiveFeedbackLink));
        message.append(String.join((CharSequence)LINK_SPACER, texts));
        return message.toString();
    }

    public static boolean handleLinkClick(Shell parentShell, Event event) {
        if (event.text != null && event.text.equals(Messages.SwitchToLsp_LearnMoreLink)) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.cdt.lsp.doc/html/lsp_cpp_editor.html");
        } else if (event.text != null && event.text.equals(Messages.SwitchToLsp_OpenPreferencesLink)) {
            PreferenceDialog preferenceDialogOn = PreferencesUtil.createPreferenceDialogOn((Shell)parentShell, (String)"org.eclipse.cdt.lsp.editor.preferencePage", null, (Object)"HIGHLIGHT_PREFER_LSP");
            preferenceDialogOn.setBlockOnOpen(false);
            preferenceDialogOn.open();
        } else if (event.text != null && event.text.equals(Messages.SwitchToLsp_GiveFeedbackLink)) {
            Program.launch((String)"https://github.com/eclipse-cdt/cdt-lsp/issues/new/choose");
        } else if (event.text != null && event.text.equals(Messages.SwitchToLsp_InstallClangdLink)) {
            Program.launch((String)"https://clangd.llvm.org/installation#installing-clangd");
        } else if (event.text != null && event.text.equals(Messages.SwitchToLsp_WhatIsClangdLink)) {
            Program.launch((String)"https://clangd.llvm.org/");
        } else if (event.text != null && event.text.equals(Messages.SwitchToLsp_OpenClangdPreferencesLink)) {
            PreferenceDialog preferenceDialogOn = PreferencesUtil.createPreferenceDialogOn((Shell)parentShell, (String)"org.eclipse.cdt.lsp.clangd.editor.preferencePage", null, null);
            preferenceDialogOn.setBlockOnOpen(false);
            preferenceDialogOn.open();
        } else {
            return false;
        }
        return true;
    }
}

