/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.launch;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.cdt.core.build.ErrorBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration2;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetListener;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.TargetStatus;

public class CoreBuildLaunchBarTracker
implements ILaunchBarListener,
ILaunchTargetListener {
    public static final Object JOB_FAMILY_CORE_BUILD_LAUNCH_BAR_TRACKER = new Object();
    private final ILaunchBarManager launchBarManager = CDebugCorePlugin.getService(ILaunchBarManager.class);
    private final ICBuildConfigurationManager configManager = CDebugCorePlugin.getService(ICBuildConfigurationManager.class);
    private final IToolChainManager toolChainManager = CDebugCorePlugin.getService(IToolChainManager.class);
    private final ILaunchTargetManager targetManager = CDebugCorePlugin.getService(ILaunchTargetManager.class);
    private ILaunchMode lastMode;
    private ILaunchDescriptor lastDescriptor;
    private ILaunchTarget lastTarget;

    public CoreBuildLaunchBarTracker() {
        this.targetManager.addListener((ILaunchTargetListener)this);
    }

    public void reset() {
        this.lastMode = null;
        this.lastDescriptor = null;
        this.lastTarget = null;
    }

    public void dispose() {
        this.targetManager.removeListener((ILaunchTargetListener)this);
    }

    private void setActiveBuildConfig(final ILaunchMode mode, ILaunchDescriptor descriptor, final ILaunchTarget target) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project == null) {
            IResource[] mappedResources;
            ILaunchConfiguration configuration = this.launchBarManager.getLaunchConfiguration(descriptor, target);
            if (configuration == null) {
                return;
            }
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if (project == null && (mappedResources = configuration.getMappedResources()) != null && mappedResources.length > 0) {
                project = mappedResources[0].getProject();
            }
        }
        if (project == null || !this.configManager.supports(project)) {
            return;
        }
        final IProject finalProject = project;
        this.lastMode = mode;
        this.lastDescriptor = descriptor;
        this.lastTarget = target;
        Job job = new Job(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_Job){

            public boolean belongsTo(Object family) {
                return JOB_FAMILY_CORE_BUILD_LAUNCH_BAR_TRACKER == family;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashMap properties = new HashMap();
                    properties.putAll(CoreBuildLaunchBarTracker.this.lastTarget.getAttributes());
                    Collection tcs = CoreBuildLaunchBarTracker.this.toolChainManager.getToolChainsMatching(properties);
                    IBuildConfiguration[] buildConfig = null;
                    if (!tcs.isEmpty()) {
                        IBuildConfiguration[] iBuildConfigurationArray = finalProject.getBuildConfigs();
                        var7_8 = iBuildConfigurationArray.length;
                        int n = 0;
                        block5: while (n < var7_8) {
                            IBuildConfiguration config = iBuildConfigurationArray[n];
                            testConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(config);
                            if (testConfig != null && !(testConfig instanceof ErrorBuildConfiguration) && testConfig.getLaunchMode().equals(CoreBuildLaunchBarTracker.this.lastMode.getIdentifier()) && testConfig.getLaunchTarget().equals(CoreBuildLaunchBarTracker.this.lastTarget)) {
                                for (IToolChain tc : tcs) {
                                    if (!testConfig.getToolChain().equals(tc)) continue;
                                    buildConfig = testConfig;
                                    break block5;
                                }
                            }
                            ++n;
                        }
                        if (buildConfig == null) {
                            for (IToolChain toolChain : tcs) {
                                buildConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(finalProject, toolChain, mode.getIdentifier(), CoreBuildLaunchBarTracker.this.lastTarget, monitor);
                                if (buildConfig == null) {
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        IBuildConfiguration config;
                        Object error = String.format(InternalDebugCoreMessages.CoreBuildLaunchBarTracker_NoToolchainForTarget, target.getId());
                        if (!CoreBuildLaunchBarTracker.this.targetManager.getStatus(target).equals(TargetStatus.OK_STATUS)) {
                            error = (String)error + "\n" + InternalDebugCoreMessages.CoreBuildLaunchBarTracker_TargetNotAvailable;
                        }
                        testConfig = finalProject.getBuildConfigs();
                        int n = testConfig.length;
                        var7_8 = 0;
                        while (var7_8 < n) {
                            ICBuildConfiguration testConfig;
                            config = testConfig[var7_8];
                            if (!config.getName().equals("") && (testConfig = CoreBuildLaunchBarTracker.this.configManager.getBuildConfiguration(config)) instanceof ErrorBuildConfiguration) {
                                ((ErrorBuildConfiguration)testConfig).setErrorMessage((String)error);
                                buildConfig = testConfig;
                                break;
                            }
                            ++var7_8;
                        }
                        if (buildConfig == null) {
                            config = CoreBuildLaunchBarTracker.this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)ErrorBuildConfiguration.PROVIDER, finalProject, "!", monitor);
                            buildConfig = new ErrorBuildConfiguration(config, (String)error);
                            CoreBuildLaunchBarTracker.this.configManager.addBuildConfiguration(config, (ICBuildConfiguration)buildConfig);
                        }
                    }
                    if (buildConfig != null && !buildConfig.getBuildConfiguration().equals(finalProject.getActiveBuildConfig())) {
                        CoreModel m;
                        CoreModel coreModel = m = CoreModel.getDefault();
                        synchronized (coreModel) {
                            IProjectDescription desc = finalProject.getDescription();
                            IBuildConfiguration[] configs = finalProject.getBuildConfigs();
                            LinkedHashSet<String> names = new LinkedHashSet<String>();
                            IBuildConfiguration[] iBuildConfigurationArray = configs;
                            int n = configs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IBuildConfiguration config = iBuildConfigurationArray[n2];
                                names.add(config.getName());
                                ++n2;
                            }
                            names.add("");
                            names.remove(buildConfig.getBuildConfiguration().getName());
                            names.add(buildConfig.getBuildConfiguration().getName());
                            desc.setBuildConfigs(names.toArray(new String[0]));
                            desc.setActiveBuildConfig(buildConfig.getBuildConfiguration().getName());
                            finalProject.setDescription(desc, monitor);
                        }
                        ((ICBuildConfiguration2)buildConfig).setActive();
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
        job.schedule();
    }

    public void activeLaunchTargetChanged(ILaunchTarget target) {
        try {
            if (target == null || target.equals(ILaunchTarget.NULL_TARGET) || target.equals(this.lastTarget)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void launchTargetStatusChanged(ILaunchTarget target) {
        try {
            if (this.targetManager.getStatus(target).equals(TargetStatus.OK_STATUS)) {
                ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
                if (mode == null) {
                    return;
                }
                ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
                this.setActiveBuildConfig(mode, descriptor, target);
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchDescriptorChanged(ILaunchDescriptor descriptor) {
        try {
            if (descriptor == null || descriptor.equals(this.lastDescriptor)) {
                return;
            }
            ILaunchMode mode = this.launchBarManager.getActiveLaunchMode();
            if (mode == null) {
                return;
            }
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    public void activeLaunchModeChanged(ILaunchMode mode) {
        try {
            if (mode == null || mode.equals(this.lastMode)) {
                return;
            }
            ILaunchDescriptor descriptor = this.launchBarManager.getActiveLaunchDescriptor();
            ILaunchTarget target = this.launchBarManager.getActiveLaunchTarget();
            this.setActiveBuildConfig(mode, descriptor, target);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }
}

