/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.burningwave.core.classes.AnnotationSourceGenerator;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;

public class VariableSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -1218339549136277345L;
    private Collection<String> outerCode;
    private String elementPrefix;
    private Collection<AnnotationSourceGenerator> annotations;
    private String assignmentOperator;
    private String delimiter;
    private Integer modifier;
    private TypeDeclarationSourceGenerator type;
    private String name;
    private BodySourceGenerator valueBody;
    private Collection<TypeDeclarationSourceGenerator> usedTypes;

    private VariableSourceGenerator(TypeDeclarationSourceGenerator type, String name) {
        this.type = type;
        this.name = name;
        this.assignmentOperator = "= ";
        this.delimiter = ";";
    }

    public static VariableSourceGenerator create(Class<?> type, String name) {
        return new VariableSourceGenerator(TypeDeclarationSourceGenerator.create(type), name);
    }

    public static VariableSourceGenerator create(TypeDeclarationSourceGenerator type, String name) {
        return new VariableSourceGenerator(type, name);
    }

    public static VariableSourceGenerator create(TypeDeclarationSourceGenerator type) {
        return new VariableSourceGenerator(type, null);
    }

    public static VariableSourceGenerator create(String name) {
        return new VariableSourceGenerator(null, name);
    }

    public VariableSourceGenerator setElementPrefix(String elementPrefix) {
        this.elementPrefix = elementPrefix;
        return this;
    }

    public VariableSourceGenerator addModifier(Integer modifier) {
        this.modifier = this.modifier == null ? modifier : Integer.valueOf(this.modifier | modifier);
        return this;
    }

    public VariableSourceGenerator addOuterCode(String code) {
        Optional.ofNullable(this.outerCode).orElseGet(() -> {
            this.outerCode = new ArrayList<String>();
            return this.outerCode;
        }).add(code);
        return this;
    }

    public VariableSourceGenerator addOuterCodeLine(String code) {
        Optional.ofNullable(this.outerCode).orElseGet(() -> {
            this.outerCode = new ArrayList<String>();
            return this.outerCode;
        });
        if (!this.outerCode.isEmpty()) {
            this.outerCode.add("\n" + code);
        } else {
            this.outerCode.add(code);
        }
        return this;
    }

    public VariableSourceGenerator addAnnotation(AnnotationSourceGenerator annotation) {
        Optional.ofNullable(this.annotations).orElseGet(() -> {
            this.annotations = new ArrayList<AnnotationSourceGenerator>();
            return this.annotations;
        }).add(annotation);
        return this;
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.annotations).ifPresent(annotations -> {
            for (AnnotationSourceGenerator annotation : annotations) {
                types.addAll(annotation.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.type).ifPresent(type -> types.addAll(type.getTypeDeclarations()));
        Optional.ofNullable(this.valueBody).ifPresent(valueBody -> types.addAll(valueBody.getTypeDeclarations()));
        Optional.ofNullable(this.usedTypes).ifPresent(usedTypes -> types.addAll((Collection<TypeDeclarationSourceGenerator>)usedTypes));
        return types;
    }

    public VariableSourceGenerator setValue(String value) {
        return this.setValue(BodySourceGenerator.createSimple().addCode(value));
    }

    public VariableSourceGenerator setValue(BodySourceGenerator valueGenerator) {
        this.valueBody = valueGenerator;
        return this;
    }

    VariableSourceGenerator setAssignementOperator(String operator) {
        this.assignmentOperator = operator;
        return this;
    }

    VariableSourceGenerator setDelimiter(String separator) {
        this.delimiter = separator;
        return this;
    }

    public VariableSourceGenerator useType(Class<?> ... classes) {
        Optional.ofNullable(this.usedTypes).orElseGet(() -> {
            this.usedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.usedTypes;
        });
        for (Class<?> cls : classes) {
            this.usedTypes.add(TypeDeclarationSourceGenerator.create(cls));
        }
        return this;
    }

    private String getAnnotations() {
        return Optional.ofNullable(this.annotations).map(annts -> this.getOrEmpty((Collection<?>)annts, "\n") + "\n").orElseGet(() -> null);
    }

    @Override
    public String make() {
        String bodyCode = Optional.ofNullable(this.elementPrefix).orElseGet(() -> "") + this.getOrEmpty(Optional.ofNullable(this.outerCode).map(oc -> this.getOrEmpty(this.outerCode) + "\n").orElseGet(() -> null), this.getAnnotations(), Optional.ofNullable(this.modifier).map(mod -> Modifier.toString(this.modifier)).orElseGet(() -> null), this.type, this.name, Optional.ofNullable(this.valueBody).map(value -> this.assignmentOperator + value).orElseGet(() -> null)) + Optional.ofNullable(this.delimiter).orElseGet(() -> "");
        if (this.elementPrefix != null) {
            bodyCode = bodyCode.replaceAll("\n(.)", "\n" + this.elementPrefix + "$1");
        }
        return bodyCode;
    }
}

