/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableProgressMessage;
import org.mandas.docker.client.messages.ProgressDetail;

@JsonDeserialize(builder=ImmutableProgressMessage.Builder.class)
@Value.Immutable
public interface ProgressMessage {
    public static final String STATUS_DIGEST_PREFIX_16 = "Digest: ";
    public static final String STATUS_DIGEST_PREFIX_18 = "digest: ";
    public static final String STATUS_SIZE_PREFIX_18 = "size: ";

    @JsonProperty(value="id")
    @Nullable
    public String id();

    @JsonProperty(value="status")
    @Nullable
    public String status();

    @JsonProperty(value="stream")
    @Nullable
    public String stream();

    @JsonProperty(value="error")
    @Nullable
    public String error();

    @JsonProperty(value="progress")
    @Nullable
    public String progress();

    @JsonProperty(value="progressDetail")
    @Nullable
    public ProgressDetail progressDetail();

    public static Builder builder() {
        return ImmutableProgressMessage.builder();
    }

    @JsonIgnore
    @Value.Derived
    @Nullable
    default public String buildImageId() {
        String stream = this.stream();
        return stream != null && stream.startsWith("Successfully built") ? stream.substring(stream.lastIndexOf(32) + 1).trim() : null;
    }

    @JsonIgnore
    @Value.Derived
    @Nullable
    default public String digest() {
        String status = this.status();
        if (status == null) {
            return null;
        }
        if (status.startsWith(STATUS_DIGEST_PREFIX_16)) {
            return status.substring(STATUS_DIGEST_PREFIX_16.length()).trim();
        }
        int digestIndex = status.indexOf(STATUS_DIGEST_PREFIX_18);
        int sizeIndex = status.indexOf(STATUS_SIZE_PREFIX_18);
        if (digestIndex > -1 && sizeIndex > digestIndex) {
            int start = digestIndex + STATUS_DIGEST_PREFIX_18.length();
            return status.substring(start, sizeIndex - 1);
        }
        return null;
    }

    public static interface Builder {
        public Builder id(String var1);

        public Builder status(String var1);

        public Builder stream(String var1);

        public Builder error(String var1);

        public Builder progress(String var1);

        public Builder progressDetail(ProgressDetail var1);

        public ProgressMessage build();
    }
}

