/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.xsl.jaxp.debug.debugger.BreakPoint;
import org.eclipse.wst.xsl.jaxp.debug.debugger.IXSLDebugger;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.jaxp.debug.invoker.PipelineDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformationException;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.ConfigurationException;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.JAXPSAXProcessorInvoker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DebugRunner {
    private static final Log log = LogFactory.getLog(DebugRunner.class);
    private final BufferedReader requestIn;
    private final Writer requestOut;
    private final Writer eventOut;
    private final Writer generatedStream;
    private Socket eventSocket;
    private Socket requestSocket;
    private Socket generateSocket;

    public DebugRunner(BufferedReader requestIn, PrintWriter requestOut, PrintWriter eventOut, PrintWriter generatedStream) {
        this.requestOut = requestOut;
        this.requestIn = requestIn;
        this.eventOut = eventOut;
        this.generatedStream = generatedStream;
    }

    public DebugRunner(int requestPort, int eventPort, int generatePort) throws IOException {
        this.requestSocket = DebugRunner.getSocket(requestPort);
        this.eventSocket = DebugRunner.getSocket(eventPort);
        this.generateSocket = DebugRunner.getSocket(generatePort);
        this.requestIn = new BufferedReader(new InputStreamReader(this.requestSocket.getInputStream()));
        this.requestOut = new PrintWriter(this.requestSocket.getOutputStream(), true);
        this.eventOut = new PrintWriter(this.eventSocket.getOutputStream(), true);
        this.generatedStream = new BufferedWriter(new PrintWriter(this.generateSocket.getOutputStream(), true));
    }

    public void loop(IXSLDebugger debugger) throws TransformationException, IOException {
        debugger.setEventWriter(this.eventOut);
        debugger.setGeneratedWriter(this.generatedStream);
        this.eventOut.write("ready\n");
        this.eventOut.flush();
        log.debug((Object)"entering loop");
        try {
            String inputLine;
            while ((inputLine = this.requestIn.readLine()) != null) {
                BreakPoint breakpoint;
                String line;
                Variable var;
                String response = inputLine;
                log.debug((Object)("REQUEST:" + inputLine));
                Thread debuggerThread = null;
                if ("start".equals(inputLine)) {
                    debuggerThread = new Thread((Runnable)debugger, "debugger");
                    debuggerThread.start();
                } else if ("step into".equals(inputLine)) {
                    debugger.stepInto();
                } else if ("step over".equals(inputLine)) {
                    debugger.stepOver();
                } else if ("step return".equals(inputLine)) {
                    debugger.stepReturn();
                } else if ("suspend".equals(inputLine)) {
                    debugger.suspend();
                } else if ("resume".equals(inputLine)) {
                    debugger.resume();
                } else if ("stack".equals(inputLine)) {
                    response = debugger.stack();
                } else if (inputLine.startsWith("var")) {
                    String data = inputLine.substring("var".length() + 1);
                    int id = Integer.parseInt(data);
                    var = debugger.getVariable(id);
                    log.debug((Object)("var " + id + " = " + var));
                    response = String.valueOf(var.getScope()) + "&" + var.getName();
                } else if (inputLine.startsWith("value")) {
                    String data = inputLine.substring("value".length() + 1);
                    int id = Integer.parseInt(data);
                    var = debugger.getVariable(id);
                    response = String.valueOf(var.getType()) + "&" + var.getValueFirstLine();
                } else if (inputLine.startsWith("add")) {
                    int index = inputLine.lastIndexOf(32);
                    String file = inputLine.substring("add".length() + 1, index);
                    line = inputLine.substring(index + 1);
                    breakpoint = new BreakPoint(file, Integer.parseInt(line));
                    debugger.addBreakpoint(breakpoint);
                } else if (inputLine.startsWith("remove")) {
                    int index = inputLine.lastIndexOf(32);
                    String file = inputLine.substring("remove".length() + 1, index);
                    line = inputLine.substring(index + 1);
                    breakpoint = new BreakPoint(file, Integer.parseInt(line));
                    debugger.removeBreakpoint(breakpoint);
                } else {
                    response = "What?";
                }
                log.debug((Object)("RESPONSE:" + response));
                this.requestOut.write(String.valueOf(response) + "\n");
                this.requestOut.flush();
            }
        }
        catch (IOException e) {
            throw new TransformationException(e.getMessage(), e);
        }
        log.debug((Object)"exited loop");
        this.eventOut.write("terminated\n");
        this.eventOut.flush();
    }

    public void dispose() throws IOException {
        if (this.requestIn != null) {
            try {
                this.requestIn.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close request input stream", (Throwable)e);
            }
        }
        if (this.requestOut != null) {
            this.requestOut.close();
        }
        if (this.eventOut != null) {
            this.eventOut.close();
        }
        if (this.requestSocket != null) {
            try {
                this.requestSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close request socket", (Throwable)e);
            }
        }
        if (this.eventSocket != null) {
            try {
                this.eventSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close event socket", (Throwable)e);
            }
        }
    }

    private static Socket getSocket(int port) throws IOException {
        InetAddress localhost = InetAddress.getByName("localhost");
        ServerSocket serverSocket = new ServerSocket(port, 5, localhost);
        Socket clientSocket = serverSocket.accept();
        serverSocket.close();
        return clientSocket;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws SAXException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        log.info((Object)("javax.xml.transform.TransformerFactory=" + System.getProperty("javax.xml.transform.TransformerFactory")));
        log.info((Object)("java.endorsed.dirs=" + System.getProperty("java.endorsed.dirs")));
        String invokerClassName = args[0];
        File launchFile = new File(args[1]);
        String src = args[2];
        String target = args[3];
        String debuggerClassName = args[5];
        log.info((Object)("src: " + src));
        log.info((Object)("target: " + target));
        log.info((Object)("launchFile: " + launchFile));
        log.info((Object)("debugger: " + debuggerClassName));
        DebugRunner debugRunner = null;
        try {
            try {
                final IXSLDebugger debugger = DebugRunner.createDebugger(debuggerClassName);
                JAXPSAXProcessorInvoker invoker = new JAXPSAXProcessorInvoker(){

                    @Override
                    protected TransformerFactory createTransformerFactory() {
                        TransformerFactory tFactory = super.createTransformerFactory();
                        debugger.setTransformerFactory(tFactory);
                        return tFactory;
                    }

                    @Override
                    public void addStylesheet(URL stylesheet, Map parameters, Properties outputProperties, URIResolver resolver) throws TransformerConfigurationException {
                        InputSource inputsource = new InputSource(stylesheet.toString());
                        this.addStylesheet(new SAXSource(inputsource), resolver, parameters, outputProperties);
                    }

                    @Override
                    protected Transformer addStylesheet(Source source, URIResolver resolver, Map parameters, Properties outputProperties) throws TransformerConfigurationException {
                        Transformer transformer = super.addStylesheet(source, resolver, parameters, outputProperties);
                        debugger.addTransformer(transformer);
                        return transformer;
                    }
                };
                if (args.length == 9) {
                    int requestPort = Integer.parseInt(args[6]);
                    int eventPort = Integer.parseInt(args[7]);
                    int generatePort = Integer.parseInt(args[8]);
                    log.debug((Object)("requestPort: " + requestPort));
                    log.debug((Object)("eventPort: " + eventPort));
                    log.debug((Object)("generatePort: " + generatePort));
                    try {
                        debugRunner = new DebugRunner(requestPort, eventPort, generatePort);
                    }
                    catch (Exception e) {
                        DebugRunner.handleFatalError("Could not instantiate invoker: " + invokerClassName, e);
                    }
                } else {
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    debugRunner = new DebugRunner(br, new PrintWriter(System.out), new PrintWriter(System.err), null);
                    System.out.println("xsl>");
                }
                PipelineDefinition pipeline = new PipelineDefinition(launchFile);
                pipeline.configure(invoker);
                debugger.setInvoker(invoker);
                debugger.setSource(new URL(src));
                debugger.setTarget(new FileWriter(new File(target)));
                debugRunner.loop(debugger);
                return;
            }
            catch (IOException e) {
                DebugRunner.handleFatalError(e.getMessage(), e);
                if (debugRunner == null) return;
                try {
                    debugRunner.dispose();
                    return;
                }
                catch (IOException e2) {
                    DebugRunner.handleFatalError(e2.getMessage(), e2);
                }
                return;
            }
            catch (TransformationException e) {
                DebugRunner.handleFatalError(e.getMessage(), e);
                if (debugRunner == null) return;
                try {
                    debugRunner.dispose();
                    return;
                }
                catch (IOException e3) {
                    DebugRunner.handleFatalError(e3.getMessage(), e3);
                }
                return;
            }
            catch (ConfigurationException e) {
                DebugRunner.handleFatalError(e.getMessage(), e);
                if (debugRunner == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    debugRunner.dispose();
                    return;
                }
                catch (IOException e4) {
                    DebugRunner.handleFatalError(e4.getMessage(), e4);
                }
                return;
            }
        }
        finally {
            if (debugRunner != null) {
                try {
                    debugRunner.dispose();
                }
                catch (IOException e) {
                    DebugRunner.handleFatalError(e.getMessage(), e);
                }
            }
        }
    }

    private static IXSLDebugger createDebugger(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(classname);
        return (IXSLDebugger)clazz.newInstance();
    }

    private static void handleFatalError(String msg, Throwable t) {
        log.fatal((Object)msg, t);
        System.exit(1);
    }
}

