/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLTextPresenter;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaTypeHover;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class JavaInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected IEditorPart fEditor;
    protected IPartListener fPartListener;
    protected String fCurrentPerspective;
    protected IJavaEditorTextHover fImplementation;
    private IInformationControlCreator fPresenterControlCreator;

    public JavaInformationProvider(IEditorPart editor) {
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.fPartListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window != null ? window.getActivePage() : null;
        IPerspectiveDescriptor iPerspectiveDescriptor = perspective = page != null ? page.getPerspective() : null;
        if (perspective != null) {
            String perspectiveId = perspective.getId();
            if (this.fCurrentPerspective == null || this.fCurrentPerspective != perspectiveId) {
                this.fCurrentPerspective = perspectiveId;
                this.fImplementation = new JavaTypeHover();
                this.fImplementation.setEditor(this.fEditor);
            }
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return JavaWordFinder.findWord(textViewer.getDocument(), offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this.fImplementation != null && (s = this.fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new ControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private static final class ControlCreator
    extends AbstractReusableInformationControlCreator {
        private ControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            int shellStyle = 20;
            int style = 768;
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                BrowserInformationControl browserInformationControl = new BrowserInformationControl(parent, "org.eclipse.wst.jsdt.ui.javadocfont", true);
                browserInformationControl.setStatusText(EditorsUI.getTooltipAffordanceString());
                return browserInformationControl;
            }
            return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
        }
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == JavaInformationProvider.this.fEditor) {
                JavaInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(JavaInformationProvider.this.fPartListener);
                JavaInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            JavaInformationProvider.this.update();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            JavaInformationProvider.this.update();
        }
    }
}

