/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.library.AbstractSimpleOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IterableValue;

public class ExecutorMultipleIterationManager
extends AbstractIterationManager {
    protected final @NonNull TypeId returnTypeId;
    protected final @NonNull AbstractSimpleOperation body;
    private @Nullable Object accumulatorValue;
    protected final @NonNull CollectionValue collectionValue;
    private @NonNull List<@NonNull Iterator<@Nullable Object>> iteratorValues;
    private int @Nullable [] iteratorIndexes;
    private final @Nullable Object @NonNull [] arguments;

    @Deprecated
    public ExecutorMultipleIterationManager(@NonNull Executor executor, int iterators, @NonNull TypeId returnTypeId, @NonNull AbstractSimpleOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        this(executor, iterators, false, returnTypeId, body, collectionValue, accumulatorValue);
    }

    public ExecutorMultipleIterationManager(@NonNull Executor executor, int iterators, boolean hasCoIterators, @NonNull TypeId returnTypeId, @NonNull AbstractSimpleOperation body, @Nullable CollectionValue collectionValue, @Nullable Object accumulatorValue) {
        super(executor);
        this.returnTypeId = returnTypeId;
        this.body = body;
        this.iteratorIndexes = hasCoIterators ? new int[iterators] : null;
        this.accumulatorValue = accumulatorValue;
        this.collectionValue = ValueUtil.asCollectionValue(collectionValue);
        this.iteratorValues = new ArrayList<Iterator<Object>>(iterators);
        this.arguments = new Object[1 + (hasCoIterators ? 2 * iterators : iterators)];
        this.arguments[0] = this.collectionValue;
        int i = 0;
        while (i < iterators) {
            Iterator<@Nullable Object> iteratorValue = this.collectionValue.iterator();
            this.iteratorValues.add(iteratorValue);
            this.arguments[1 + i] = iteratorValue.hasNext() ? iteratorValue.next() : this.iteratorValues;
            ++i;
        }
        int[] iteratorIndexes2 = this.iteratorIndexes;
        if (iteratorIndexes2 != null) {
            int i2 = 0;
            while (i2 < iterators) {
                iteratorIndexes2[i2] = 1;
                this.arguments[1 + iterators + i2] = ValueUtil.ONE_VALUE;
                ++i2;
            }
        }
    }

    @Override
    public boolean advanceIterators() {
        int[] iteratorIndexes2 = this.iteratorIndexes;
        int iteratorCount = this.iteratorValues.size();
        int i = 0;
        while (i < iteratorCount) {
            Iterator<@Nullable Object> iteratorValue = this.iteratorValues.get(i);
            if (iteratorValue.hasNext()) {
                Object keyValue;
                this.arguments[1 + i] = keyValue = iteratorValue.next();
                if (iteratorIndexes2 != null) {
                    int n = i;
                    int n2 = iteratorIndexes2[n] + 1;
                    iteratorIndexes2[n] = n2;
                    this.arguments[1 + iteratorCount + i] = ValueUtil.integerValueOf(n2);
                }
                int j = i;
                while (--j >= 0) {
                    iteratorValue = this.collectionValue.iterator();
                    assert (iteratorValue.hasNext());
                    this.iteratorValues.set(j, iteratorValue);
                    this.arguments[1 + j] = keyValue = iteratorValue.next();
                    if (iteratorIndexes2 == null) continue;
                    iteratorIndexes2[j] = 1;
                    this.arguments[1 + iteratorCount + j] = ValueUtil.integerValueOf(1);
                }
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < iteratorCount) {
            this.arguments[1 + i] = this.iteratorValues;
            ++i;
        }
        return false;
    }

    @Override
    public @Nullable Object evaluateBody() {
        return this.body.evaluate(this.executor, this.returnTypeId, this.arguments);
    }

    @Override
    public @Nullable Object get() {
        if (this.iteratorValues.size() == 1) {
            return this.arguments[1];
        }
        return super.get();
    }

    @Override
    public @Nullable Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    @Override
    public @NonNull CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    @Override
    public @NonNull IterableValue getSourceIterable() {
        return this.collectionValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.arguments[1] != this.iteratorValues;
    }

    @Override
    public @Nullable Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        return null;
    }
}

