/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.query.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.ModelQuerySet;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryTypeCheckingException;
import org.eclipse.modisco.infra.query.runtime.ModelQueryContext;
import org.eclipse.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.modisco.infra.query.runtime.ModelQueryResult;
import org.eclipse.modisco.infra.query.runtime.RuntimeFactory;

@Deprecated
public abstract class AbstractModelQuery {
    private final ModelQuery modelQuery;
    private boolean checkResult = true;

    public AbstractModelQuery(ModelQuery modelQuery) {
        this.modelQuery = modelQuery;
    }

    public final ModelQuery getModelQuery() {
        return this.modelQuery;
    }

    public final synchronized List<ModelQueryResult> evaluate(ModelQueryContext context, List<ModelQueryParameterValue> parameterValues) {
        ArrayList<ModelQueryResult> resultList = new ArrayList<ModelQueryResult>();
        try {
            this.startEvaluate();
            for (EObject eObject : context.getSelectedModelElements()) {
                this.executeQuery(parameterValues, resultList, eObject);
            }
            for (Resource resource : context.getSelectedModels()) {
                TreeIterator treeIterator = resource.getAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject = (EObject)treeIterator.next();
                    this.executeQuery(parameterValues, resultList, eObject);
                }
            }
        }
        finally {
            this.endEvaluate();
        }
        return resultList;
    }

    protected void startEvaluate() {
    }

    protected void endEvaluate() {
    }

    public final ModelQueryResult evaluate(EObject context) {
        ModelQueryResult modelQueryResult = RuntimeFactory.eINSTANCE.createModelQueryResult();
        try {
            modelQueryResult.setSource(context);
            modelQueryResult.setValue(this.basicEvaluate(context, null));
        }
        catch (Exception e) {
            modelQueryResult.setException(e);
        }
        return modelQueryResult;
    }

    public final ModelQueryResult evaluate(EObject context, List<ModelQueryParameterValue> parameterValues) {
        ModelQueryResult modelQueryResult = RuntimeFactory.eINSTANCE.createModelQueryResult();
        try {
            modelQueryResult.setSource(context);
            modelQueryResult.setValue(this.basicEvaluate(context, parameterValues));
        }
        catch (Exception e) {
            modelQueryResult.setException(e);
        }
        return modelQueryResult;
    }

    private final void executeQuery(List<ModelQueryParameterValue> parameterValues, List<ModelQueryResult> resultList, EObject context) {
        ModelQueryResult modelQueryResult = RuntimeFactory.eINSTANCE.createModelQueryResult();
        resultList.add(modelQueryResult);
        modelQueryResult.setSource(context);
        boolean matched = this.modelQuery.getScope().size() == 0;
        Iterator queryScopes = this.modelQuery.getScope().iterator();
        while (queryScopes.hasNext() && !matched) {
            EClass eClass = (EClass)queryScopes.next();
            if (!eClass.isInstance((Object)context)) continue;
            matched = true;
        }
        if (matched && this.modelQuery.getScope().size() != 0) {
            try {
                Object result = this.basicEvaluate(context, parameterValues);
                modelQueryResult.setValue(result);
            }
            catch (ModelQueryException e) {
                modelQueryResult.setException((Exception)e);
            }
        } else {
            StringBuffer message = new StringBuffer();
            message.append("Wrong context type (for query " + this.toString() + "): ");
            message.append(context.eClass().getName());
            message.append(" found; expected scopes are {");
            int i = 0;
            while (i < this.modelQuery.getScope().size()) {
                EClass scope = (EClass)this.modelQuery.getScope().get(i);
                message.append(scope.getName());
                if (i != this.modelQuery.getScope().size() - 1) {
                    message.append(", ");
                }
                ++i;
            }
            message.append("}");
            ModelQueryTypeCheckingException e = new ModelQueryTypeCheckingException(message.toString());
            modelQueryResult.setException((Exception)e);
        }
    }

    public abstract Object basicEvaluate(EObject var1, List<ModelQueryParameterValue> var2) throws ModelQueryException;

    public final Object basicEvaluate(EObject context) throws ModelQueryException {
        return this.basicEvaluate(context, new ArrayList<ModelQueryParameterValue>());
    }

    protected final void checkResult(Object object) throws ModelQueryTypeCheckingException {
        if (this.modelQuery.getUpperBound() > 1 || this.modelQuery.getUpperBound() == -1) {
            if (!(object instanceof Collection)) {
                throw new ModelQueryTypeCheckingException("A collection is expected as result. The result is: " + object + " (on " + this.toString() + ")");
            }
            for (Object collectionElement : (Collection)object) {
                if (!this.checkResult || this.modelQuery.getReturnType().isInstance(collectionElement)) continue;
                ModelQueryTypeCheckingException e = new ModelQueryTypeCheckingException("Wrong result collection element type (" + this.modelQuery.getReturnType().getName() + " is expected): " + collectionElement + " (on " + this.toString() + ")");
                throw e;
            }
        } else {
            if (object instanceof Collection) {
                throw new ModelQueryTypeCheckingException("A " + this.modelQuery.getReturnType().getName() + " instance is expected as result. The result is: " + object + " (on " + this.toString() + ")");
            }
            if (this.checkResult && !this.modelQuery.getReturnType().isInstance(object) && object != null) {
                throw new ModelQueryTypeCheckingException("Wrong result type: " + object.getClass().getName() + " is returned while " + this.modelQuery.getReturnType().getInstanceClassName() + " is expected." + " (on " + this.toString() + ")");
            }
        }
    }

    public void setCheckResult(boolean checkResult) {
        this.checkResult = checkResult;
    }

    public String toString() {
        String querySetName;
        String queryName;
        if (this.modelQuery == null) {
            queryName = "null";
            querySetName = "null";
        } else {
            queryName = this.modelQuery.getName();
            ModelQuerySet modelQuerySet = this.modelQuery.getModelQuerySet();
            querySetName = modelQuerySet != null ? modelQuerySet.getName() : "null";
        }
        return String.valueOf(querySetName) + "::" + queryName;
    }
}

