/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor.formatter.objects;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;

public class FormattedObject {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_MODULE = 0;
    public static final int TYPE_OCL_MODEL = 1;
    public static final int TYPE_HELPER = 2;
    public static final int TYPE_MATCHED_RULE = 3;
    public static final int TYPE_OPERATOR_CALL_EXP = 4;
    public static final int TYPE_PARAMETER = 5;
    public static final int TYPE_BINDING = 6;
    public static final int TYPE_IN_PATTERN = 7;
    public static final int TYPE_OUT_PATTERN = 8;
    public static final int TYPE_COLLECTION_TYPE = 9;
    public static final int TYPE_OPERATION = 10;
    public static final int TYPE_ATTRIBUTE = 11;
    public static final int TYPE_TUPLE_EXP = 12;
    public static final int TYPE_COLLECTION_EXP = 13;
    public static final int TYPE_COLLECTION_OPERATION_CALL_EXP = 14;
    public static final int TYPE_NAVIGATION_OR_ATTRIBUTE_CALL_EXP = 15;
    public static final int TYPE_STRING_EXP = 16;
    public static final int TYPE_LIBRARY = 17;
    public static final int TYPE_QUERY = 18;
    public static final int TYPE_LAZY_MATCHED_RULE = 19;
    public static final int TYPE_ABSTRACT_MATCHED_RULE = 20;
    public static final int TYPE_ITERATOR_EXP = 21;
    public static final int TYPE_ITERATE_EXP = 22;
    public static final int TYPE_CALLED_RULE = 23;
    public static final int TYPE_RULE_VARIABLE_DECLARATION = 24;
    public static final int TYPE_OPERATION_CALL_EXP = 25;
    public static final int TYPE_IF_EXP = 26;
    public static final int TYPE_FOR_EXP = 27;
    public static final int TYPE_ACTION_BLOCK = 28;
    public static final int TYPE_OCL_MODEL_ELEMENT = 29;
    public static final int TYPE_SIMPLE_IN_PATTERN = 30;
    public static final int TYPE_LONE_OBJECT = 31;
    public static final int TYPE_LET_EXP = 32;
    public static final int TYPE_SIMPLE_OUT_PATTERN_ELEMENT = 33;
    public static final int TYPE_FOR_EACH_OUT_PATTERN_ELEMENT = 34;
    public static final int TYPE_OCL_UNDEFINED = 35;
    public static final int LINE_TYPE_NORMAL = 0;
    public static final int LINE_TYPE_HELPER_COMMENT = 1;
    public static final int LINE_TYPE_COMMENT = 2;
    public static final int LINE_TYPE_STRING = 3;
    public static final String REPLACEMENT = "OBJECT";
    public static final String RPLCMT_RGX = "(?:\\(\\s*)?OBJECT\\{\\d+\\}(?:\\s*\\))?";
    public static final String RPLCMT_RGX_GRPNM = "(?:\\(\\s*)?OBJECT\\{(\\d+)\\}(?:\\s*\\))?";
    private static int count = 0;
    protected String text;
    protected EObject eObject;
    protected int indentationLevel;
    protected int type;
    protected int number;
    protected List<FormattedObject> children;

    public FormattedObject(EObject eObject, String text) throws BadLocationException {
        this.eObject = eObject;
        this.text = text;
        this.indentationLevel = 0;
        this.type = FormattedObject.typeOf(eObject);
        this.number = count++;
        this.children = new ArrayList<FormattedObject>();
    }

    public FormattedObject(EObject eObject, String text, int indentationLevel) throws BadLocationException {
        this(eObject, text);
        this.indentationLevel = indentationLevel;
    }

    public FormattedObject getChild(int i) throws BadLocationException {
        EObject child = (EObject)this.eObject.eContents().get(i);
        return new FormattedObject(child, "");
    }

    public void addChildren(FormattedObject ... fo) {
        FormattedObject[] formattedObjectArray = fo;
        int n = fo.length;
        int n2 = 0;
        while (n2 < n) {
            FormattedObject child = formattedObjectArray[n2];
            this.children.add(child);
            ++n2;
        }
    }

    public static int typeOf(EObject obj) throws BadLocationException {
        if (FormattedObject.oclIsTypeOf(obj, "Module")) {
            return 0;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OclModel")) {
            return 1;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Helper")) {
            return 2;
        }
        if (FormattedObject.oclIsTypeOf(obj, "MatchedRule")) {
            return 3;
        }
        if (FormattedObject.oclIsTypeOf(obj, "LazyMatchedRule")) {
            return 19;
        }
        if (FormattedObject.oclIsTypeOf(obj, "AbstractMatchedRule")) {
            return 20;
        }
        if (FormattedObject.oclIsTypeOf(obj, "CalledRule")) {
            return 23;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OperatorCallExp")) {
            return 4;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Parameter") || FormattedObject.oclIsTypeOf(obj, "TupleTypeAttribute")) {
            return 5;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Binding")) {
            return 6;
        }
        if (FormattedObject.oclIsTypeOf(obj, "InPattern")) {
            return 7;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OutPattern")) {
            return 8;
        }
        if (FormattedObject.oclIsTypeOf(obj, "SequenceType") || FormattedObject.oclIsTypeOf(obj, "TupleType") || FormattedObject.oclIsTypeOf(obj, "SetType") || FormattedObject.oclIsTypeOf(obj, "BagType") || FormattedObject.oclIsTypeOf(obj, "OrderedSetType") || FormattedObject.oclIsTypeOf(obj, "MapType") || FormattedObject.oclIsTypeOf(obj, "CollectionType")) {
            return 9;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Operation")) {
            return 10;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Attribute")) {
            return 11;
        }
        if (FormattedObject.oclIsTypeOf(obj, "TupleExp")) {
            return 12;
        }
        if (FormattedObject.oclIsTypeOf(obj, "SequenceExp") || FormattedObject.oclIsTypeOf(obj, "TupleExp") || FormattedObject.oclIsTypeOf(obj, "SetExp") || FormattedObject.oclIsTypeOf(obj, "BagExp") || FormattedObject.oclIsTypeOf(obj, "OrderedSetExp") || FormattedObject.oclIsTypeOf(obj, "MapExp") || FormattedObject.oclIsTypeOf(obj, "CollectionExp")) {
            return 13;
        }
        if (FormattedObject.oclIsTypeOf(obj, "CollectionOperationCallExp")) {
            return 14;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OperationCallExp")) {
            return 25;
        }
        if (FormattedObject.oclIsTypeOf(obj, "NavigationOrAttributeCallExp")) {
            return 15;
        }
        if (FormattedObject.oclIsTypeOf(obj, "StringExp")) {
            return 16;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Library")) {
            return 17;
        }
        if (FormattedObject.oclIsTypeOf(obj, "Query")) {
            return 18;
        }
        if (FormattedObject.oclIsTypeOf(obj, "IteratorExp")) {
            return 21;
        }
        if (FormattedObject.oclIsTypeOf(obj, "IterateExp")) {
            return 22;
        }
        if (FormattedObject.oclIsTypeOf(obj, "RuleVariableDeclaration")) {
            return 24;
        }
        if (FormattedObject.oclIsTypeOf(obj, "IfExp")) {
            return 26;
        }
        if (FormattedObject.oclIsTypeOf(obj, "ForStat")) {
            return 27;
        }
        if (FormattedObject.oclIsTypeOf(obj, "ActionBlock")) {
            return 28;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OclModelElement")) {
            return 29;
        }
        if (FormattedObject.oclIsTypeOf(obj, "SimpleInPatternElement")) {
            return 30;
        }
        if (FormattedObject.oclIsTypeOf(obj, "BooleanExp") || FormattedObject.oclIsTypeOf(obj, "VariableExp") || FormattedObject.oclIsTypeOf(obj, "IntegerExp") || FormattedObject.oclIsTypeOf(obj, "RealExp") || FormattedObject.oclIsTypeOf(obj, "SetExp") || FormattedObject.oclIsTypeOf(obj, "BagExp") || FormattedObject.oclIsTypeOf(obj, "MapExp") || FormattedObject.oclIsTypeOf(obj, "OrderedSetExp") || FormattedObject.oclIsTypeOf(obj, "CollectionExp") || FormattedObject.oclIsTypeOf(obj, "StringType") || FormattedObject.oclIsTypeOf(obj, "IntegerType") || FormattedObject.oclIsTypeOf(obj, "RealType") || FormattedObject.oclIsTypeOf(obj, "BooleanType") || FormattedObject.oclIsTypeOf(obj, "OclAnyType") || FormattedObject.oclIsTypeOf(obj, "Iterator")) {
            return 31;
        }
        if (FormattedObject.oclIsTypeOf(obj, "LetExp")) {
            return 32;
        }
        if (FormattedObject.oclIsTypeOf(obj, "SimpleOutPatternElement")) {
            return 33;
        }
        if (FormattedObject.oclIsTypeOf(obj, "ForEachOutPatternElement")) {
            return 34;
        }
        if (FormattedObject.oclIsTypeOf(obj, "OclUndefinedExp")) {
            return 35;
        }
        return -1;
    }

    private static boolean oclIsTypeOf(EObject obj, String type) {
        return obj.eClass().getName().equals(type);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public List<FormattedObject> getChildren() {
        return this.children;
    }

    public int getNumber() {
        return this.number;
    }

    public String getReplacement() {
        return "OBJECT{" + this.number + "}";
    }

    public static void resetCounter() {
        count = 0;
    }

    public String toString() {
        return this.text;
    }
}

