/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProviderFactory;
import org.osgi.framework.Bundle;

public final class JSFCommonPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.jsf.common";
    public static final String copyright = "Copyright 2006 Oracle";
    private static List<ISymbolSourceProviderFactory> registeredSymbolSourceProviders;
    private static Map<String, AbstractContextSymbolFactory> registeredSymbolFactories;
    private static final String FACTORY_ATTRIBUTE_NAME = "factory";
    private static final String FACTORY_ATTRIBUTE_ID_NAME = "factoryId";
    private static final String SYMBOL_SOURCE_ID = "symbolSourceId";
    private static final String CONTEXT_SYMBOL_FACTORY = "contextSymbolFactory";
    public static final JSFCommonPlugin INSTANCE;
    private static Implementation plugin;

    static {
        INSTANCE = new JSFCommonPlugin();
    }

    public JSFCommonPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void log(Throwable e, String msg) {
        ILog log;
        Implementation plugin2 = JSFCommonPlugin.getPlugin();
        if (plugin2 != null && (log = JSFCommonPlugin.getPlugin().getLog()) != null) {
            log.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, e));
            return;
        }
        System.err.print(msg + ": ");
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    public static void log(int severity, String message, Throwable ex) {
        JSFCommonPlugin.getPlugin().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, ex));
    }

    public static void log(int severity, String message) {
        JSFCommonPlugin.log(severity, message, null);
    }

    public static ISymbolSourceProvider[] getSymbolSourceProvider() {
        return registeredSymbolSourceProviders.toArray(new ISymbolSourceProvider[0]);
    }

    public static synchronized List<ISymbolSourceProviderFactory> getSymbolSourceProviders() {
        if (registeredSymbolSourceProviders == null) {
            JSFCommonPlugin.registerProviders();
            if (registeredSymbolSourceProviders == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableList(registeredSymbolSourceProviders);
    }

    private static void registerProviders() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), "symbolSourceProvider");
        IExtension[] extensions = point.getExtensions();
        registeredSymbolSourceProviders = new ArrayList<ISymbolSourceProviderFactory>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (SYMBOL_SOURCE_ID.equals(element.getName()) && element.getAttribute(FACTORY_ATTRIBUTE_NAME) != null) {
                    String factoryClassName = element.getAttribute(FACTORY_ATTRIBUTE_NAME);
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            ISymbolSourceProviderFactory factory = (ISymbolSourceProviderFactory)factoryClass.newInstance();
                            registeredSymbolSourceProviders.add(factory);
                        }
                        catch (Exception e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol provider extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static synchronized Map<String, AbstractContextSymbolFactory> getSymbolFactories() {
        if (registeredSymbolFactories == null) {
            JSFCommonPlugin.registerSymbolFactories();
            if (registeredSymbolFactories == null) {
                throw new AssertionError((Object)"registerProviders failed");
            }
        }
        return Collections.unmodifiableMap(registeredSymbolFactories);
    }

    private static void registerSymbolFactories() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(plugin.getBundle().getSymbolicName(), CONTEXT_SYMBOL_FACTORY);
        IExtension[] extensions = point.getExtensions();
        registeredSymbolFactories = new HashMap<String, AbstractContextSymbolFactory>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String bundleId = extension.getContributor().getName();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (CONTEXT_SYMBOL_FACTORY.equals(element.getName()) && element.getAttribute(FACTORY_ATTRIBUTE_NAME) != null) {
                    String factoryClassName = element.getAttribute(FACTORY_ATTRIBUTE_NAME);
                    String factoryId = element.getAttribute(FACTORY_ATTRIBUTE_ID_NAME);
                    Bundle bundle = Platform.getBundle((String)bundleId);
                    if (bundle != null) {
                        try {
                            Class factoryClass = bundle.loadClass(factoryClassName);
                            AbstractContextSymbolFactory factory = (AbstractContextSymbolFactory)factoryClass.newInstance();
                            registeredSymbolFactories.put(factoryId, factory);
                        }
                        catch (InstantiationException e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol factory extension point", (Throwable)e));
                        }
                        catch (IllegalAccessException e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol factory extension point", (Throwable)e));
                        }
                        catch (ClassNotFoundException e) {
                            plugin.log(new Status(4, plugin.getBundle().getSymbolicName(), 0, "Error loading symbol factory extension point", (Throwable)e));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void log(Throwable t) {
        ILog log = JSFCommonPlugin.getPlugin().getLog();
        Status status = new Status(4, JSFCommonPlugin.getPlugin().getSymbolicName(), 0, "Caught exception", t);
        log.log((IStatus)status);
    }

    public static Class<?> loadClass(String className, String bundleId) {
        Class aClass = null;
        try {
            Bundle bundle;
            if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) != null) {
                aClass = bundle.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            JSFCommonPlugin.log(e);
        }
        return aClass;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public static final String SYMBOL_SOURCE_EXT_ID = "symbolSourceProvider";
        public static final String SYMBOL_FACTORY_EXT_ID = "contextSymbolFactory";

        public Implementation() {
            plugin = this;
        }
    }
}

