/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.VirtualNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.NamedColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaNamedColumn<PA extends NamedColumn.ParentAdapter, A extends NamedColumnAnnotation>
extends AbstractJavaContextModel<JpaContextModel>
implements JavaSpecifiedNamedColumn {
    protected final PA parentAdapter;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;
    protected Table dbTable;

    protected AbstractJavaNamedColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractJavaNamedColumn(PA parentAdapter, A columnAnnotation) {
        super(parentAdapter.getColumnParent());
        this.parentAdapter = parentAdapter;
        this.setColumnAnnotation(columnAnnotation);
        this.initialize(this.getColumnAnnotation());
    }

    protected void initialize(A columnAnnotation) {
        this.specifiedName = this.buildSpecifiedName(columnAnnotation);
        this.columnDefinition = this.buildColumnDefinition(columnAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.synchronizeWithResourceModel(this.getColumnAnnotation());
    }

    protected void synchronizeWithResourceModel(A columnAnnotation) {
        this.setSpecifiedName_(this.buildSpecifiedName(columnAnnotation));
        this.setColumnDefinition_(this.buildColumnDefinition(columnAnnotation));
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultName(this.buildDefaultName());
        this.setDbTable(this.buildDbTable());
    }

    public abstract A getColumnAnnotation();

    protected void setColumnAnnotation(A columnAnnotation) {
        if (columnAnnotation != null) {
            throw new IllegalArgumentException("this method must be overridden if the column annotation is not null: " + String.valueOf(columnAnnotation));
        }
    }

    protected void removeColumnAnnotationIfUnset() {
        if (this.getColumnAnnotation().isUnset()) {
            this.removeColumnAnnotation();
        }
    }

    protected abstract void removeColumnAnnotation();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (ObjectTools.notEquals((Object)this.specifiedName, (Object)name)) {
            this.getColumnAnnotation().setName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedName_(name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName(A columnAnnotation) {
        return columnAnnotation.getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.parentAdapter.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (ObjectTools.notEquals((Object)this.columnDefinition, (Object)columnDefinition)) {
            this.getColumnAnnotation().setColumnDefinition(columnDefinition);
            this.removeColumnAnnotationIfUnset();
            this.setColumnDefinition_(columnDefinition);
        }
    }

    protected void setColumnDefinition_(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    public String buildColumnDefinition(A columnAnnotation) {
        return columnAnnotation.getColumnDefinition();
    }

    protected Column getDbColumn() {
        return this.dbTable == null ? null : this.dbTable.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.dbTable;
    }

    protected void setDbTable(Table dbTable) {
        Table old = this.dbTable;
        this.dbTable = dbTable;
        this.firePropertyChanged("dbTable", old, dbTable);
    }

    protected Table buildDbTable() {
        return this.parentAdapter.resolveDbTable(this.getTableName());
    }

    @Override
    public String getTableName() {
        return this.parentAdapter.getDefaultTableName();
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos)) {
            return this.getJavaCandidateNames();
        }
        return null;
    }

    protected boolean nameTouches(int pos) {
        return this.getColumnAnnotation().nameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateNames() {
        return new TransformationIterable(this.getCandidateNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateNames() {
        return this.dbTable != null ? this.dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildValidator().validate(messages, reporter);
    }

    protected JpaValidator buildValidator() {
        return this.parentAdapter.buildColumnValidator(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getColumnAnnotation().getTextRange();
        return textRange != null ? textRange : this.parentAdapter.getValidationTextRange();
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.getValidationTextRange(this.getColumnAnnotation().getNameValidationTextRange());
    }

    @Override
    public boolean isVirtual() {
        return !this.getColumnAnnotation().isSpecified();
    }

    protected void initializeFrom(VirtualNamedColumn virtualColumn) {
        this.setSpecifiedName(virtualColumn.getName());
        this.setColumnDefinition(virtualColumn.getColumnDefinition());
    }

    public void toString(StringBuilder sb) {
        String table = this.getTableName();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

