/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.File;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.NB;
import org.kohsuke.args4j.Option;

@Command(usage="usage_TextHashFunctions")
class TextHashFunctions
extends TextBuiltin {
    final Hash sha1 = new Hash(){
        private final MessageDigest md = Constants.newMessageDigest();

        protected int hashRegion(byte[] raw, int ptr, int end) {
            this.md.reset();
            this.md.update(raw, ptr, end - ptr);
            return NB.decodeInt32((byte[])this.md.digest(), (int)0);
        }
    };
    final Hash djb = new Hash(){

        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            while (ptr < end) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    final Hash string_hash31 = new Hash(){

        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 0;
            while (ptr < end) {
                hash = 31 * hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    final Hash rabin_DeltaIndex = new Hash(){
        private final byte[] buf16 = new byte[16];
        private final int[] T;
        {
            int[] nArray = new int[256];
            nArray[1] = -725175507;
            nArray[2] = 2102121847;
            nArray[3] = -1450351014;
            nArray[4] = 777066947;
            nArray[5] = -90723602;
            nArray[6] = 1394265268;
            nArray[7] = -2015592551;
            nArray[8] = 1554133894;
            nArray[9] = -2006679381;
            nArray[10] = 568977137;
            nArray[11] = -181447204;
            nArray[12] = 1928538693;
            nArray[13] = -1506436760;
            nArray[14] = 263782194;
            nArray[15] = -612479969;
            nArray[16] = 1837290529;
            nArray[17] = -1186699508;
            nArray[18] = 281608534;
            nArray[19] = -1005604229;
            nArray[20] = 1137954274;
            nArray[21] = -1760198961;
            nArray[22] = 1050155157;
            nArray[23] = -362894408;
            nArray[24] = 824240039;
            nArray[25] = -437889910;
            nArray[26] = 1282093776;
            nArray[27] = -1733459459;
            nArray[28] = 527564388;
            nArray[29] = -877179575;
            nArray[30] = 1647979283;
            nArray[31] = -1224959938;
            nArray[32] = 264444783;
            nArray[33] = -620386238;
            nArray[34] = 1921568280;
            nArray[35] = -1504805579;
            nArray[36] = 563217068;
            nArray[37] = -178998911;
            nArray[38] = 1557780443;
            nArray[39] = -2011208458;
            nArray[40] = 1398876393;
            nArray[41] = -2019058748;
            nArray[42] = 774569374;
            nArray[43] = -85176653;
            nArray[44] = 2100310314;
            nArray[45] = -1443462649;
            nArray[46] = 8119389;
            nArray[47] = -725788816;
            nArray[48] = 1648480078;
            nArray[49] = -1232634781;
            nArray[50] = 520755769;
            nArray[51] = -875779820;
            nArray[52] = 1276171917;
            nArray[53] = -1730779744;
            nArray[54] = 828048378;
            nArray[55] = -442650409;
            nArray[56] = 1055128776;
            nArray[57] = -366653467;
            nArray[58] = 1135094207;
            nArray[59] = -1754359150;
            nArray[60] = 280159499;
            nArray[61] = -999008730;
            nArray[62] = 1845047420;
            nArray[63] = -1187019951;
            nArray[64] = 528889566;
            nArray[65] = -884963853;
            nArray[66] = 1657660329;
            nArray[67] = -1240772476;
            nArray[68] = 836185885;
            nArray[69] = -451830736;
            nArray[70] = 1285356138;
            nArray[71] = -1738913465;
            nArray[72] = 1126434136;
            nArray[73] = -1746749835;
            nArray[74] = 1047515183;
            nArray[75] = -357997822;
            nArray[76] = 1836391579;
            nArray[77] = -1179406410;
            nArray[78] = 272550380;
            nArray[79] = -990348607;
            nArray[80] = 1912922879;
            nArray[81] = -1497214510;
            nArray[82] = 256849800;
            nArray[83] = -611744603;
            nArray[84] = 1549138748;
            nArray[85] = -2003613679;
            nArray[86] = 555626059;
            nArray[87] = -170353306;
            nArray[88] = 782684537;
            nArray[89] = -94346668;
            nArray[90] = 1408041998;
            nArray[91] = -2027178205;
            nArray[92] = 16238778;
            nArray[93] = -734954601;
            nArray[94] = 2109480397;
            nArray[95] = -1451577632;
            nArray[96] = 272969137;
            nArray[97] = -998007140;
            nArray[98] = 1829697734;
            nArray[99] = -1178055701;
            nArray[100] = 1041511538;
            nArray[101] = -355301537;
            nArray[102] = 1130356997;
            nArray[103] = -1751559640;
            nArray[104] = 1290214967;
            nArray[105] = -1742623462;
            nArray[106] = 833407808;
            nArray[107] = -446007187;
            nArray[108] = 1656096756;
            nArray[109] = -1234127655;
            nArray[110] = 536728195;
            nArray[111] = -885300818;
            nArray[112] = 2110257552;
            nArray[113] = -1459533123;
            nArray[114] = 9186535;
            nArray[115] = -733306934;
            nArray[116] = 1402396755;
            nArray[117] = -2024778882;
            nArray[118] = 786248996;
            nArray[119] = -98859511;
            nArray[120] = 560318998;
            nArray[121] = -173835973;
            nArray[122] = 1546526561;
            nArray[123] = -1998017460;
            nArray[124] = 255120341;
            nArray[125] = -604872456;
            nArray[126] = 1920927394;
            nArray[127] = -1497778801;
            nArray[128] = 1057779132;
            nArray[129] = -339026287;
            nArray[130] = 1111996619;
            nArray[131] = -1769927706;
            nArray[132] = 291337343;
            nArray[133] = -979646638;
            nArray[134] = 1813422344;
            nArray[135] = -1194323419;
            nArray[136] = 1672371770;
            nArray[137] = -1217860329;
            nArray[138] = 518359885;
            nArray[139] = -903661472;
            nArray[140] = 1308575737;
            nArray[141] = -1724255020;
            nArray[142] = 817140366;
            nArray[143] = -462282333;
            nArray[144] = 1385085341;
            nArray[145] = -2042099024;
            nArray[146] = 801467626;
            nArray[147] = -83632185;
            nArray[148] = 2095030366;
            nArray[149] = -1474751629;
            nArray[150] = 26506537;
            nArray[151] = -715995644;
            nArray[152] = 237799963;
            nArray[153] = -622184138;
            nArray[154] = 1936154476;
            nArray[155] = -1482560447;
            nArray[156] = 545100760;
            nArray[157] = -189062923;
            nArray[158] = 1563838127;
            nArray[159] = -1980697214;
            nArray[160] = 818902739;
            nArray[161] = -469121538;
            nArray[162] = 1300538276;
            nArray[163] = -1723723639;
            nArray[164] = 513699600;
            nArray[165] = -900146115;
            nArray[166] = 1674951271;
            nArray[167] = -1223489206;
            nArray[168] = 1819100501;
            nArray[169] = -1196689800;
            nArray[170] = 287739938;
            nArray[171] = -975166705;
            nArray[172] = 1111252118;
            nArray[173] = -1761939525;
            nArray[174] = 1064798689;
            nArray[175] = -340706612;
            nArray[176] = 1565369074;
            nArray[177] = -1987374625;
            nArray[178] = 537294725;
            nArray[179] = -188693336;
            nArray[180] = 1931262769;
            nArray[181] = -1478883300;
            nArray[182] = 240610886;
            nArray[183] = -627974805;
            nArray[184] = 32477556;
            nArray[185] = -718724519;
            nArray[186] = 2091140099;
            nArray[187] = -1469909202;
            nArray[188] = 801015991;
            nArray[189] = -76006502;
            nArray[190] = 1391812032;
            nArray[191] = -2043416851;
            nArray[192] = 545938274;
            nArray[193] = -196286385;
            nArray[194] = 1572965909;
            nArray[195] = -1996014280;
            nArray[196] = 249250465;
            nArray[197] = -635571828;
            nArray[198] = 1938855894;
            nArray[199] = -1487526661;
            nArray[200] = 2083023076;
            nArray[201] = -1460741175;
            nArray[202] = 23313811;
            nArray[203] = -710603074;
            nArray[204] = 1383690535;
            nArray[205] = -2034253302;
            nArray[206] = 791848016;
            nArray[207] = -67889283;
            nArray[208] = 1292406595;
            nArray[209] = -1714537362;
            nArray[210] = 809720372;
            nArray[211] = -460986087;
            nArray[212] = 1666815616;
            nArray[213] = -1214306899;
            nArray[214] = 504513527;
            nArray[215] = -892014374;
            nArray[216] = 296402117;
            nArray[217] = -982773784;
            nArray[218] = 1826711986;
            nArray[219] = -1205347681;
            nArray[220] = 1073456390;
            nArray[221] = -348318165;
            nArray[222] = 1118859377;
            nArray[223] = -1770601636;
            nArray[224] = 793329677;
            nArray[225] = -74452192;
            nArray[226] = 1375901050;
            nArray[227] = -2033965481;
            nArray[228] = 18373070;
            nArray[229] = -706811165;
            nArray[230] = 2085850297;
            nArray[231] = -1466613868;
            nArray[232] = 1944810379;
            nArray[233] = -1490173786;
            nArray[234] = 245409532;
            nArray[235] = -630843951;
            nArray[236] = 1572497992;
            nArray[237] = -1988306587;
            nArray[238] = 552714047;
            nArray[239] = -197719022;
            nArray[240] = 1120637996;
            nArray[241] = -1777522943;
            nArray[242] = 1065369947;
            nArray[243] = -347671946;
            nArray[244] = 1822068207;
            nArray[245] = -1201914174;
            nArray[246] = 298932376;
            nArray[247] = -988288075;
            nArray[248] = 510240682;
            nArray[249] = -894495609;
            nArray[250] = 1663202013;
            nArray[251] = -1209744912;
            nArray[252] = 809025129;
            nArray[253] = -453112508;
            nArray[254] = 1299409694;
            nArray[255] = -1716135885;
            this.T = nArray;
        }

        protected int hashRegion(byte[] raw, int ptr, int end) {
            if (end - ptr < 16) {
                Arrays.fill(this.buf16, (byte)0);
                System.arraycopy(raw, ptr, this.buf16, 0, end - ptr);
                return this.rabin(this.buf16, 0);
            }
            return this.rabin(raw, ptr);
        }

        private int rabin(byte[] raw, int ptr) {
            int hash = (raw[ptr] & 0xFF) << 24 | (raw[ptr + 1] & 0xFF) << 16 | (raw[ptr + 2] & 0xFF) << 8 | raw[ptr + 3] & 0xFF;
            hash ^= this.T[hash >>> 31];
            hash = (hash << 8 | raw[ptr + 4] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 5] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 6] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 7] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 8] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 9] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 10] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 11] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 12] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 13] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 14] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 15] & 0xFF) ^ this.T[hash >>> 23];
            return hash;
        }
    };
    final Fold truncate = new Fold(){

        @Override
        public int fold(int hash, int bits) {
            return hash & (1 << bits) - 1;
        }
    };
    final Fold golden_ratio = new Fold(){

        @Override
        public int fold(int hash, int bits) {
            return hash * -1640562687 >>> 32 - bits;
        }
    };
    @Option(name="--hash", metaVar="NAME", usage="Enable hash function(s)")
    List<String> hashFunctions = new ArrayList<String>();
    @Option(name="--fold", metaVar="NAME", usage="Enable fold function(s)")
    List<String> foldFunctions = new ArrayList<String>();
    @Option(name="--text-limit", metaVar="LIMIT", usage="Maximum size in KiB to scan")
    int textLimit = 15360;
    @Option(name="--repository", aliases={"-r"}, metaVar="GIT_DIR", usage="Repository to scan")
    List<File> gitDirs = new ArrayList<File>();

    TextHashFunctions() {
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        if (this.gitDirs.isEmpty()) {
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(this.gitdir))).readEnvironment()).findGitDir();
            if (rb.getGitDir() == null) {
                throw TextHashFunctions.die(CLIText.get().cantFindGitDirectory);
            }
            this.gitDirs.add(rb.getGitDir());
        }
        for (File dir : this.gitDirs) {
            RepositoryBuilder rb = new RepositoryBuilder();
            if (RepositoryCache.FileKey.isGitRepository((File)dir, (FS)FS.DETECTED)) {
                rb.setGitDir(dir);
            } else {
                rb.findGitDir(dir);
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (Repository repo = rb.build();){
                this.run(repo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Repository repo) throws Exception {
        long lineCnt;
        long fileCnt;
        List<Function> all;
        block31: {
            all = this.init();
            fileCnt = 0L;
            lineCnt = 0L;
            Throwable throwable = null;
            Object var8_7 = null;
            try {
                ObjectReader or = repo.newObjectReader();
                try {
                    block30: {
                        RevWalk rw = new RevWalk(or);
                        try {
                            try (TreeWalk tw = new TreeWalk(or);){
                                MutableObjectId id = new MutableObjectId();
                                tw.reset((AnyObjectId)rw.parseTree((AnyObjectId)repo.resolve("HEAD")));
                                tw.setRecursive(true);
                                while (tw.next()) {
                                    Iterator<Function> iterator;
                                    byte[] raw;
                                    FileMode fm = tw.getFileMode(0);
                                    if (!FileMode.REGULAR_FILE.equals(fm) && !FileMode.EXECUTABLE_FILE.equals(fm)) continue;
                                    try {
                                        tw.getObjectId(id, 0);
                                        raw = or.open((AnyObjectId)id).getCachedBytes(this.textLimit * 1024);
                                    }
                                    catch (LargeObjectException tooBig) {
                                        continue;
                                    }
                                    if (RawText.isBinary((byte[])raw, (int)raw.length, (boolean)true)) continue;
                                    RawText txt = new RawText(raw);
                                    int[] lines = new int[txt.size()];
                                    int cnt = 0;
                                    HashSet<Line> u = new HashSet<Line>();
                                    int i = 0;
                                    while (true) {
                                        if (i >= txt.size()) {
                                            ++fileCnt;
                                            lineCnt += (long)cnt;
                                            iterator = all.iterator();
                                            break;
                                        }
                                        if (u.add(new Line(txt, i))) {
                                            lines[cnt++] = i;
                                        }
                                        ++i;
                                    }
                                    while (iterator.hasNext()) {
                                        Function fun = iterator.next();
                                        TextHashFunctions.testOne(fun, txt, lines, cnt);
                                    }
                                }
                            }
                            if (rw == null) break block30;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (rw == null) throw throwable;
                            rw.close();
                            throw throwable;
                        }
                        rw.close();
                    }
                    if (or == null) break block31;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (or == null) throw throwable;
                    or.close();
                    throw throwable;
                }
                or.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        File directory = repo.getDirectory();
        if (directory != null) {
            String name = directory.getName();
            File parent = directory.getParentFile();
            if (name.equals(".git") && parent != null) {
                name = parent.getName();
            }
            this.outw.println(name + ":");
        }
        this.outw.format("  %6d files; %5d avg. unique lines/file\n", new Object[]{fileCnt, lineCnt / fileCnt});
        this.outw.format("%-20s %-15s %9s\n", new Object[]{"Hash", "Fold", "Max Len"});
        this.outw.println("-----------------------------------------------");
        String lastHashName = null;
        Iterator<Function> iterator = all.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.outw.println();
                this.outw.flush();
                return;
            }
            Function fun = iterator.next();
            String hashName = fun.hash.name;
            if (hashName.equals(lastHashName)) {
                hashName = "";
            }
            this.outw.format("%-20s %-15s %9d\n", new Object[]{hashName, fun.fold.name, fun.maxChainLength});
            lastHashName = fun.hash.name;
        }
    }

    private static void testOne(Function fun, RawText txt, int[] elements, int cnt) {
        Hash cmp = fun.hash;
        Fold fold = fun.fold;
        int bits = TextHashFunctions.tableBits(cnt);
        int[] buckets = new int[1 << bits];
        int i = 0;
        while (i < cnt) {
            int n = fold.fold(cmp.hash(txt, elements[i]), bits);
            buckets[n] = buckets[n] + 1;
            ++i;
        }
        int maxChainLength = 0;
        int i2 = 0;
        while (i2 < buckets.length) {
            maxChainLength = Math.max(maxChainLength, buckets[i2]);
            ++i2;
        }
        fun.maxChainLength = Math.max(fun.maxChainLength, maxChainLength);
    }

    private List<Function> init() {
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        ArrayList<Fold> folds = new ArrayList<Fold>();
        try {
            Field[] fieldArray = TextHashFunctions.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.getType() == Hash.class) {
                    f.setAccessible(true);
                    Hash cmp = (Hash)((Object)f.get(this));
                    cmp.name = f.getName();
                    hashes.add(cmp);
                } else if (f.getType() == Fold.class) {
                    f.setAccessible(true);
                    Fold fold = (Fold)f.get(this);
                    fold.name = f.getName();
                    folds.add(fold);
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Cannot determine names", e);
        }
        ArrayList<Function> all = new ArrayList<Function>();
        for (Hash cmp : hashes) {
            if (!TextHashFunctions.include(cmp.name, this.hashFunctions)) continue;
            for (Fold f : folds) {
                if (!TextHashFunctions.include(f.name, this.foldFunctions)) continue;
                all.add(new Function(cmp, f));
            }
        }
        return all;
    }

    private static boolean include(String name, List<String> want) {
        if (want.isEmpty()) {
            return true;
        }
        for (String s : want) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static int tableBits(int sz) {
        int bits = 31 - Integer.numberOfLeadingZeros(sz);
        if (bits == 0) {
            bits = 1;
        }
        if (1 << bits < sz) {
            ++bits;
        }
        return bits;
    }

    private static abstract class Fold {
        String name;

        private Fold() {
        }

        abstract int fold(int var1, int var2);
    }

    private static class Function {
        final Hash hash;
        final Fold fold;
        int maxChainLength;

        Function(Hash cmp, Fold fold) {
            this.hash = cmp;
            this.fold = fold;
        }
    }

    private static abstract class Hash
    extends RawTextComparator {
        String name;

        private Hash() {
        }

        public boolean equals(RawText a, int ai, RawText b, int bi) {
            return RawTextComparator.DEFAULT.equals((Sequence)a, ai, (Sequence)b, bi);
        }
    }

    private static class Line {
        private final RawText txt;
        private final int pos;

        Line(RawText txt, int pos) {
            this.txt = txt;
            this.pos = pos;
        }

        public int hashCode() {
            return RawTextComparator.DEFAULT.hash(this.txt, this.pos);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Line) {
                Line e = (Line)obj;
                return RawTextComparator.DEFAULT.equals((Sequence)this.txt, this.pos, (Sequence)e.txt, e.pos);
            }
            return false;
        }
    }
}

