/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.impl;

import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.oda.ecore.impl.DataTypes;
import org.eclipse.emf.oda.ecore.util.StringUtil;

public abstract class ResultSetMetaData
implements IResultSetMetaData {
    public static IResultSetMetaData create(EClassifier type) {
        if (type instanceof org.eclipse.emf.ecore.EClass) {
            return new EClass((org.eclipse.emf.ecore.EClass)type);
        }
        return new EDataType((org.eclipse.emf.ecore.EDataType)type);
    }

    protected ResultSetMetaData() {
    }

    protected int checkBounds(int index) throws OdaException {
        if (index < 1 || index > this.getColumnCount()) {
            throw new OdaException((Throwable)new IndexOutOfBoundsException(String.valueOf(index)));
        }
        return index;
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getColumnName(index);
    }

    protected abstract EClassifier getColumnClassifier(int var1) throws OdaException;

    public int getColumnType(int index) throws OdaException {
        return DataTypes.getType(this.getColumnClassifier(this.checkBounds(index)));
    }

    public String getColumnTypeName(int index) throws OdaException {
        return DataTypes.getTypeName(this.getColumnClassifier(this.checkBounds(index)));
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return DataTypes.getDisplayLength(this.getColumnClassifier(this.checkBounds(index)));
    }

    public int getPrecision(int index) throws OdaException {
        return DataTypes.getPrecision(this.getColumnClassifier(this.checkBounds(index)));
    }

    public int getScale(int index) throws OdaException {
        return DataTypes.getScale(this.getColumnClassifier(this.checkBounds(index)));
    }

    public int isNullable(int index) throws OdaException {
        switch (DataTypes.isNullable(this.getColumnClassifier(this.checkBounds(index)))) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    protected static class EClass
    extends ResultSetMetaData {
        protected static final String FIRST_COLUMN_NAME = "@self";
        protected final org.eclipse.emf.ecore.EClass type;

        protected EClass(org.eclipse.emf.ecore.EClass type) {
            this.type = type;
        }

        public int getColumnCount() throws OdaException {
            return this.type.getEAllStructuralFeatures().size() + 1;
        }

        public String getColumnName(int index) throws OdaException {
            if (this.checkBounds(index) == 1) {
                return FIRST_COLUMN_NAME;
            }
            return this.type.getEStructuralFeature(index - 2).getName();
        }

        @Override
        public String getColumnLabel(int index) throws OdaException {
            return this.checkBounds(index) > 1 ? StringUtil.getFeatureText(this.type.getEStructuralFeature(index - 2)) : super.getColumnLabel(index);
        }

        @Override
        protected EClassifier getColumnClassifier(int index) throws OdaException {
            return this.checkBounds(index) == 1 ? this.type : this.type.getEStructuralFeature(index - 2).getEType();
        }
    }

    protected static class EDataType
    extends ResultSetMetaData {
        protected static final String FIRST_COLUMN_NAME = "@value";
        protected final org.eclipse.emf.ecore.EDataType type;

        protected EDataType(org.eclipse.emf.ecore.EDataType type) {
            this.type = type;
        }

        public int getColumnCount() throws OdaException {
            return 1;
        }

        public String getColumnName(int index) throws OdaException {
            return FIRST_COLUMN_NAME;
        }

        @Override
        protected EClassifier getColumnClassifier(int index) throws OdaException {
            return this.type;
        }
    }
}

