/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure.builders;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.dltk.tcl.structure.AbstractTclCommandModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclTypeHandler;
import org.eclipse.dltk.tcl.structure.ITclTypeResolver;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;
import org.eclipse.emf.common.util.EList;

public class TclNamespaceModelBuilder
extends AbstractTclCommandModelBuilder {
    @Override
    public boolean process(TclCommand command, ITclModelBuildContext context) {
        EList arguments = command.getArguments();
        if (arguments.isEmpty()) {
            this.report(context, (Node)command, "Syntax error: a namespace subcommand expected.", ProblemSeverities.Error);
            return false;
        }
        String subcmd = TclProcessorUtil.asString((TclArgument)arguments.get(0));
        if (!"eval".equals(subcmd)) {
            return false;
        }
        if (arguments.size() < 3) {
            this.report(context, (Node)command, "Syntax error: namespace eval: name and script expected", ProblemSeverities.Error);
            return false;
        }
        TclArgument nameArg = (TclArgument)arguments.get(1);
        IElementRequestor.TypeInfo ti = new IElementRequestor.TypeInfo();
        ti.declarationStart = command.getStart();
        ti.nameSourceStart = nameArg.getStart();
        ti.nameSourceEnd = nameArg.getEnd() - 1;
        ti.name = TclNamespaceModelBuilder.asSymbol(nameArg);
        ti.modifiers = 2048;
        ITclTypeHandler typeHanlder = context.get(ITclTypeResolver.class).resolveType(ti, command.getEnd(), ti.name);
        context.addHandler(command, typeHanlder);
        if (arguments.size() == 3 && arguments.get(2) instanceof Script) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        int offset = ((TclArgument)arguments.get(2)).getStart();
        int i = 2;
        while (i < arguments.size()) {
            TclArgument argument = (TclArgument)arguments.get(i);
            String value = SimpleCodePrinter.getArgumentString((TclArgument)argument, (int)argument.getStart());
            int start = 0;
            int end = value.length();
            if (end >= 2 && value.charAt(0) == '{' && value.charAt(end - 1) == '}') {
                ++start;
                --end;
            }
            while (end > start && Character.isWhitespace(value.charAt(end - 1))) {
                --end;
            }
            while (start < end && Character.isWhitespace(value.charAt(start))) {
                ++start;
            }
            int j = offset + sb.length() - start;
            while (j < argument.getStart()) {
                sb.append(' ');
                ++j;
            }
            sb.append(value, start, end);
            ++i;
        }
        context.parse(sb.toString(), offset);
        context.leave(command);
        return false;
    }
}

