/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.slf4j;

import org.osgi.service.log.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

class EquinoxLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private final Logger logger;

    EquinoxLogger(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public boolean isTraceEnabled() {
        return this.logger != null && this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.trace(msg, (Object)t);
        }
    }

    public void trace(String format, Object arg1) {
        if (this.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            this.logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void trace(String format, Object ... argArray) {
        if (this.isTraceEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.trace(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isDebugEnabled() {
        return this.logger != null && this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(msg, (Object)t);
        }
    }

    public void debug(String format, Object arg1) {
        if (this.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            this.logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void debug(String format, Object ... argArray) {
        if (this.isDebugEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.debug(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isInfoEnabled() {
        return this.logger != null && this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(msg, (Object)t);
        }
    }

    public void info(String format, Object arg1) {
        if (this.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            this.logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void info(String format, Object ... argArray) {
        if (this.isInfoEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.info(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isWarnEnabled() {
        return this.logger != null && this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.warn(msg, (Object)t);
        }
    }

    public void warn(String format, Object arg1) {
        if (this.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            this.logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void warn(String format, Object ... argArray) {
        if (this.isWarnEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.warn(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public boolean isErrorEnabled() {
        return this.logger != null && this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.error(msg, (Object)t);
        }
    }

    public void error(String format, Object arg1) {
        if (this.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1);
            this.logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
            this.logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }

    public void error(String format, Object ... argArray) {
        if (this.isErrorEnabled()) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
            this.logger.error(tp.getMessage(), (Object)tp.getThrowable());
        }
    }
}

