/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.bfs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;

public class BFS<V> {
    private BFS() {
    }

    public static <V> boolean isReachable(V source, V target, IGraphDataSource<V> graph) {
        ArrayList<V> nodeQueue = new ArrayList<V>();
        HashSet<V> visited = new HashSet<V>();
        nodeQueue.add(source);
        visited.add(source);
        boolean ret = BFS._isReachable(target, graph, nodeQueue, visited);
        return ret;
    }

    private static <V> boolean _isReachable(V target, IGraphDataSource<V> graph, List<V> nodeQueue, Set<V> visited) {
        while (!nodeQueue.isEmpty()) {
            V node = nodeQueue.remove(0);
            for (Object t : graph.getTargetNodes(node).distinctValues()) {
                if (t.equals(target)) {
                    return true;
                }
                if (visited.contains(t)) continue;
                visited.add(t);
                nodeQueue.add(t);
            }
        }
        return false;
    }

    public static <V> Set<V> reachableSources(IBiDirectionalGraphDataSource<V> graph, V target) {
        HashSet<V> retSet = new HashSet<V>();
        retSet.add(target);
        ArrayList<V> nodeQueue = new ArrayList<V>();
        nodeQueue.add(target);
        BFS._reachableSources(graph, nodeQueue, retSet);
        return retSet;
    }

    private static <V> void _reachableSources(IBiDirectionalGraphDataSource<V> graph, List<V> nodeQueue, Set<V> retSet) {
        while (!nodeQueue.isEmpty()) {
            V node = nodeQueue.remove(0);
            for (Object _node : graph.getSourceNodes(node).distinctValues()) {
                if (retSet.contains(_node)) continue;
                retSet.add(_node);
                nodeQueue.add(_node);
            }
        }
    }

    public static <V> Set<V> reachableTargets(IGraphDataSource<V> graph, V source) {
        HashSet<V> retSet = new HashSet<V>();
        retSet.add(source);
        ArrayList<V> nodeQueue = new ArrayList<V>();
        nodeQueue.add(source);
        BFS._reachableTargets(graph, nodeQueue, retSet);
        return retSet;
    }

    private static <V> void _reachableTargets(IGraphDataSource<V> graph, List<V> nodeQueue, Set<V> retSet) {
        while (!nodeQueue.isEmpty()) {
            V node = nodeQueue.remove(0);
            for (Object _node : graph.getTargetNodes(node).distinctValues()) {
                if (retSet.contains(_node)) continue;
                retSet.add(_node);
                nodeQueue.add(_node);
            }
        }
    }

    public static <V> Set<V> collectNodesAlongPath(V source, V target, IGraphDataSource<V> graph) {
        HashSet path = new HashSet();
        BFS._collectNodesAlongPath(source, target, graph, path);
        return path;
    }

    private static <V> boolean _collectNodesAlongPath(V node, V target, IGraphDataSource<V> graph, Set<V> path) {
        boolean res = false;
        if (node.equals(target)) {
            path.add(node);
            return true;
        }
        for (Object _nodeT : graph.getTargetNodes(node).distinctValues()) {
            boolean bl = res = BFS._collectNodesAlongPath(_nodeT, target, graph, path) || res;
        }
        if (res) {
            path.add(node);
        }
        return res;
    }
}

